#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          GWTOP - Topology         */
/*        MS-WINDOWS front end       */
/*                                   */
/*           Topology window         */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


/*
  be sure that IOTOP.C is recompiled and that
  it iotop.obj from a GWSIM compilation is not
  being used now. To be sure, delete iotop.obj
*/

/* this is needed for IOTOP.C */
#define GWTOP

#include <windows.h>
#include <string.h>
#include "commdlg.h"
#include "basic.h"						/* basic windows fnction prototypes		*/
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwtop.h"						/* macros, function prototypes, etc.	*/
#include "gep1.h"						/* gepasi's variables					*/
#include "strtbl.h"						/* symbols for the string table			*/
#include "iotop.h"

#pragma alloc_text( CODE0, WinMain, WndProc, AboutBox, nCwRegisterClasses, CwUnRegisterClasses, CleanUp )

#define HELP_PARTIALKEY   0x0105


/* Struct pointed to by WM_GETMINMAXINFO lParam
typedef struct tagMINMAXINFO
{
    POINT ptReserved;
    POINT ptMaxSize;
    POINT ptMaxPosition;
    POINT ptMinTrackSize;
    POINT ptMaxTrackSize;
} MINMAXINFO;
*/

/* global variables	*/
char szString[128];   /* variable to load resource strings         */
char szHelpFile[] = "GEPASI.HLP";					/* help file name						*/
char szAppName[20];   /* class name for the window					*/
int  lbWidth;         /* width of largest string in list box		*/
HWND			hInst;
HWND			hWndMain;
HCURSOR			hHourGlass;				/* handle to the wait cursor			*/
HMENU			hMenu;					/* handle to the menu					*/
GLOBALHANDLE	hMetn;					/* handle to memory block w/ metn		*/
GLOBALHANDLE	hStepn;					/* handle to memory block w/ stepn		*/
GLOBALHANDLE	hSto;					/* handle to memory block w/ sto		*/
GLOBALHANDLE	hLp;					/* handle to memory block w/ lp			*/
GLOBALHANDLE	hKinet;					/* handle to memory block w/ kinet		*/
GLOBALHANDLE	hRs;					/* handle to memory block w/ ord		*/
char			(huge *metn)[NAME_L];	/* pointer to work with metname array	*/
char			(huge *stepn)[NAME_L];	/* pointer to work with step names		*/
unsigned
 char (huge *lp)[MAX_STEP][MAX_MET];	/* def. of modification loops			*/
int   (huge *rs)[MAX_STEP][MAX_MOL];	/* reaction structure					*/
int				huge *sto;				/* pointer to work with metname array	*/
int				totm;					/* number of total metabolites			*/
int				nst;					/* number of steps                		*/
int				nlps;					/* number of reactions with modifiers	*/
int				intm[MAX_MET];			/* 1 if internal metabolite				*/
unsigned char	rvr[MAX_STEP];			/* 1 if reaction is reversible			*/
int 			huge *kinet;            /* pointer to mirror of kinetu			*/
unsigned char	nmd[MAX_STEP];			/* number of assigned modfs of a react.	*/
int				kinass, kass;			/* number of reactions w/ defined type	*/
int				loopass, lass;			/* number of reactions w/ defined modif.*/
int 			notsaved;				/* 1 if file has not been saved			*/
int				eqefl;					/* 1 if editing existing u-d rate eq.	*/
char			FileName[256];			/* filename of file with full path		*/
char			FileTitle[13];			/* filename of file w/o full path		*/
char			errstr[80];				/* string to hold lex and parser errors	*/
unsigned char	lex;					/* index for parser						*/

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
 /***********************************************************************/
 /* HANDLE hInstance;       handle for this instance                    */
 /* HANDLE hPrevInstance;   handle for possible previous instances      */
 /* LPSTR  lpszCmdLine;     long pointer to exec command line           */
 /* int    nCmdShow;        Show code for main window display           */
 /***********************************************************************/

 MSG        msg;           /* MSG structure to store your messages        */
 int        nRc;           /* return value from Register Classes          */
 HANDLE		hAcc;
 LPSTR		ptr;

 strcpy(szAppName, "GWTOP");
 hInst = hInstance;
 if(!hPrevInstance)
   {
    /* register window classes if first instance of application         */
    if ((nRc = nCwRegisterClasses()) == -1)
      {
       /* registering one of the windows failed                         */
       LoadString(hInst, IDS_ERR_REGISTER_CLASS, szString, sizeof(szString));
       MessageBeep( MB_ICONHAND );
       MessageBox(NULL, szString, NULL, MB_ICONSTOP);
       return nRc;
      }
   }

 /* setup the device independent screen units	*/
 InitScrScale();

 /* load the wait cursor						*/
 hHourGlass = LoadCursor(NULL, IDC_WAIT);

 /* load the accelerators table	*/
 hAcc = LoadAccelerators( hInst, (LPSTR) "ACCTABLE" );

 /* create application's Main window                                    */
 hWndMain = CreateWindow(
                szAppName,               /* Window class name           */
                "GEPASI - Topology",     /* Window's title              */
                WS_CAPTION      |        /* Title and Min/Max           */
                WS_SYSMENU      |        /* Add system menu box         */
                WS_MINIMIZEBOX  |        /* Add minimize box            */
                WS_CLIPCHILDREN |        /* don't draw in child windows areas */
                WS_OVERLAPPED,
                CW_USEDEFAULT, 0,        /* Use default X, Y            */
				ScrX(150), ScrY(90),
                NULL,                    /* Parent window's handle      */
                NULL,                    /* Default to Class Menu       */
                hInst,                   /* Instance of window          */
                NULL);                   /* Create struct for WM_CREATE */


 if(hWndMain == NULL)
 {
  LoadString(hInst, IDS_ERR_CREATE_WINDOW, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  return IDS_ERR_CREATE_WINDOW;
 }

 if( InitGepasiVar() != 0 )					/* initialize GEPASI's vars */
 {
  LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  if(!hPrevInstance) CwUnRegisterClasses();
  return IDS_ERR_OUT_OF_MEM;
 }
 /* lets allocate memory for mirror of metname	*/
 hMetn = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_MET * NAME_L * sizeof( char ) );
 if( hMetn == NULL )
 {
  LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  CleanUp(hWndMain, hPrevInstance);
  return IDS_ERR_OUT_OF_MEM;
 }
 hStepn = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_STEP * NAME_L * sizeof( char ) );
 if( hStepn == NULL )
 {
  LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  GlobalFree( hMetn );
  CleanUp(hWndMain, hPrevInstance);
  return IDS_ERR_OUT_OF_MEM;
 }
 /* lets allocate memory for mirror of stoiu	*/
 hSto = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_MET * MAX_STEP * sizeof( int ) );
 if( hSto == NULL )
 {
  LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  GlobalFree( hStepn );
  GlobalFree( hMetn );
  CleanUp(hWndMain, hPrevInstance);
  return IDS_ERR_OUT_OF_MEM;
 }
 /* mirror of loop								*/
 hLp = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_STEP * MAX_MET * sizeof( unsigned char ) );
 if( hLp == NULL )
 {
  LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  GlobalFree( hSto );
  GlobalFree( hStepn );
  GlobalFree( hMetn );
  CleanUp(hWndMain, hPrevInstance);
  return IDS_ERR_OUT_OF_MEM;
 }
 /* allocate memory for mirror of kinetu ...	*/
 hKinet = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_STEP * sizeof( int ) );
 if( hKinet == NULL )
 {
  LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  GlobalFree( hLp );
  GlobalFree( hSto );
  GlobalFree( hStepn );
  GlobalFree( hMetn );
  CleanUp(hWndMain, hPrevInstance);
  return IDS_ERR_OUT_OF_MEM;
 }
 /* allocate memory for mirror of order ...		*/
 hRs = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, (DWORD) MAX_STEP * MAX_MOL * sizeof( int ) );
 if( hRs == NULL )
 {
  LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
  MessageBeep( MB_ICONHAND );
  MessageBox(NULL, szString, NULL, MB_ICONSTOP);
  GlobalFree( hLp );
  GlobalFree( hSto );
  GlobalFree( hStepn );
  GlobalFree( hMetn );
  GlobalFree( hKinet );
  CleanUp(hWndMain, hPrevInstance);
  return IDS_ERR_OUT_OF_MEM;
 }

 /* lock the memory blocks						*/
 metn	= (char (huge *)[NAME_L])						GlobalLock( hMetn );
 stepn	= (char (huge *)[NAME_L])						GlobalLock( hStepn );
 sto	= (int huge *)									GlobalLock( hSto );
 kinet	= (int huge *) 									GlobalLock( hKinet );
 lp		= (unsigned char (huge *)[MAX_STEP][MAX_MET]) 	GlobalLock( hLp );
 rs		= (int (huge *)[MAX_STEP][MAX_MOL])			 	GlobalLock( hRs );

 InitTxtMetrics( hWndMain );
 ShowWindow(hWndMain, nCmdShow);            /* display main window      */

 /* if called with a .sim filename argument, store it in FileName	*/
 FileName[0] = '\0';
 if( *lpszCmdLine)
 {
  ptr = _fstrchr( lpszCmdLine, ' ' );
  if( ptr != NULL ) *ptr = '\0';
  lstrcat( (LPSTR) FileName, lpszCmdLine );
  SendMessage( hWndMain, WM_USER+1, 0, 0 );
 }

 while(GetMessage(&msg, NULL, 0, 0))    /* Until WM_QUIT message    */
 {
  if( !TranslateAccelerator( hWndMain, hAcc, &msg ) )
  {
   TranslateMessage(&msg);
   DispatchMessage(&msg);
  }
 }

 /* clean up before exiting from the application	*/
 GlobalUnlock( hSto );
 GlobalUnlock( hLp );
 GlobalUnlock( hMetn );
 GlobalUnlock( hStepn );
 GlobalUnlock( hKinet );
 GlobalUnlock( hRs );
 GlobalFree( hMetn );
 GlobalFree( hStepn );
 GlobalFree( hLp );
 GlobalFree( hSto );
 GlobalFree( hKinet );
 GlobalFree( hRs );
 CleanUp(hWndMain, hPrevInstance);

 return msg.wParam;
} /*  End of WinMain                                                    */

/************************************************************************/
/*                                                                      */
/* Main Window Procedure                                                */
/*                                                                      */
/* This procedure provides service routines for the Windows events      */
/* (messages) that Windows sends to the window, as well as the user     */
/* initiated events (messages) that are generated when the user selects */
/* the action bar and pulldown menu controls or the corresponding       */
/* keyboard accelerators.                                               */
/*                                                                      */
/************************************************************************/

LONG FAR PASCAL WndProc(HWND hWnd, WORD Message, WORD wParam, LONG lParam)
{
 HBITMAP    hBitmap=0;          /* handle for bitmaps					*/
 HDC        hDC;	            /* handle for the display device		*/
 MINMAXINFO FAR* lpmmi;			/* pointer to minmaxinfo structure		*/
 PAINTSTRUCT	ps;             /* holds PAINT information				*/
 int			nRc=0;          /* return code							*/
 FARPROC		lpfnProc;		/* pointer to dialog procedures			*/
 char			szRslt[128];
 char			szASTR[128];
 int			i, j;

 switch (Message)
 {
  case WM_CREATE:
   /* get handle to the menu									*/
   hMenu = GetMenu( hWnd );
   SendMessage( hWnd, WM_COMMAND, IDM_F_NEW, 0 );
   break;       /*  End of WM_CREATE									*/

  case WM_CLOSE:  /* close the window                                 */
   if( notsaved )
    AskAboutSave( hWnd, hInst, FileName, MB_ICONQUESTION | MB_YESNO );
   if( newtree ) out_tree();
   WinHelp( hWnd, (LPSTR) szHelpFile, HELP_QUIT, 0 );
   DestroyWindow(hWnd);
   if (hWnd == hWndMain)
    PostQuitMessage(0);  /* Quit the application                 */
   break;

  case WM_QUERYENDSESSION:  /* close the window                                 */
   if( notsaved )
   {
    nRc = AskAboutSave( hWnd, hInst, FileName, MB_ICONQUESTION | MB_YESNOCANCEL );
    if ( nRc != IDCANCEL ) return 1;
    else return 0;
   }
   return 1;

  case WM_COMPACTING:
   LoadString(hInst, IDS_ERR_OUT_OF_MEM, szString, sizeof(szString));
   MessageBeep( MB_ICONEXCLAMATION );
   MessageBox(NULL, szString, NULL, MB_ICONEXCLAMATION);
   return 1;

  case WM_SIZE:     /*  code for sizing client area                   */
   switch( wParam )
   {
    case SIZEICONIC:
     if( FileTitle[0] != '\0' )
      wsprintf( (LPSTR) szASTR, "Topology - %s", (LPSTR) FileTitle );
     else
      wsprintf( (LPSTR) szASTR, "GEPASI - Topology" );
     break;
    case SIZENORMAL:
    case SIZEFULLSCREEN:
     wsprintf( (LPSTR) szASTR, "GEPASI - Topology" );
    break;
   }
   SendMessage( hWnd, WM_SETTEXT, 0, (DWORD) (LPSTR) szASTR );
   break;       /* End of WM_SIZE                                 */

  case WM_PAINT:    /* code for the window's client area          */
   /* Obtain a handle to the device context                       */
   /* BeginPaint will sends WM_ERASEBKGND if appropriate          */
   memset( &ps, 0x00, sizeof( PAINTSTRUCT ) );
   hDC = BeginPaint(hWnd, &ps);
   /* Included in case the background is not a pure color         */
   SetBkMode( hDC, TRANSPARENT );
   i=0;
   if( FileName[0] != '\0' )
    wsprintf( szASTR, "filename: %s", (LPSTR) FileTitle );
   else
    wsprintf( szASTR, "undefined filename");
   TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   wsprintf( szASTR, "%i metabolites", totmet );
   TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   wsprintf( szASTR, "%i steps", nsteps );
   TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   if( (nsteps > 0) && (kinass != nsteps) )
   {
    wsprintf( szASTR, "%i kinetics undefined", nsteps - kinass );
    TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   }
   if( (nloops > 0) && (loopass != nloops) )
   {
    wsprintf( szASTR, "%i loops undefined", nloops - loopass );
    TextOut( hDC, TxtX(0), TxtY(i++), szASTR, strlen( szASTR ) );
   }
   EndPaint( hWnd, &ps );
   break;       /*  End of WM_PAINT                               */

  case WM_USER+1:
   if( !(nRc = ReadTop( FileName ) ) )
   {
    /* get the filename without the path						*/
    GetFileTitle( (LPSTR) FileName, (LPSTR) FileTitle, sizeof(FileTitle) );
    /* signal that it has not yet been changed				*/
    notsaved = 0;
    /* count the number of loops and assigned kinetic types	*/
    for( i=0, nloops=0, kinass=0, loopass=0; i<nsteps; i++ )
    {
     /* count the number of assigned kinetics				*/
     if( kinetu[i] != NOT ) kinass++;
     /* count the number of loops							*/
     if( ktype[kinetu[i]].nmodf > 0 ) nloops++;
     /* count the number of assigned modfs for each reaction	*/
     for( j=0, nmod[i]=0; j<totmet; j++ )
      if( (*loop)[i][j] != 0 ) nmod[i]++;
     /* count the number of assigned loops					*/
     if( (ktype[kinetu[i]].nmodf>0) &&
         (ktype[kinetu[i]].nmodf == nmod[i]) ) loopass++;
    }
    if( nsteps>0 )
    {
     EnableMenuItem( hMenu, IDM_E_KINETICS , MF_ENABLED );
     EnableMenuItem( hMenu, IDM_E_METABOLITES , MF_ENABLED );
    }
    else
    {
     EnableMenuItem( hMenu, IDM_E_KINETICS , MF_GRAYED );
     EnableMenuItem( hMenu, IDM_E_METABOLITES , MF_GRAYED );
     EnableMenuItem( hMenu, IDM_E_LOOPS , MF_GRAYED );
    }
    EnableMenuItem( hMenu, IDM_F_SAVE, MF_ENABLED );
    if( nloops > 0 )
     EnableMenuItem( hMenu, IDM_E_LOOPS , MF_ENABLED );
    else
     EnableMenuItem( hMenu, IDM_E_LOOPS , MF_GRAYED );
    InvalidateRect( hWnd, NULL, TRUE );
   }
   else
   {
    LoadString( hInst, nRc, szString, sizeof(szString) );
    MessageBeep( MB_ICONQUESTION );
    MessageBox( NULL, szString, NULL, MB_ICONINFORMATION );
    SendMessage( hWnd, WM_COMMAND, IDM_F_NEW, 0 );
   }
   break;

  case WM_COMMAND:
   switch (wParam)
   {
    case IDA_F1HELP:
    case IDM_H_CONTENTS:
   	 WinHelp( hWnd, (LPSTR) szHelpFile, HELP_INDEX, 0 );
   	 break;

    case IDM_H_SEARCH:
   	 WinHelp( hWnd, (LPSTR) szHelpFile, HELP_PARTIALKEY, (DWORD) (LPSTR) "" );
   	 break;

    case IDM_H_HELPONHELP:
   	 WinHelp( hWnd, (LPSTR) szHelpFile, HELP_HELPONHELP, 0 );
   	 break;

    case IDM_H_ABOUT:
     lpfnProc = MakeProcInstance((FARPROC)AboutBox, hInst);
     DialogBox(hInst, (LPSTR)"ABOUTBOX", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     break;

    case IDM_F_OPEN:
     if( notsaved )
      AskAboutSave( hWnd, hInst, FileName, MB_ICONQUESTION | MB_YESNO );
     if( GetOFileName( hWnd,
       				  (LPSTR) FileName, 256,
      				  (LPSTR) "Open topology file",
       				  (LPSTR) "topology (*.TOP)\0*.TOP\0simulation (*.SIM)\0*.SIM\0" ) )
      SendMessage( hWnd, WM_USER+1, 0, 0 );
     break;

    case IDM_F_CLOSE:
     SendMessage( hWnd, WM_CLOSE, 0, 0 );
     break;

    case IDM_F_SAVE:
     WriteTop( FileName );
     notsaved = 0;
     break;

    case IDM_F_SAVEAS:
     if( GetSFileName( hWnd,
       				  (LPSTR) FileName, sizeof(FileName),
      				  (LPSTR) "Save topology file",
       				  (LPSTR) "topology (*.TOP)\0*.TOP\0" ) )
     {
      if( !(nRc = WriteTop( FileName ) ) )
      {
       /* get the filename without the path						*/
       GetFileTitle( (LPSTR) FileName, (LPSTR) FileTitle, sizeof(FileTitle) );
       /* signal that there has not been any change yet			*/
       notsaved = 0;
       EnableMenuItem( hMenu, IDM_F_SAVE, MF_ENABLED );
       InvalidateRect( hWnd, NULL, TRUE );
      }
     }
     break;

    case IDM_F_NEW:
     if( notsaved )
      AskAboutSave( hWnd, hInst, FileName, MB_ICONQUESTION | MB_YESNO );
     for( i=0; i<MAX_STEP; i++ ) kinetu[i] = NOT;
     nloops = kinass = loopass = notsaved = 0;
     topname[0] = '\0';
     FileName[0] = '\0';
     ClearReactions();
     EnableMenuItem( hMenu, IDM_F_SAVE, MF_GRAYED );
     EnableMenuItem( hMenu, IDM_E_KINETICS, MF_GRAYED );
     EnableMenuItem( hMenu, IDM_E_METABOLITES, MF_GRAYED );
     EnableMenuItem( hMenu, IDM_E_LOOPS, MF_GRAYED );
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_E_REACTIONS:
     lpfnProc = MakeProcInstance( (FARPROC)EdReact, hInst);
     DialogBox( hInst, (LPSTR)"TOP_PARSER", hWnd, lpfnProc );
     FreeProcInstance( lpfnProc );
     hMenu = GetMenu( hWnd );
     if( nsteps>0 )
     {
      EnableMenuItem( hMenu, IDM_E_KINETICS , MF_ENABLED );
      EnableMenuItem( hMenu, IDM_E_METABOLITES , MF_ENABLED );
     }
     else
     {
      EnableMenuItem( hMenu, IDM_E_KINETICS , MF_GRAYED );
      EnableMenuItem( hMenu, IDM_E_METABOLITES , MF_GRAYED );
      EnableMenuItem( hMenu, IDM_E_LOOPS , MF_GRAYED );
     }
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_E_METABOLITES:
     lpfnProc = MakeProcInstance((FARPROC)EdMetnam, hInst);
     DialogBox(hInst, (LPSTR)"METNAM", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_E_KINETICS:
     lpfnProc = MakeProcInstance((FARPROC) EdKinet, hInst);
     DialogBox(hInst, (LPSTR)"REACT_KINET", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     if( nloops > 0 )
      EnableMenuItem( hMenu, IDM_E_LOOPS , MF_ENABLED );
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_E_LOOPS:
     lpfnProc = MakeProcInstance((FARPROC) EdLoop, hInst);
     DialogBox(hInst, (LPSTR)"LOOP_ED", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_E_NAME:
     lpfnProc = MakeProcInstance((FARPROC) EdName, hInst);
     DialogBox(hInst, (LPSTR)"TITLE_ED", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    case IDM_E_RATES:
     lpfnProc = MakeProcInstance((FARPROC) EdUdkt, hInst);
     DialogBox(hInst, (LPSTR)"ED_UDKT", hWnd, lpfnProc);
     FreeProcInstance(lpfnProc);
     InvalidateRect( hWnd, NULL, TRUE );
     break;

    default:
     return DefWindowProc(hWnd, Message, wParam, lParam);
   }
   break;        /* End of WM_COMMAND                             */

  default:
   return DefWindowProc(hWnd, Message, wParam, lParam);
 }
 return 0L;
}     /* End of WndProc                                         */


BOOL FAR PASCAL AboutBox(HWND hWndDlg, WORD Message, WORD wParam, LONG lParam)
{
 switch(Message)
 {
  case WM_INITDIALOG:
   SendDlgItemMessage( hWndDlg, IDSTAT_2, WM_SETTEXT, 0, (DWORD) (LPSTR) VERSION );
   break;

  case WM_CLOSE:
   /* Closing the Dialog behaves the same as Cancel               */
   PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
   break;

  case WM_COMMAND:
   if( wParam == IDOK || wParam == IDCANCEL )
   EndDialog(hWndDlg, FALSE);
   break;

  default:
   return FALSE;
 }
 return TRUE;
}


/************************************************************************/
/*                                                                      */
/* nCwRegisterClasses Function                                          */
/*                                                                      */
/* The following function registers all the classes of all the windows  */
/* associated with this application. The function returns an error code */
/* if unsuccessful, otherwise it returns 0.                             */
/*                                                                      */
/************************************************************************/

int nCwRegisterClasses(void)
{
 WNDCLASS   wndclass;    /* struct to define a window class             */

 memset(&wndclass, 0x00, sizeof(WNDCLASS));
 /* load WNDCLASS with window's characteristics                         */
 wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW;
 wndclass.lpfnWndProc = WndProc;
 /* Extra storage for Class and Window objects                          */
 wndclass.cbClsExtra = 0;
 wndclass.cbWndExtra = 0;
 wndclass.hInstance = hInst;
 wndclass.hIcon = LoadIcon(hInst,"GWTOP");
 wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
 /* Create brush for erasing background                                 */
 wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
 wndclass.lpszMenuName = szAppName;   /* Menu Name is App Name */
 wndclass.lpszClassName = szAppName; /* Class Name is App Name */
 if(!RegisterClass(&wndclass))
   return -1;
 return(0);
} /* End of nCwRegisterClasses                                          */

/************************************************************************/
/*  cwCenter Function                                                   */
/*                                                                      */
/*  centers a window based on the client area of its parent             */
/*                                                                      */
/************************************************************************/

void cwCenter( HWND hWnd, int top)
{
 POINT      pt;
 RECT       swp;
 RECT       rParent;
 int        iwidth;
 int        iheight;

 /* get the rectangles for the parent and the child                     */
 GetWindowRect(hWnd, &swp);
 GetClientRect(hWndMain, &rParent);

 /* calculate the height and width for MoveWindow                       */
 iwidth = swp.right - swp.left;
 iheight = swp.bottom - swp.top;

 /* find the center point and convert to screen coordinates             */
 pt.x = (rParent.right - rParent.left) / 2;
 pt.y = (rParent.bottom - rParent.top) / 2;
 ClientToScreen(hWndMain, &pt);

 /* calculate the new x, y starting point                               */
 pt.x = pt.x - (iwidth / 2);
 pt.y = pt.y - (iheight / 2);

 /* top will adjust the window position, up or down                     */
 if(top)
   pt.y = pt.y + top;

 /* move the window                                                     */
 MoveWindow(hWnd, pt.x, pt.y, iwidth, iheight, FALSE);
}

/************************************************************************/
/*  CwUnRegisterClasses Function                                        */
/*                                                                      */
/*  Deletes any refrences to windows resources created for this         */
/*  application, frees memory, deletes instance, handles and does       */
/*  clean up prior to exiting the window                                */
/*                                                                      */
/************************************************************************/

void CwUnRegisterClasses(void)
{
/* WNDCLASS   wndclass;
 memset(&wndclass, 0x00, sizeof(WNDCLASS));*/

 UnregisterClass(szAppName, hInst);
}    /* End of CwUnRegisterClasses                                      */


void CleanUp( HWND hWnd, HANDLE hPrevInstance )
{
 if(!hPrevInstance) CwUnRegisterClasses();
 TidyGepasiVar();
}