#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*          Scan Parameters          */
/*            dialog box             */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/

#pragma alloc_text( CODE7, AddPLst, str_cube, EdScanP)

void AddPLst( HWND hControl, int idx, BOOL scroll )
{
 int i;
 WORD ElWidth;
 HANDLE hDC;

 hDC = GetDC( hControl );
 ElWidth = 5 + LOWORD( GetTextExtent( hDC, scp[idx].title, _fstrlen(scp[idx].title) ) );
 SetTextJustification( hDC, 0, 0 );
 ReleaseDC( hControl, hDC );
 if( ElWidth > lbWidth )
 {
  lbWidth = ElWidth;
  SendMessage( hControl, LB_SETHORIZONTALEXTENT, lbWidth, 0 );
 }
 SendMessage( hControl, LB_INSERTSTRING, -1, (DWORD) scp[idx].title );
 if( scroll ) SendMessage( hControl, WM_VSCROLL, SB_BOTTOM, 0 );
}

void str_cube( int tsel, LPSTR buff )
{
   switch( tsel )
   {
    case 0: wsprintf( buff, "0 selected" );
            break;
    case 1: wsprintf( buff, "line" );
            break;
    case 2: wsprintf( buff, "rectangle" );
            break;
    case 3: wsprintf( buff, "cube" );
            break;
    default:wsprintf( buff, "%dD hypercube", tsel );
   }
}

BOOL FAR PASCAL EdScanP(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static int tsel;
 static HWND hAvail, hSelect, hLow, hDimens,
             hHigh, hDens, hTDens, hLog, hS1, hS2;
 int  i, j, nsel, len;
 char buff[128];

 switch(Message)
 {
  case WM_INITDIALOG:
   /* allocate memory for the mirror				*/
   hScp = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, sizespar );
   if( hScp == NULL )
   {
    LoadString(hInst, IDS_ERR_NOEXEC, szString, sizeof(szString));
    MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
    EndDialog(hDlg, FALSE);
    return TRUE;
   }

   /* lock the memory block							*/
   scp  = (struct sp huge *) GlobalLock( hScp );

   /* copy params to its mirror									*/
   _fmemcpy( (void __far *) scp,
             (void __far *) spar,
		     (size_t) sizespar );

   /* get handles to controls						*/
   hAvail = GetDlgItem( hDlg, IDC_PARAMLST );
   hSelect = GetDlgItem( hDlg, IDC_SELECT );
   hS1 = GetDlgItem( hDlg, IDSTAT_3 );
   hS2 = GetDlgItem( hDlg, IDSTAT_4 );

   /* initialize hAvail: add all output elements	*/
   for( i=0, lbWidth=0; i<nscanpar; i++ )
    AddPLst( hAvail, i, FALSE );

   /* copy the number of selected to mirror			*/
   tsel = totscan;
   /* initialize hSelect: add all selected elements	*/
   for( i=0, lbWidth=0; i<tsel; i++ )
    for( j=0; j<nscanpar; j++ )
     if( (scp[j].idx-1) ==  i )
      AddPLst( hSelect, j, TRUE );
   /* show number of available parameters			*/
   wsprintf( (LPSTR) buff, "%d available", nscanpar );
   SendMessage( hS2, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
   /* show the dimensions of the hypercube			*/
   str_cube( tsel, (LPSTR) buff );
   SendMessage( hS1, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );

   InvalidateRect( hDlg, NULL, FALSE );
   return TRUE;

  case WM_COMMAND:
   switch(wParam)
   {
    case IDC_PARAMLST:
     if( HIWORD( lParam ) == LBN_DBLCLK )
     {
      /* get the newly selected element in the available box		*/
      nsel = (int) SendMessage( hAvail, LB_GETCURSEL, 0, 0 );
      if( nsel != LB_ERR )
       if( scp[nsel].idx == 0 )
       {
        scp[nsel].idx = ++tsel;
        AddPLst( hSelect, nsel, TRUE );
        str_cube( tsel, (LPSTR) buff );
        SendMessage( hS1, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
       }
      return TRUE;
     }
     else return FALSE;

    case IDC_SELECT:
     if( HIWORD( lParam ) == LBN_DBLCLK )
     {
      /* get the index of the element selected					*/
      nsel = (int) SendMessage( hSelect, LB_GETCURSEL, 0, 0 );
      if( nsel != LB_ERR )
      {
       SendMessage( hSelect, LB_DELETESTRING, (WORD) nsel, 0 );
       for( i=0; i<nscanpar; i++ )
       {
        if( scp[i].idx > nsel+1) scp[i].idx--;
        else if( scp[i].idx == nsel+1) scp[i].idx = 0;
       }
       tsel--;
       str_cube( tsel, (LPSTR) buff );
       SendMessage( hS1, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
      }
      return TRUE;
     }
     else return FALSE;

    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Scan parameters" );
     return TRUE;

    case IDOK:
     /* copy the number of selected from mirror				*/
     totscan = tsel;
	 /* copy params back from its mirror								*/
     _fmemcpy( (void __far *) spar,
               (void __far *) scp,
		       (size_t) sizespar );
     /* unlock and free the mirror memory block             */
     GlobalUnlock( hScp );
     GlobalFree( hScp );
     /* signal that changes have been made					*/
	 notsaved = 1;
     EndDialog(hDlg, TRUE);
     return TRUE;

    case IDCANCEL:
     /* unlock and free the mirror memory block             */
     GlobalUnlock( hScp );
     GlobalFree( hScp );
     EndDialog(hDlg, FALSE);
     return TRUE;
   }    /* End of WM_COMMAND                                 */
   return FALSE;

  default:
   return FALSE;
 }
} /* End of METABMsgProc                                      */

