#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*          GWTOP - Topology         */
/*        MS-WINDOWS front end       */
/*                                   */
/*       Metabolites dialog box      */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdio.h>
#include <string.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwtop.h"						/* macros, function prototypes, etc.	*/
#include "gep1.h"						/* gepasi's variables					*/
#include "topgvar.h"					/* global variables						*/

#pragma alloc_text( CODE5, EdMetnam )

BOOL FAR PASCAL EdMetnam(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static int i, j, k, first, last, lots;
 HWND hCtrl;
 int len;
 char strA[5];
 static BOOL circle;

 switch(Message)
   {
    case WM_INITDIALOG:
         /* copy metname to its mirror									*/
		 _fmemcpy( (void __far *) metn,
				   (void __far *) metname,
				   (size_t) MAX_MET * NAME_L * sizeof( char ) );
         /* copy intmet to its mirror									*/
         _fmemcpy( (void __far *) intm,
   	         	   (void __far *) intmet,
             	   (size_t) totmet * sizeof( int ) );

    case WM_USER+1:
         /* initialize working variables                                */
         if (totmet >= 10 ) last = 10;
         else               last = totmet;
         if (totmet > 10 )  lots = TRUE;
         else               lots = FALSE;
         first = 0;
         circle = FALSE;

         /* initialize radio buttons									*/
         for( j=first, i=IDRB_0I; j<last; j++, i+=2 )
          SendDlgItemMessage( hDlg, i, BM_SETCHECK, (WORD) intm[j], (DWORD) 0 );
         for( j=first, i=IDRB_0E; j<last; j++, i+=2 )
          SendDlgItemMessage( hDlg, i, BM_SETCHECK, (WORD) !intm[j], (DWORD) 0 );

         /* initialize edit boxes										*/
         for( j=first, i=IDE_M0; j<last; j++, i++ )
          SetDlgItemText( hDlg, i, (LPSTR) metn[j]);

         /* show from first to last										*/
         for( j=first, i=IDRB_0E, k=IDE_M0; j<last; j++, i+=2, k++ )
         {
          hCtrl = GetDlgItem( hDlg, k );
          ShowWindow( hCtrl, SW_SHOW );
          hCtrl = GetDlgItem( hDlg, i );
          ShowWindow( hCtrl, SW_SHOW );
          hCtrl = GetDlgItem( hDlg, i+1 );
          ShowWindow( hCtrl, SW_SHOW );
         }

         /* hide from last to 9											*/
         for( j=last; j<10; j++, i+=2, k++ )
         {
          hCtrl = GetDlgItem( hDlg, k );
          ShowWindow( hCtrl, SW_HIDE );
          hCtrl = GetDlgItem( hDlg, i );
          ShowWindow( hCtrl, SW_HIDE );
          hCtrl = GetDlgItem( hDlg, i+1 );
          ShowWindow( hCtrl, SW_HIDE );
         }

         hCtrl = GetDlgItem( hDlg, ID_MORE );
         if (lots) ShowWindow( hCtrl, SW_SHOW );
         else      ShowWindow( hCtrl, SW_HIDE );
		 break;
         /* End of WM_INITDIALOG              		                   */

    case WM_COMMAND:
         switch(wParam)
         {
            case IDRB_0E:
                 intm[first+0] = 0;
                 break;

            case IDRB_0I:
                 intm[first+0] = 1;
                 break;

            case IDRB_1E:
                 intm[first+1] = 0;
                 break;

            case IDRB_1I:
                 intm[first+1] = 1;
                 break;

            case IDRB_2E:
                 intm[first+2] = 0;
                 break;

            case IDRB_2I:
                 intm[first+2] = 1;
                 break;

            case IDRB_3E:
                 intm[first+3] = 0;
                 break;

            case IDRB_3I:
                 intm[first+3] = 1;
                 break;

            case IDRB_4E:
                 intm[first+4] = 0;
                 break;

            case IDRB_4I:
                 intm[first+4] = 1;
                 break;

            case IDRB_5E:
                 intm[first+5] = 0;
                 break;

            case IDRB_5I:
                 intm[first+5] = 1;
                 break;

            case IDRB_6E:
                 intm[first+6] = 0;
                 break;

            case IDRB_6I:
                 intm[first+6] = 1;
                 break;

            case IDRB_7E:
                 intm[first+7] = 0;
                 break;

            case IDRB_7I:
                 intm[first+7] = 1;
                 break;

            case IDRB_8E:
                 intm[first+8] = 0;
                 break;

            case IDRB_8I:
                 intm[first+8] = 1;
                 break;

            case IDRB_9E:
                 intm[first+9] = 0;
                 break;

            case IDRB_9I:
                 intm[first+9] = 1;
                 break;

            case IDCANCEL:
                 /* Ignore data values entered into the controls        */
                 /* and dismiss the dialog window returning FALSE       */
                 EndDialog(hDlg, FALSE);
                 break;

            case ID_MORE:
				 /* save current changes								*/
                 for( i=IDE_M0, j=first; j<last; i++, j++)
                 {
                  len = GetDlgItemText( hDlg, i, (LPSTR) metn[j], NAME_L-1 );
                  if( len==0 )
                  {
                   wsprintf( strA, "%c%d", intm[j] ? 'S' : 'X', j+1 );
                   lstrcpy( (LPSTR) metn[j], (LPSTR) strA );
                  }
                 }

				 /* check need for going back to begginning				*/
				 if ( circle )
				 {
				  circle = FALSE;
				  SendMessage( hDlg, WM_USER+1, (WORD) 0, (DWORD) 0 );
				  break;
				 }

		         /* update working variables                            */
         		 first = last;
         		 last += 10;
         		 if ( last >= totmet )
         		 {
          		  last = totmet;
          		  circle = TRUE;
         		 }

         		 /* update radio buttons										*/
         		 for( j=first, i=IDRB_0I; j<last; j++, i+=2 )
          		  SendDlgItemMessage( hDlg, i, BM_SETCHECK, (WORD) intm[j], (DWORD) 0 );
         		 for( j=first, i=IDRB_0E; j<last; j++, i+=2 )
          		  SendDlgItemMessage( hDlg, i, BM_SETCHECK, (WORD) !intm[j], (DWORD) 0 );

		         /* update edit boxes											*/
        		 for( j=first, i=IDE_M0; j<last; j++, i++ )
          		  SetDlgItemText( hDlg, i, (LPSTR) metn[j]);

         		 /* show from first to last										*/
	       		 for( j=first, i=IDRB_0E, k=IDE_M0; j<last; j++, i+=2, k++ )
         		 {
          		  hCtrl = GetDlgItem( hDlg, k );
          		  ShowWindow( hCtrl, SW_SHOW );
          		  hCtrl = GetDlgItem( hDlg, i );
          		  ShowWindow( hCtrl, SW_SHOW );
          		  hCtrl = GetDlgItem( hDlg, i+1 );
          		  ShowWindow( hCtrl, SW_SHOW );
         		 }

         		 /* hide from last to 9											*/
         		 for( ; k<=IDE_M9; i+=2, k++ )
         		 {
          		  hCtrl = GetDlgItem( hDlg, k );
          		  ShowWindow( hCtrl, SW_HIDE );
          		  hCtrl = GetDlgItem( hDlg, i );
          		  ShowWindow( hCtrl, SW_HIDE );
          		  hCtrl = GetDlgItem( hDlg, i+1 );
          		  ShowWindow( hCtrl, SW_HIDE );
         		 }
         		 break;

            case IDC_HELP:                        /* Help on this Dialog Box			  */
   	         WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Metabolite editor" );
             break;

            case IDOK:
             for( i=IDE_M0, j=first; j<last; i++, j++)
             {
              len = GetDlgItemText( hDlg, i, (LPSTR) metn[j], NAME_L-1 );
              if( len==0 )
              {
               wsprintf( strA, "%c%d", intm[j] ? 'S' : 'X', j );
               lstrcpy( (LPSTR) metn[j], (LPSTR) strA );
              }
             }
		     /* copy metname back from its mirror									*/
			 _fmemcpy( (void __far *) metname,
					   (void __far *) metn,
					   (size_t) MAX_MET * NAME_L * sizeof( char ) );
		     /* copy intmet back from its mirror									*/
        	 _fmemcpy( (void __far *) intmet,
   	       			   (void __far *) intm,
        	    	   (size_t) totmet * sizeof( int ) );
			 notsaved = 1;
             EndDialog(hDlg, TRUE);
             break;
         }
         break;    /* End of WM_COMMAND                                 */

    default:
        return FALSE;
   }
 return TRUE;
} /* End of METNAMMsgProc                                      */


