#ifndef __TYPEDEFS_H_DEFINED
#define __TYPEDEFS_H_DEFINED

#define _fast

#if defined(__386__) || defined(__FLAT__)
  typedef unsigned      bit;

  typedef unsigned char byte;
  typedef signed char   sbyte;

  typedef unsigned short word;
  typedef signed short   sword;

  typedef unsigned int  dword;
  typedef signed int    sdword;

  typedef unsigned short ushort;
  typedef   signed short sshort;

  typedef unsigned long  ulong;
  typedef   signed long  slong;
#else
  typedef unsigned      bit;

  typedef unsigned char byte;
  typedef signed char   sbyte;

  typedef unsigned int  word;
  typedef signed int    sword;

  typedef unsigned long dword;
  typedef signed long   sdword;

  typedef unsigned short ushort;
  typedef   signed short sshort;

  typedef unsigned long  ulong;
  typedef   signed long  slong;
#endif

#endif

struct _netaddr;
typedef struct _netaddr NETADDR;

struct _netaddr
{
  word zone;
  word net;
  word node;
  word point;
};


#define PATHLEN   120
#define TRUE      1
#define FALSE     0

extern void _fast NoMem(void);

void * smalloc(unsigned size)
{
  void *mem;
  
  if ((mem=(void *)malloc(size))==NULL)
    NoMem();

  memset(mem, '\0', size);
  return mem;
}

byte * Address(NETADDR *a)
{
  static char temp[30];
  char point[10];

  sprintf(point,".%u",a->point);
  sprintf(temp,"%u:%u/%u%s",a->zone,a->net,a->node,a->point ? point : "");

  return temp;
}

char * sstrdup(char *s)
{
  char *p;
  
  if ((p=strdup(s))==NULL)
    NoMem();
  
  return p;
}

#define eqstri(a, b) (stricmp(a,b)==0)

char * firstchar(char *strng,char *delim,int findword)
{
  int x,
      isw,
      sl_d,
      sl_s,
      wordno=0;

  char *string,
       *oldstring;

  /* We can't do *anything* if the string is blank... */

  if (! *strng)
    return NULL;

  string=oldstring=strng;

  sl_d=strlen(delim);

  for (string=strng;*string;string++)
  {
    for (x=0,isw=0;x <= sl_d;x++)
      if (*string==delim[x])
        isw=1;

    if (isw==0)
    {
      oldstring=string;
      break;
    }
  }

  sl_s=strlen(string);

  for (wordno=0;(string-oldstring) < sl_s;string++)
  {
    for (x=0,isw=0;x <= sl_d;x++)
      if (*string==delim[x])
      {
        isw=1;
        break;
      }

    if (!isw && string==oldstring)
      wordno++;

    if (isw && (string != oldstring))
    {
      for (x=0,isw=0;x <= sl_d;x++) if (*(string+1)==delim[x])
      {
        isw=1;
        break;
      }

      if (isw==0)
        wordno++;
    }

    if (wordno==findword)
      return((string==oldstring || string==oldstring+sl_s) ? string : string+1);
  }

  return NULL;
}





static char *colon=":";
static char *slash="/";

#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define ZONE_ALL  56685u
#define NET_ALL   56685u
#define NODE_ALL  56685u
#define POINT_ALL 56685u


void ParseNN(char *netnode,word *zone,word *net,word *node,word *point,word all)
{
  char *p;

  p=netnode;
  
  if (all && point)
    *point=POINT_ALL;

  if (all && toupper(*netnode)=='W')  /* World */
  {
    if (zone)
      *zone=ZONE_ALL;

    if (net)
      *net=NET_ALL;

    if (node)
      *node=NODE_ALL;

    return;
  }

  /* If we have a zone (and the caller wants the zone to be passed back).. */

  if (strchr(netnode,':'))
  {
    if (zone)
    {
      if (all && toupper(*p)=='A')  /* All */
        *zone=ZONE_ALL;
      else *zone=atoi(p);
    }

    p=firstchar(p,colon,2);
  }

  /* If we have a net number... */

  if (p && *p)
  {
    if (strchr(netnode,'/'))
    {
      if (net)
      {
        if (all && toupper(*p)=='A')  /* All */
          *net=NET_ALL;
        else *net=atoi(p);
      }

      p=firstchar(p,slash,2);
    }
    else if (all && toupper(*p)=='A')
    {
      /* If it's in the form "1:All" or "All" */

      if (strchr(netnode,':')==NULL && zone)
        *zone=ZONE_ALL;

      *net=NET_ALL;
      *node=NODE_ALL;
      p += 3;
    }
  }

  /* If we got a node number... */

  if (p && *p && node && *netnode != '.')
  {
    if (all && toupper(*p)=='A')  /* All */
    {
      *node=NODE_ALL;

      /* 1:249/All implies 1:249/All.All too... */

      if (point && all)
        *point=POINT_ALL;
    }
    else *node=atoi(p);
  }

  if (p)
    while (*p && isdigit(*p))
      p++;

  /* And finally check for a point number... */

  if (p && *p=='.')
  {
    p++;

    if (point)
    {
      if (!p && *netnode=='.')
        p=netnode+1;

      if (p && *p)
      {
        *point=atoi(p);

        if (all && toupper(*p)=='A')  /* All */
          *point=POINT_ALL;
      }
      else *point=0;
    }
  }
}

#ifdef __WATCOMC__
#define _stdc
#else
#define _stdc cdecl
#endif

#define NW(x) (void)x

