/* Editor.C File */

#include "msgg.h"
#include "twindow.h"
#include "headedit.h"
#include "keys.h"

extern void pascal dcls(void);
extern void pascal dputc(int x, int y, int c);
extern int  pascal dputs(int x, int y, char *s);
extern void pascal dclrwnd(int x1, int y1, int x2, int y2);
extern void pascal dscrollup(int x1, int y1, int x2, int y2);
extern void pascal dscrolldn(int x1, int y1, int x2, int y2);

extern word vbase;
extern word maxx;
extern word maxy;
extern char current_color;
extern word videomethod;

#define TRUE 		1
#define FALSE		0
#define TABS		4
#define NEXTTAB		(TABS-(x%TABS))
#define LASTTAB		(((wwd-1)/TABS)*TABS)
#define PREVTAB		(((x-1)%TABS)+1)
#define curr(x,y) 	(bfptr+(y)*wwd+(x))
#define lineno(y)   ((int)(bfptr-topptr)/wwd+(y))
#define sayline(y)  ((unsigned int)((unsigned int)bfptr-(unsigned int)topptr)/(unsigned int)wwd+((unsigned int)y))

extern int VSG;
int last_x,last_y;
static char qstr[7];
char keybuf[256]="";
static int quoting=0;
static int wht;
static int wwd;
static int wsz;
static char *topptr;
static char *bfptr;
static char *lstptr;
static int lines;
static char *endptr;
static int blkbeg;
static int blkend;
static int inserting;
static WINDOW *wnd;
static int do_display_text=1;
char abortedit;

/* Local function prototypes */

extern int  pascal do_macro (int c);
extern char * pascal get_string (char *text,char len,char *deflt,char type);
extern char pascal ask_question (char *text);
void pascal file_funcs(int y,int command);
void pascal save_text(int justblk,int append);
void pascal load_text(int y,int insertit);
void pascal unquote(int *x,int *y);
void pascal quote_mark (int x,int y);
void pascal erase_buffer(int *x,int *y);
char pascal ask_quit(void);
char pascal ask_save(void);
int  pascal lastword(int x,int y);
void pascal last_char(int *x,int *y);
void pascal test_para(int x,int y);
int  pascal trailing_spaces(int y);
int  pascal first_wordlen(int y);
void pascal paraform(int x,int y,char);
int  pascal blankline(int line);
void pascal delete_word(int x,int y);
void pascal delete_line(int y);
void pascal delete_block(void);
void pascal copy_block(int y);
void pascal move_block(int y);
void pascal mvblock(int y,int moving);
void pascal findlast(void);
void pascal find_end(int *x,int *y);
void pascal carrtn(int *x,int *y,int insert);
void pascal backspace(int *x,int *y);
void pascal fore_word(int *x,int *y,char *bf);
int  pascal spaceup(int *x,int *y,char **bf);
void pascal back_word(int *x,int *y,char *bf);
int  pascal spacedn(int *x,int *y,char **bf);
void pascal forward(int *x,int *y);
int  pascal downward(int *y);
void pascal upward(int *y);
void pascal display_text(void);
void pascal disp_line(int y);
void pascal insert_line(void);

extern char notefile[133];



/* Process text entry for a window */

char * pascal text_editor (WINDOW *wnd1,char *bf,unsigned int bsize) {

  char lastun;
  char *b,*buff,*pp;
  int depart=FALSE,i,c;
  int x,y,svx,svlw,tx,tabctr=0;

  memset(qstr,0,6);	/* Build quote string */
  *qstr=' ';
  if(*msg.to) {
		qstr[1]=*msg.to;
		pp=strchr(msg.to,' ');
		if(pp && pp[1]) qstr[2]=pp[1];
  }
  strcat(qstr,"> ");
  abortedit=0;
  wnd=wnd1;
  wht=HEIGHT-2;
  wwd=WIDTH-2;
  wsz=wwd*wht;
  topptr=bfptr=bf;
  lines=bsize/wwd;
  endptr=bf+wwd*lines;
  blkbeg=0;
  blkend=0;
  inserting=TRUE;
  x=(maxx-1)-strlen(notefile);
  if(x<49)x=49;
  current_color=readtextcolor + (readtextback * 16);
  lowvideo();
  dprintf(x,6,"%0.28s",notefile);
  x=y=0;
  memset(bf,' ',bsize);
  load_text(0,0);	/* Initial load */
  display_text();

  while (TRUE) {
   last_x=COL+1+x;
   last_y=ROW+1+y;
   if(last_y>(maxy-1)) {
	last_y--;
	y--;
   }
   cursor(last_x,last_y);
   buff=curr(x,y);
   if (tabctr) {
      --tabctr;
      c=' ';
   }
   else {
	  if(*keybuf) {
		c=*keybuf;
		memmove(keybuf,&keybuf[1],strlen(&keybuf[1])+1);
	  }
	  else if (quoting) quote_mark(x,y);
	  else {

        current_color=readtextcolor + (readtextback * 16);
		lowvideo();
		dprintf(3,6,"%3u | %-3u",x+1,sayline(y)+1);
		c=get_char();
	  }
	  clear_message();
   }
   switch(c) {
	  case CTRL_W:				/* Wrap on/off */
	if(!stricmp(notefile,"MSGTMP")) {
		wrapit=1-wrapit;
		if(wrapit) any_message(" Wrap at save off ");
		else any_message(" Wrap at save on ");
		pause();
	}
	break;
	  case CTRL_O:				/* Origin toggle */
	if(!stricmp(notefile,"MSGTMP")) {
		usedefault=1-usedefault;
		if(usedefault) {
			get_origin();
		}
		else {
			any_message(" Looking up Origin line in ORIGINS.BBS ");
			pause();
		}
	}
	break;
	  case ALT_F1:		/* Spawn keys */
	  case ALT_F2:
	  case ALT_F3:
	  case ALT_F4:
	  case ALT_F5:
	  case ALT_F6:
	  case ALT_F7:
	  case ALT_F8:
	  case ALT_F9:
	  case ALT_F10:
	do_spawn(convertstring(fkey[c-ALT_F1]));
	break;
	  case ALT_M:				/* Macros */
	set_help("macrohelp ",0,0);
	any_message(" Press macro key: ");
	c=get_char();
	set_help("edithelp  ",0,0);
	clear_message();
	if(!do_macro(c)) {
		if(c!=ESC) {
			error_message(" Undefined macro key ");
			pause();
		}
	}
	break;
	  case ALT_P:				/* Literal */
	any_message(" Press literal key: ");
	set_help("lithelp   ",0,0);
	c=get_char();
	set_help("edithelp  ",0,0);
	clear_message();
	goto LiteralBreakIn;
	  case ALT_R:				/* Read block */
	file_funcs(y,4);
	break;
	  case ALT_W:				/* Write block */
	file_funcs(y,5);
	break;
	  case ALT_L:				/* Load new file */
	file_funcs(y,2);
	break;
	  case ALT_S:				/* Save file */
	file_funcs(y,1);
	break;
	  case ALT_C:				/* Change filename */
	file_funcs(y,3);
	break;
	  case ALT_F:				/* File functions */
	file_funcs(y,0);
	break;
	  case CTRL_E:				/* Edit header */
	if(!stricmp(notefile,"MSGTMP")) {
		edit_mess(2);
		show_header(0);
	}
	break;
	  case CTRL_U:				/* Unquote text */
	if(blankline(lineno(y)+1)) if (!blankline(lineno(y+1)+1)) downward(&y);
	unquote(&x,&y);
	break;
	  case ALT_Q:				/* Set quote string */
	memset(qstr,0,6);	/* Build quote string */
	*qstr=' ';
	if(*msg.to) {
		qstr[1]=*msg.to;
		pp=strchr(msg.to,' ');
		if(pp && pp[1]) qstr[2]=pp[1];
	}
	strcat(qstr,"> ");
	set_help("quotshelp ",0,0);
	pp=get_string("Enter quote string:",6,qstr,'a');
	if(*pp) {
		strcpy(qstr,pp);
		if(strlen(qstr)<6 && qstr[strlen(qstr)-1]!=' ') strcat(qstr," ");
	}
	set_help("edithelp  ",0,0);
	break;
	  case CTRL_Q:				/* Quote text */
	if(blankline(lineno(y)+1)) if (!blankline(lineno(y+1)+1)) downward(&y);
	quote_mark(x,y);
	break;
	  case '\r':				/* CR */
	carrtn(&x,&y,inserting);
	break;
	  case DN:					/* Down */
        downward(&y);
	break;
	  case PGUP:				/* Page Up */
	y=0;
	for(i=0;i<wht;i++) upward(&y);
	x=0;
	break;
	  case PGDN:				/* Page Down */
	y=HEIGHT-2;
	for(i=0;i<wht;i++)
	  downward(&y);
	y=0;
	break;
	  case '\t':				/* Tab */
	if (x + NEXTTAB < wwd) {
	  if (inserting)
	    tabctr=NEXTTAB;
	  else
	    x+=NEXTTAB;
	}
	else
	  carrtn(&x,&y,inserting);
	break;
	  case SHIFT_HT:			/* Shift-tab */
	if (x<TABS) {
	  upward(&y);
	  x=LASTTAB;
	}
	else
	  x-=PREVTAB;
	break;
	  case CTRL_FWD:			/* CTRL-=> */
	fore_word(&x,&y,buff);
	break;
	  case CTRL_BS:				/* CTRL-<= */
	back_word(&x,&y,buff);
	break;
	  case CTRL_PGUP:			/* Top of paragraph */
	while(curr(0,y)>topptr) {
		upward(&y);
		if(blankline(lineno(y)+1)) break;
	}
	break;
	  case CTRL_PGDN:
	while(curr(0,y)<endptr) {
		downward(&y);
		if(blankline(lineno(y)+1)) break;
	}
	break;
	  case CTRL_B:				/* Bottom of page */
	y=wht-1;
	last_char (&x,&y);
	break;
	  case CTRL_T:				/* Top of page */
	x=y=0;
	break;
	  case CTRL_HOME:			/* Top of file */
	x=y=0;
	bfptr=topptr;
	display_text();
	break;
	  case HOME:				/* Start of line */
	x=0;
	break;
	  case CTRL_END:			/* End of file */
	find_end(&x,&y);
	last_char (&x,&y);
	display_text();
	break;
	  case END:					/* End of line */
	last_char (&x,&y);
	break;
	  case UP:					/* up-arrow */
	upward(&y);
	break;
	  case CTRL_A:				/* Abort; no save */
	abortedit=ask_quit();
	  case ALT_X:				/* Ask to save */
	if(!abortedit) abortedit=ask_save();
	if(abortedit==2) {
		abortedit=0;
		break;
	}
	  case F2:					/* Finished */
	depart=TRUE;
	break;
      case '\b':
	  case BS:					/* Backspace or <= */
	if (curr(x,y)==topptr)
	  break;
	backspace(&x,&y);
	if (x==wwd-1)
	  last_char(&x,&y);
	if (c==BS)
	  break;
	buff=curr(x,y);
	  case DEL:					/* Delete */
	 if(blankline(lineno(y)+1)) {
		delete_line(y);
		break;
	 }
	 lastun=*buff;
	 movmem(buff+1,buff,wwd-1-x);
	 *(buff+wwd-1-x)=' ';
	 disp_line(y);
	 if(lastun==' ' && !blankline(lineno(y+1)+1)) {

		int xx=0;
		int ts,fw;


		buff=curr(x,y);
		while(buff[xx]==' ' && (xx+x)<(wwd-1)) xx++;
		if((xx+x)<wwd && buff[xx]==' ') {
			ts=trailing_spaces(y);
			fw=first_wordlen(y+1);
			if (fw && ts>fw) {
				pp=curr(0,y+1);
				xx=0;
				while(*pp!=' ' ) {
					buff[xx++]=*pp;
					memmove(pp,&pp[1],wwd-1);
					pp[wwd-1]=' ';
				}
				xx=0;
				while(*pp==' ' && ++xx<wwd) memmove(pp,&pp[1],wwd-1);
				if(blankline(lineno(y+1)+1)) delete_line(y+1);
				display_text();
			}
		}
		else test_para(x,y);
	 }
	break;
#define ALT_Y 21+128
	  case ALT_Y:				/* Kill to EOL */
	 pp=curr(x,y);
	 while(pp<(curr(0,y)+wwd)) {
		*pp=' ';
		pp++;
	 }
	 disp_line(y);
	 break;
	  case CTRL_Y:				/* Kill line */
	  case ALT_D:
	 delete_line(y);
	break;
	  case CTRL_D:				/* Kill word */
	 delete_word(x,y);
	 test_para(x,y);
	break;
	  case INS:					/* Toggle insert mode */
	 inserting ^=TRUE;
	 insert_line();
	break;
	  case F3:					/* New buffer (erase file) */
	 erase_buffer(&x,&y);
	break;
	  case ALT_B:
	  case F4:					/* Reformat paragraph */
	 paraform(0,y,0);
	break;
	  case F5:					/* Mark start of block */
	blkbeg=lineno(y)+1;
	if (blkbeg>blkend) blkend=lines;
	display_text();
        break;
	  case F6:					/* Mark end of block */
        blkend=lineno(y)+1;
	if (blkend<blkbeg) blkbeg=1;
	display_text();
	break;
	  case F7:					/* Move a block */
	move_block(y);
	break;
	  case F8:					/* Copy a block */
	copy_block(y);
	break;
	  case F9:					/* Delete a block */
	delete_block();
	break;
	  case ALT_J:				/* Jump to DOS */
	do_spawn("");
	break;
	  case ALT_U:
	  case F10:					/* Unmark a block */
	blkbeg=blkend=0;
	display_text();
	break;
	  case FWD:					/* => */
	forward(&x,&y);
	break;
      default:
        if (!isprint(c))
	  break;
LiteralBreakIn:
	if (curr(x,y)==endptr-1 || (lineno(y)+1>=lines && inserting && *curr(wwd-2,y)!=' ')) {
	  error_message(" End of Buffer ");
	  break;
	}
	if (inserting) {
	  buff=curr(x,y);
	  movmem(buff,buff+1,wwd-1-x);
	}
	buff=curr(x,y);
	if (buff < endptr) {
	  if (buff >= lstptr) lstptr=buff+1;
	  *buff=c;
	  disp_line(y);
	}
	buff=curr(wwd-1,y);
	if (endptr && *buff !=' ') {
	  for (b=buff+1;b<endptr;b++)
		if (*b==' ' && *(b+1)==' ') break;
	  movmem(buff+1,buff+2,(unsigned int)(b-buff-1));
	  *(buff+1)=' ';
	  svx=x;
	  svlw=lastword(x,y);
	  x=wwd-1;
	  if (*(buff-1) !=' ') back_word(&x,&y,buff);
	  tx=x;
	  carrtn(&x,&y,TRUE);
	  if (svlw) x=svx-tx;
	  else {
	    x=svx;
	    --y;
	  }
	}
	forward(&x,&y);
	break;
   }
    if (depart) break;
  }
  inserting = TRUE;
  insert_line();
  findlast();
  return(lstptr);
}

/* Erase the buffer */

static void pascal erase_buffer (int *x,int *y) {

  if(ask_question(" Erase text window\n Are you sure? (y/N)")=='Y') {
      lstptr=bfptr=topptr;
      *x=*y=0;
	  memset(bfptr,' ',(unsigned int)(lines * wwd));
      blkbeg=blkend=0;
      display_text();
  }
}

/* Ask to save */

static char pascal ask_save (void) {

  char retval;

  retval=ask_question(" Exit Mini Text Editor\n Save file? (Y/n)");
  switch ((int)retval) {
	case '\r':
	case 'Y':	return 0;
	case 'N':	return 1;
	case ESC:	return 2;
  }
  return -1;
}

/* Ask to quit */

static char pascal ask_quit (void) {

  char retval;

  retval=ask_question(" Abort entry of this\n file? (Y/n)");
  switch ((int)retval) {
	case '\r':
	case 'Y':	return 1;
	case ESC:
	case 'N':	return 2;
  }
  return -1;
}


/* See if a word is the last word on the line */

static int pascal lastword (int x,int y) {

  char *bf=curr(x,y);

  while(x++<wwd-1)
    if(*bf++==' ')
      return 0;
  return 1;
}

/* Go to the last displayable character on line */

static void pascal last_char (int *x,int *y) {

  char *bf;

  *x=wwd-1;
  bf=curr(0,*y);
  while(*x && *(bf+ *x) == ' ')
    --(*x);
    if (*x && *x < wwd-1)
      (*x)++;
}

/* Test to see if paragraph should be reformed */

static void pascal test_para (int x,int y) {

  int ts,fw;
  char *p;

  if ((scroll_lock() || quoting) && y< lines) {
	p=curr(0,y+1);
	if(memchr(p,'>',6)) return;
	if(blankline(lineno(y)+1)) return;
	ts=trailing_spaces(y);
    fw=first_wordlen(y+1);
	if (fw && ts>fw) paraform(x,y,0);
  }
}

/* Count the trailing spaces on a line */
static int pascal trailing_spaces (int y) {

  int x=wwd-1,ct=0;
  char *bf=curr(0,y);

  while(x>=0) {
    if (*(bf+x)!=' ')
      break;
    --x;
    ct++;
  }
  return ct;
}

/* Count the length of the first word on a line */

static int pascal first_wordlen (int y) {
  int ct=0,x=0;
  char *bf=curr(0,y);

  while(x<wwd-1 && *(bf+x)==' ')
    x++;
  while (x+ct < wwd-1 && *(bf+x+ct)!=' ')
    ct++;
  return ct;
}

/* Form paragraph */

static void pascal paraform (int x,int y, char longer) {

  char *cp1,*cp2,*cpend,*svcp;
  int x1,oneline=0;

  if(longer>1) {
	oneline=1;
	longer=1;
  }
  if (blankline(lineno(y)+1))
     return;
  if (!blkbeg) {
	blkbeg=blkend=lineno(y)+1;
	blkend++;
	if(!oneline) {
		while(blkend<lines) {
		  if (blankline(blkend)) break;
		  blkend++;
		}
		--blkend;
	}
	else if(blkend<lines && !blankline(blkend)) blkend++;
  }
  if (lineno(y)!=blkbeg-1) x=0;
  x1=x;
  cp1=topptr+(blkbeg-1)* wwd+x;
    if(!oneline) {
	  while(*cp1==' ') {
		cp1++;
		x1++;
	  }
  }
  cp2=cp1;
  cpend=topptr+blkend * wwd;
  while(cp2<cpend) {
	if(memchr((topptr+(blkbeg-1)*wwd+x),'>',6))	{
		blkbeg++;
		cp1=topptr+(blkbeg-1)*wwd+x;
		cp2=cp1;
		continue;
	}
	while(*cp2==' '&& cp2 < cpend) cp2++;
	  if (cp2==cpend) break; /* at a word */
      while (*cp2 != ' ' && cp2<cpend) {
		if(x1>=(wwd-1)) { /* wrap the word */
		  svcp=cp1+(wwd-x1);
		  while(*--cp1 !=' ') {
			*cp1=' ';
			--cp2;
		  }
		  x1=0;
		  blkbeg++;
		  cp1=svcp;
		}
		*cp1++ =*cp2++;
		x1++;
	  }
	  if (cp2<cpend) {
		*cp1++ = ' ';
		x1++;
	  }
  }
  while(cp1<cpend) *cp1++ = ' ';
  blkbeg++;
  if (blkbeg<=blkend) delete_block();
  blkbeg=blkend=0;
  display_text();
  findlast();
}

/* Test for a blank line */

static int pascal blankline (int line) {

  char *cp;
  int x;

  cp=topptr+(line-1)* wwd;
  for (x=0;x<wwd;x++)
    if(*(cp+x)!=' ')
      break;
  return(x==wwd);
}

/* Delete a word */

static void pascal delete_word (int x,int y) {

  int wct=0;
  char *cp1, *cp2;

  cp1=cp2=curr(x,y);
  if(*cp2 == ' ')
    while (*cp2 == ' ' && x+wct<wwd) {
      wct++;
      cp2++;
    }
  else {
    while (*cp2 !=' ' && x + wct < wwd) {
      wct++;
      cp2++;
    }
    while (*cp2 == ' ' && x+wct<wwd) {
      wct++;
      cp2++;
    }
  }
  movmem(cp2,cp1,wwd-x-wct);
  setmem(cp1+wwd-x-wct,wct,' ');
  display_text();
  findlast();
}

/* Delete a line */

static void pascal delete_line (int y) {

  char *cp1,*cp2;
  int len;

  cp1=bfptr+y*wwd;
  cp2=cp1+wwd;
  if (cp1<lstptr) {
	len=(int)(endptr-cp2);
    movmem(cp2,cp1,len);
    lstptr -=wwd;
	setmem(endptr - wwd,(int)wwd,' ');
    display_text();
  }
  else findlast();
}

/* Delete a block */

static void pascal delete_block () {

  char *cp1,*cp2;
  int len;

  if(!blkbeg || !blkend) {
    putchar(BELL);
    return;
  }
  cp1=topptr+blkend*wwd;
  cp2=topptr+(blkbeg-1)*wwd;
  len=(int)(endptr-cp1);
  movmem (cp1,cp2,len);
  setmem(cp2+len,(int)(endptr-(cp2+len)),' ');
  blkbeg=blkend=0;
  lstptr-=(cp1-cp2);
  display_text();
}

/* Move and copy text blocks */

static void pascal mvblock (int y,int moving) {

  char *cp1,*cp2,*hd;
  int len;
  if (!blkbeg || !blkend) {
    putchar (BELL);
    return;
  }
  if (lineno(y)>=blkbeg-1 && lineno(y)<=blkend-1) {
    error_message("Can't move/copy a block onto itself");
    return;
  }
  len=(blkend-blkbeg+1)*wwd;
  if ((hd=malloc(len))==0)
    return;
  cp1=topptr+(blkbeg-1) * wwd;
  movmem(cp1,hd,len);
  cp2=topptr+lineno(y)*wwd;
  if (moving) {
    if (lineno(y)>blkbeg-1)
      cp2-=len;
    do_display_text=0;
    delete_block();
    do_display_text=1;
  }
  if (cp2+len<=endptr) {
	movmem(cp2,cp2+len,(unsigned int)(endptr-cp2-len));
    movmem(hd,cp2,len);
  }
  free(hd);
  blkbeg=blkend=0;
  display_text();
}

/* Copy a block */

static void pascal copy_block (int y) {

  mvblock(y,FALSE);
  findlast();
}

/* Move a block */

static void pascal move_block (int y) {

  mvblock(y,TRUE);
}

/* Find last character in buffer */

static void pascal findlast () {

  register char *lp=endptr-1;
  register char *tp=topptr;

  while (lp>tp && (*lp==' ' || *lp == '\0')) {
    if (*lp=='\0')
      *lp=' ';
    --lp;
  }
  if (*lp !=' ')
    lp++;
  lstptr=lp;
}

/* Go to end of data in buffer */

static void pascal find_end (int *x,int *y) {

  int ct;

  bfptr=lstptr;
  ct=(int)((lstptr-topptr)%wsz);
  bfptr-=ct;
  if(bfptr+wsz>endptr)
    bfptr=endptr-wsz;
  *y=(ct/wwd);
  *x=0;
  downward(y);
}

/* Carriage return */

static void pascal carrtn (int *x,int *y,int insert) {

  int insct;
  char *cp,*nl;
  int ctl=2;

  cp=curr(*x,*y);
  nl=cp+((cp-topptr)%wwd);
  if (lineno(*y) +2<lines)
    if(insert && nl < endptr) {
	  insct = (int)wwd-*x;
      while(ctl--) {
	if(endptr>cp+insct) {
	  movmem(cp,cp+insct,(unsigned int)(endptr-insct-cp));
	  setmem(cp,insct,' ');
	}
	else if (ctl==1)
	  setmem(cp,(int)(endptr-cp),' ');
	cp+=insct * 2;
	insct = *x;
      }
    }
  *x=0;
  downward(y);
  if (insert) {
    test_para(*x,*y);
    display_text();
  }
  if (lineno(*y) +2<lines)
    if (insert)
      if ((lstptr + wwd)<=endptr)
	if (lstptr > curr(*x,*y))
	  lstptr+=wwd;
}

/* Move buffer offset back one position */

static void pascal backspace (int *x,int *y) {

  if (*x==0) {
    *x=wwd-1;
    upward(y);
  }
  else
    --(*x);
}

/* Move the buffer offset foreward one word */

static void pascal fore_word (int *x,int *y,char *bf) {

  while (*bf!=' ') {
    if (spaceup(x,y,&bf)==0)
      return;
    if (*x==0)
      break;
  }
  while (*bf==' ')
    if (spaceup(x,y,&bf)==0)
      return;
}

static int pascal spaceup(int *x,int *y,char **bf) {

  if (*bf == lstptr)
    return 0;
  (*bf)++;
  forward(x,y);
  return 1;
}

/* Move the buffer offset backward one word */

static void pascal back_word (int *x,int *y,char *bf) {

  spacedn(x,y,&bf);
  while (*bf==' ')
    if(spacedn(x,y,&bf) == 0)
      return;
  while (*bf!=' ') {
    if(*x==0)
      return;
    if (spacedn(x,y,&bf)==0)
      return;
  }
  spaceup(x,y,&bf);
}

static int pascal spacedn (int *x,int *y,char **bf) {

  if (*bf==topptr)
    return 0;
  --(*bf);
  backspace(x,y);
  return 1;
}

/* Move the buffer offset forward one position */

static void pascal forward (int *x,int *y) {

  int ww=wwd;

  (*x)++;
  if(*x == ww) {
    downward(y);
    *x=0;
  }
}

/* Move the buffer offset down one position */

static int pascal downward (int *y) {

  if (*y < wht-1) {
    (*y)++;
    return 1;
  }
  else if ((bfptr + wsz)<endptr) {
    bfptr+=wwd;
    scroll(wnd,UP);
    disp_line(wht-1);
    return 1;
  }
  return 0;
}

/* Move the buffer offset up one position */

static void pascal upward (int *y) {

  if (*y)
    --(*y);
  else if ((topptr+wwd)<=bfptr) {
    bfptr-=wwd;
    scroll(wnd,DN);
    disp_line(0);
  }
}

/* Display all lines in a window */

static void pascal display_text () {

  int y=0;

  if (do_display_text)
    while (y<wht)
      disp_line(y++);
}

/* Display a line */

static void pascal disp_line (int y) {

  int x=0,atr=WNORMAL;

  if (blkbeg || blkend) if (lineno(y) >=blkbeg-1) if (lineno(y)<=blkend-1) atr=WACCENT;

  while (x<wwd) {
    displ(wnd,x+1,y+1,*(bfptr+y*wwd+x),atr);
    x++;
  }
}

/* Set insert/exchange cursor shape */

static void pascal insert_line () {

  set_cursor_type(inserting ? 0x0607: 0x0106);
}


/* Quote-mark the text in the buffer */


static void pascal quote_mark (int x,int y) {

	char *pp;

	x=0;
	if(blankline(lineno(y)+1)) {
		quoting=0;
		*keybuf=0;
		return;
	}
	if(pp=(memchr(curr(x,y),'>',6))) {
		memmove(&pp[1],pp,(curr(x,y)+wwd)-&pp[1]);
		*pp='>';
		disp_line(y);
		sprintf(keybuf,"%c%c",DN,HOME);
	}
	else {
		sprintf(keybuf,"%s%c%c",qstr,DN,HOME);
	}
	quoting=inserting=TRUE;
}


/* UnQuote-mark the text in the buffer */

static void pascal unquote (int *x,int *y) {

	char *p;
	char *pp;

	*x=0;
	p=curr(*x,*y);
	while(p<endptr) {
		if(blankline(lineno(*y)+1)) {
			break;
		}
		pp=memchr(p,'>',6);
		if(pp) {
			if(pp[1]=='>') {	/* Must have been requoted */
				memmove(pp,&pp[1],(curr(*x,*y)+wwd)-&pp[1]);
				p[wwd-1]=' ';
			}
			else {		/* Must be first-time quote */
				if(pp[1]==' ') pp+=2;
				else pp++;
				memmove(p,pp,(curr(*x,*y)+wwd)-pp);
				pp=&p[(curr(*x,*y)+wwd)-pp];
				while(pp<&p[wwd]) {
					*pp=' ';
					pp++;
				}
			}
		}
		disp_line(*y);
		if(!downward(y)) break;
		p=curr(*x,*y);
	}
}


void pascal save_text (int justblk, int append) {	/* Save file or block */

	int fp;
	char *p;
	char *endit;
	char temp[90];

	  findlast();
	  endit=lstptr;
	  p=topptr;
	  if(justblk) {
		  if(!blkbeg || !blkend) {
			error_message(" No block marked ");
			pause();
			return;
		  }
		  p=topptr+(blkbeg-1)* wwd;
		  endit=topptr+(blkend-1)*wwd;
		  if(endit>lstptr) endit=lstptr;
	  }
	  if(endit>p) {
		  any_message(" Saving ");		/* Save file */
		  unlink(notefile);
		  if(!append)fp=creat(notefile,S_IWRITE);
		  else fp=_open(notefile,O_RDWR | O_DENYWRITE | O_BINARY | O_APPEND);
		  if(fp== -1) {
			error_message(" Couldn't create/open file ");
			pause();
		  }
		  else {
			  lseek(fp,0L,SEEK_END);
			  while(p<lstptr) {
				strncpy(temp,p,wwd);
				p+=wwd;
				temp[wwd]='\0';
				rstrip(temp);
				if(*temp) {
					_write(fp,temp,strlen(temp));
					if(!stricmp(notefile,"MSGTMP") && !wrapit && !(currarea->attr & ANSI) && !blkbeg && !blkend) {
						if(*p==' ') _write(fp,"\r",1);
						else if(memchr(p,'>',6)) _write(fp,"\r",1);
						else if (memchr(temp,'>',6)) _write(fp,"\r",1);
						else if (strlen(temp)<(wwd-9)) {
							if (strcspn(p," ")>(wwd-9)-strlen(temp)) _write(fp,"\r",1);
							else {
								_write(fp," ",1);
								if(strchr("?!.",temp[strlen(temp)-1])) _write(fp," ",1);
							}
						}
						else {
							_write(fp," ",1);
							if(strchr("?!.",temp[strlen(temp)-1])) _write(fp," ",1);
						}
					}
					else _write(fp,"\r\n",2);	/* Trailing cr/lf */
				}
				else _write(fp,"\r\n",2);		/* Just cr/lf (blank line) */
			  }
			  _close(fp);
		  }
	  }
	clear_message();
}



void pascal load_text (int y, int insertit) {	/* Load to line #y */

  int fp;
  char *p;
  char temp[90];

  p=curr(0,y);
  if(!insertit) {
	memset(p,' ',(unsigned int)(wwd * (lines-y)));
  }
  fp=_open(notefile,O_RDONLY | O_BINARY | O_DENYNONE);
  if (fp != -1) {								/* Load file */
	any_message(" Loading ");
	while (!eof(fp) && p<endptr) {
		if(!fgetsx(temp,wwd,fp)) break;		/* line at a time */
		if(*temp==26) break;				/* end of file marker */
		temp[wwd]=0;
		while(*temp && temp[strlen(temp)-1]=='\n') temp[strlen(temp)-1]=0;	/* Strip trailing cr's */
		if(!insertit) {
			memcpy(p,temp,strlen(temp));
		}
		else {
			memmove(&p[wwd],p,(unsigned int)(endptr-&p[wwd]));
			memset(p,' ',wwd);	/* Set this line to blanks */
			memcpy(p,temp,strlen(temp));
		}
		p+=wwd;
	}
	if (!eof(fp)) {								/* Didn't get whole file */
		any_message(" Not enough room for whole file... ");
		pause();
		*endptr=0;
		lstptr=endptr;
	}
	_close(fp);
  }
  else if (strcmp(notefile,"MSGTMP")) {
	error_message(" Couldn't open file. ");
	pause();
  }
  findlast();
  clear_message();
  display_text();
}



static void pascal file_funcs (int y,int command) {

  int c;
  WINDOW *sur;
  char selcs[]="SLCRWM";
  char *p;
  char s[133];
  struct ffblk f;
  int x;

  if(!command) {
	  sur=establish_window(9,3,7,21);
	  set_help("filehelp  ",maxy-1,19);
	  set_colors(sur,ALL,RED,YELLOW,BRIGHT);
	  set_title(sur," File Funcs ");
	  display_window(sur);
	  wprintf(sur," Save         (aS)\n Load         (aL)\n Change Name  (aC)\n Read Block   (aR)\n Write Block  (aW)");
	  c=get_selection(sur,1,selcs);
	  delete_window(sur);
  }
  else c=command;
  switch(c) {
	case 1: save_text(0,0);
			break;
	case 2: any_message(" WARNING: Any changes will be lost! ");
			sleep(1);
			p=get_string("File to load:",78,notefile,'A');
			if(*p) {
				strcpy(notefile,p);
				load_text(0,0);
			}
			break;
	case 3:	p=get_string("New Filename:",78,notefile,'A');
			if(*p) {
				 strcpy(notefile,p);
				 wframe(wnd);
				 x=(maxx-1)-strlen(notefile);
				 if(x<49)x=49;
                 current_color=readtextcolor + (readtextback * 16);
				 lowvideo();
				 dprintf(x,6,"%0.28s",notefile);
			}
			break;
	case 4: strcpy(s,notefile);
			p=get_string("File to insert:",78,NULL,'A');
			if(*p) {
				strcpy(notefile,p);
				load_text(y,1);
				strcpy(notefile,s);
			}
			break;
	case 5: strcpy(s,notefile);
			p=get_string("File to write:",78,NULL,'A');
			if(*p) {
				strcpy(notefile,p);
				if(!findfirst(p,&f,0)) {
					c=ask_question(" File exists.\n Overwrite? (Y/n) ");
					if(c=='\r' || c=='Y') save_text(1,0);
					else {
						c=ask_question(" Append to existing\n File? (Y/n) ");
						if(c=='\r' || c=='Y') save_text(1,1);
					}
				}
				else {
					save_text(1,0);
				}
			}
			strcpy(notefile,s);
			break;
  }
  set_help("edithelp  ",0,0);
}
