/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*           This module was originally written by Bob Hartman              */
/*                                                                          */
/*                                                                          */
/*                  BinkleyTerm FOSSIL version 5 module                     */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifdef OS_2

void fossil_ver (void)
{
   extern int old_fossil;
   old_fossil = 0;
}

/* get_key () - P. Fitzsimmons */
int get_key (void)
{
    int c = getch ();

    if (!c || c == 0xE0)   /* OS/2 returns 0xE0 if one of the *
                            * grey edit keys are hit          */
        c = getch () << 8;
    return (c);
}

#else /* ifdef OS_2 */

int Port = 0;

int FailSafeTimer = 0;

void fill_buffer (void);

void fossil_ver ()
{
   union REGS r;
   struct SREGS s;

   char far *q;

   q = (char far *) &fossil_info;

   r.x.cx = sizeof (struct finfo);

   segread (&s);
   s.es = s.ds = FP_SEG (q);

   r.x.di = r.x.si = FP_OFF (q);

   r.x.dx = Port;
   r.x.ax = 0x1b00;

   (void) int86x (0x14, &r, &r, &s);

   if ((fossil_info.curr_fossil > 0) && !rev3)
      old_fossil = 0;
}

void com_kick ()
{
   XON_DISABLE ();                               /* Uncork the transmitter */
   XON_ENABLE ();
}

unsigned int Com_ (char request, byte parm1)
{
   union REGS r;

   r.h.ah = request;
   r.h.al = parm1;
   r.x.dx = Port;

   return int86 (0x14, &r, &r);
}

int ComInit (int WhichPort, int failsafe)
{
   union REGS r;
   struct SREGS s;
   char far *ptr = &ctrlc_ctr;
   int ret;

   fossil_fetch_pointer = fossil_buffer;
   fossil_count = 0;

   r.h.ah = 4;
   r.x.dx = (Port = WhichPort);
   r.x.bx = 0x4f50;

   segread (&s);

   s.es = s.ds = FP_SEG (ptr);
   r.x.cx = FP_OFF (ptr);

   ret = int86x (0x14, &r, &r, &s);

   if (ret == 0x1954)
      {
      FailSafeTimer = failsafe;
      r.x.ax = 0x0f01;
      r.x.dx = Port;
      (void) int86 (0x14, &r, &r);
      }
   return (ret);
}

int modem_in (void)
{
   unsigned char c;

   while (fossil_count == 0)
      {
      fill_buffer ();
      if (fossil_count == 0)
          time_release ();
      }
   --fossil_count;
   c = (unsigned char) *fossil_fetch_pointer++;
   return ((int)c);
}

int peekbyte (void)
{
   unsigned char c;

   if (fossil_count == 0)
      {
      fill_buffer ();
      if (fossil_count == 0)
         return (-1);
      }
   c = (unsigned char) *fossil_fetch_pointer;
   return ((int)c);
}

void fill_buffer (void)
{
   union REGS r;
   struct SREGS s;
   char far *ptr = (char far *)fossil_buffer;
   int ret;

   if (fossil_count != 0)
      return;

   fossil_fetch_pointer = fossil_buffer;

   if (old_fossil == 0)
      {
      r.x.cx = 127;
      r.x.dx = Port;

      segread (&s);

      r.x.di = r.x.si = FP_OFF (ptr);
      s.es = s.ds = FP_SEG (ptr);

      r.x.ax = 0x1800;

      fossil_count = int86x (0x14, &r, &r, &s);
      }
   else
      {
      r.x.ax = 0x0c00;
      r.x.dx = Port;

      ret = int86 (0x14, &r, &r);

      if (ret != -1)
         {
         fossil_count = 1;
         *fossil_fetch_pointer = (char)ret;
         r.x.ax = 0x0200;
         (void) int86 (0x14, &r, &r);
         }
      }
}

void clear_inbound (void)
{
   union REGS r;

   fossil_fetch_pointer = fossil_buffer;
   fossil_count = 0;

   r.x.ax = 0x0a00;
   r.x.dx = Port;

   (void) int86 (0x14, &r, &r);
}


void clear_outbound (void)
{
   union REGS r;

   out_send_pointer = out_buffer;
   out_count = 0;

   r.x.ax = 0x0900;
   r.x.dx = Port;

   (void) int86 (0x14, &r, &r);
}

int modem_status (void)
{
   union REGS r;
   int ret;

   r.x.ax = 0x0300;
   r.x.dx = Port;

   ret = int86 (0x14, &r, &r);

   if (fossil_count != 0)
      ret |= 256;

   return (ret);
}

void do_break (int on_off)
{
   union REGS r;

   r.h.al = (char) on_off;
   r.h.ah = 0x1a;
   r.x.dx = Port;

   (void) int86 (0x14, &r, &r);
}

void mdm_enable (unsigned int mask)
{
   union REGS r;

   CLEAR_INBOUND ();

   r.h.al = (byte) (mask | comm_bits | parity | stop_bits);
   r.h.ah = 0;
   r.x.dx = Port;

   (void) int86 (0x14, &r, &r);
}

void mdm_disable (void)
{
   union REGS r;

   fossil_fetch_pointer = fossil_buffer;
   fossil_count = 0;

   r.x.ax = 0x0500;
   r.x.dx = Port;

   (void) int86 (0x14, &r, &r);
}

void unbuffer_bytes (void)
{
   if (out_count == 0)
      return;

   SENDCHARS ((char far *)out_buffer, out_count, 1);

   out_send_pointer = out_buffer;
   out_count = 0;
}

void buffer_byte (char c)
{
   if (out_count == 128)
      unbuffer_bytes ();

   out_count++;
   *out_send_pointer++ = c;
}

void sendbyte (unsigned char c)
{
   union REGS r;
   int done = 0;

   if (out_count != 0)
      unbuffer_bytes ();

   while (done == 0)
      {
      r.h.ah = 0x0b;
      r.h.al = c;
      r.x.dx = Port;

      done = int86 (0x14, &r, &r);
      if (done == 0)
         {
         (void) peekbyte (); /* Waiting for output, try to get input */
         time_release ();
         }
      }
}

void sendchars (char far *str, unsigned len, int dcd)
{
   union REGS r1, r2;
   struct SREGS s;
   long timer = 0L;
   int sent;

   if (old_fossil)
      {
      r1.x.ax = 0x0b00;
      r1.x.dx = Port;

      while (len != 0)
         {
         r1.h.al = *str;
         if (int86 (0x14, &r1, &r2) != 0)
            {
            str++;
            len--;
            }
         else
            {
            if (FailSafeTimer)
               {
               if (timer == 0L)
                  timer = timerset (FailSafeTimer);
               else
                  {
                  if (timeup (timer))
                     {
                     clear_outbound ();
                     LOWER_DTR ();
                     return;
                     }
                  }
               }

            (void) peekbyte (); /* Waiting for output, try to get input */
            time_release ();
            if (dcd && !CARRIER)
               return;
            }
         }
      return;
      }

   r1.x.ax = 0x1900;
   r1.x.dx = Port;

   segread (&s);

   s.es = s.ds = FP_SEG (str);

   while (len != 0)
      {
      r1.x.cx = len;
      r1.x.si = r1.x.di = FP_OFF (str);
      sent = int86x (0x14, &r1, &r2, &s);
      if (sent == (int)len)
         return;

      len -= sent;
      str += sent;

      if (FailSafeTimer)
         {
         if (timer == 0L)
            timer = timerset (FailSafeTimer);
         else
            {
            if (timeup (timer))
               {
               clear_outbound ();
               LOWER_DTR ();
               return;
               }
            }
         }

      (void) peekbyte (); /* Waiting for output, try to get input */
      time_release ();
      if (dcd && !CARRIER)
         return;
      }
}

void fossil_gotoxy (int col, int row)
{
   union REGS r;

   r.h.dh = (char) row;
   r.h.dl = (char) col;
   r.x.ax = 0x1100;

   (void) int86 (0x14, &r, &r);
}

int fossil_whereami (void)
{
   union REGS r;
   r.x.ax = 0x1200;
   (void) int86 (0x14, &r, &r);
   return r.x.dx;
}

int fossil_wherey (void)
{
   union REGS r;
   r.x.ax = 0x1200;
   (void) int86 (0x14, &r, &r);
   return (int) r.h.dh;
}

int fossil_wherex (void)
{
   union REGS r;
   r.x.ax = 0x1200;
   (void) int86 (0x14, &r, &r);
   return (int) r.h.dl;
}

#endif

