/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*          This module was originally written by Vince Perriello           */
/*                                                                          */
/*                                                                          */
/*               BinkleyTerm Terminal/Script Download Module                */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

/*
 * Handle downloads from terminal mode.
 *
 * If filespec is NULL and we need a filename, ask for it.
 * Otherwise, assume that the spec we got is OK and use it.
 */

int Download (char *filepath, int prot, char *extern_ptr)
{
   int k;
   int err = 1;
   unsigned save1, save2, save3;

   if ((prot == 'X') || (prot == 'Y') || extern_ptr != NULL)
      if (filepath != NULL)
         strcpy (junk, filepath);
      else
         {
         scr_printf (MSG_TXT(M_FILE_TO_RECEIVE));
         junk[0] = '\0';
         (void) fgets (junk, 100, stdin);
         if ((junk[0] == '\0') || (junk[0] == '\n'))
            return (0);
         k = strlen (junk);
         if (k <= 1)
            return (0);
         junk[--k] = '\0';
         }

   save1 = comm_bits;
   save2 = parity;
   save3 = stop_bits;
   comm_bits = BITS_8;
   parity = NO_PARITY;
   stop_bits = STOP_1;
   program_baud ();
   XON_DISABLE ();

   /* If external protocol requested, call it */

   if (extern_ptr != NULL)
      do_extern ("Get", prot, junk);
   else switch (prot)
      {
      case 'X':
      case 'Y':
      err = Xmodem_Receive_File (download_path, junk);
      break;

      case 'Z':
      err = get_Zmodem (download_path, NULL);
      break;

      default:
      err = Batch_Receive (download_path);
      break;
      }

   comm_bits = save1;
   parity = save2;
   stop_bits = save3;
   program_baud ();
   XON_ENABLE ();
   gong ();

   return (err);
}
