/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*          This module was originally written by Vince Perriello           */
/*                                                                          */
/*                                                                          */
/*                       BinkleyTerm Terminal Module                        */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

void term_Poll (ADDRP);

int b_term ()
{
   int j, k;
   int c;
   unsigned int mask = 0xff;
   int gateway_mode = 0;
   int done;
   struct _key_fnc_hdr *OldKeyFncHdr;
   char *autodl = "**\030B00";                   /* Zmodem autodl str.  */
   char *search_autodl = autodl;
   FILE *logfile = NULL;                         /* log file stream
                                                  * descriptor */
   char prot;
   char *p;

   int retval = 1;                               /* What to tell the mainline */
   ADDR baddr;

   OldKeyFncHdr = KbMapSet (&TrmnlKeyFncHdr);

   set_prior(4);                                    /* Always High */
   vfossil_cursor (1);
   done = 0;
   first_block = 0;
   if ((term_init != NULL) && (!CARRIER))
      {
      (void) set_baud (max_baud.rate_value, 0);
      mdm_cmd_string (term_init, 0);                /* then the modem init */
      }

   while (!done)
      {
      c = -1;
      if (CHAR_AVAIL ())
         {
         c = MODEM_IN ();

         if (comm_bits == BITS_7)
            c &= 0x7f;

         /* Check for Zmodem AutoDownload sequence */
         if ((c & 0x7f) == (int) *search_autodl)
            {
            if (!*++search_autodl)
               {
               scr_printf (MSG_TXT(M_ZMODEM_STARTED));
               CLEAR_INBOUND();

               (void) Download (NULL, (int)'Z', NULL);

               scr_printf (MSG_TXT(M_ZMODEM_FINISHED));
               search_autodl = autodl;
               }
            }
         else search_autodl = autodl;

/*
 * I really don't like looking for this piece of crap, but people
 * seem to really want it, so I guess I lose.  Now if only
 * QuickBBS would do things that were ANSI compatible - ugh!
 */
         if (c == '')
            {
            screen_clear ();
            }
         else if ((c == ENQ) && (answerback != NULL))
            {
            mdm_cmd_string (answerback, 1);
            }
         else
            {
            WRITE_ANSI ((char)c);
            }

         if (logfile != NULL)
            {
            (void) fwrite (&c, 1, 1, logfile);
            }
         }

      if (KEYPRESS () || ctrlc_ctr)
         {
         c = 0;
         if (ctrlc_ctr)
            {
            /* We got a ^C, so output it properly */
            while (KEYPRESS ())                  /* Flush keyboard buffer */
               (void) FOSSIL_CHAR ();
            ctrlc_ctr = 0;
            SENDBYTE (3);
            continue;
            }
/* Get the keystroke. Map it, saving the original keystroke. */

         k = (int) KbRemap (j = FOSSIL_CHAR ());

/* See if it mapped into 'toggle gateway'. If so, do it.     */

         if ((unsigned)k == F_TERM_GATEWAYMODE)
            {
            gateway_mode = ~gateway_mode;
            continue;
            }
/*
 * It wasn't 'toggle gateway'. See if it's a command at all.
 * Or if we are currently in gateway mode.
 * 
 * If we are in gateway mode, we will send the raw keystroke
 * out the comm port (zero plus scan code in the case of a
 * function key).
 *
 * Otherwise, we'll send normal keystrokes out verbatim, and
 * apply "ANSI mapping" to function keys.
 */
         if (gateway_mode || ((unsigned)k & F_TERM_BASE) != F_TERM_BASE)
            {
            if (comm_bits == BITS_7)
               mask = 0x7f;
            else mask = 0xff;

            if (gateway_mode)
               {
               SENDBYTE ((unsigned char )(c = (j & mask)));
               if (c == 0)
                  SENDBYTE ((unsigned char)(((unsigned int)j >> 8) & mask));
               }
            else
               {
               c = k & mask;
               if (c != 0)
                  SENDBYTE ((unsigned char) c);
               else
                  ansi_map ((unsigned) k);
               }
            continue;
            }
/*
 * It's a command key, which has been remapped to one of our internal
 * codes. Dispatch on it.
 */
         if (!term_overlay (k))
            continue;
      /* else */
         switch ((unsigned)k)
            {
            case F_TERM_CAPTUREFILE:
               if (logfile != NULL)
                  {
                  (void) fclose (logfile);
                  logfile = NULL;
                  (void) sprintf (junk, MSG_TXT(M_LOG_CLOSED), capturename);
                  scr_printf(junk);
                  break;
                  }

               if ((logptr == NULL) || (*logptr == '\0'))
                  {
                  scr_printf (MSG_TXT(M_INPUT_LOGFILE));
                  (void) fgets (capturename, 100, stdin);
                  if ((k = (int) strlen (capturename)) != 0)
                     capturename[--k] = '\0'; /* no '\n' */
                  }
               else
                  {
                  (void) strcpy (capturename, logptr);
                  k = 1;
                  }
               if (k)
                  {
                  logfile = share_fopen (capturename, "ab", DENY_WRITE);
                  if (logfile == NULL)
                     (void) sprintf (junk, MSG_TXT(M_LOG_NOT_OPEN), capturename);
                  else
                     (void) sprintf (junk, MSG_TXT(M_LOG_OPEN), capturename);
                  scr_printf(junk);
                  }
               break;

             case F_TERM_POLLBOSS:
               term_Poll (&boss_addr);
               break;

             case F_TERM_POLLNODE:
               scr_printf ("\n");
               scr_printf (MSG_TXT(M_ENTER_NET_NODE));
               if (!get_number (junk))
                  break;
               if ((find_address (junk, &baddr) == 0)
               || ((int)(baddr.Net) < 0)
               || ((int)(baddr.Node) < 0)
               || (nodefind (&baddr,1) == 0)) 
                  {
                  (void) printf ("\n%s '%s'\n", &(MSG_TXT(M_NO_ADDRESS)[1]), junk);
                  break;
                  }

               if (!baddr.Zone)
                  baddr.Zone = found_zone;

               term_Poll (&baddr);
               break;

            case F_TERM_DIALGROUP:
               if (!list_search ())
                  screen_clear ();
               break;

            case F_TERM_MAILERMODE:
               if (port_ptr != original_port)
                  {
                  status_line (" %s COM%d:", MSG_TXT(M_SWITCHING_BACK), original_port + 1);
                  MDM_DISABLE ();
                  port_ptr = original_port;
                  if (Cominit (port_ptr, buftmo) != 0x1954)
                     {
                     port_ptr = c;
                     (void) Cominit(port_ptr, buftmo);
                     }
                  program_baud ();
                  RAISE_DTR ();
                  }
               retval = 0;

            /* Fall into exit code */

            case F_TERM_EXITBINK:
               if (logfile != NULL)
                  (void) fclose (logfile);
               done = 1;
               break;

            case F_TERM_UPLOAD:
               scr_printf (MSG_TXT(M_READY_TO_SEND));
               scr_printf (MSG_TXT(M_WHICH_PROTOCOL));
               scr_printf ("Z)modem     S)EAlink     T)elink     X)modem\r\n");
               if (extern_protocols != NULL)
                  {
                  scr_printf (extern_protocols);
                  scr_printf ("\r\n");
                  }

               scr_printf (MSG_TXT(M_CHOOSE));
               junk[0] = '\0';
               (void) fgets (junk, 100, stdin);
               if ((junk[0] == '\0') || (junk[0] == '\n'))
                  break;
               if (!(prot = (char) toupper (junk[0])))
                  break;
               p = NULL;
               if ((strchr (native_protocols, prot) == NULL)
               && ((extern_protocols == NULL) ? (1) : (p = strchr (extern_protocols, prot)) == NULL))
                  {
                  scr_printf (MSG_TXT(M_DONT_KNOW_PROTO));
                  break;
                  }
               scr_printf (MSG_TXT(M_FILE_TO_SEND));
               junk[0] = '\0';
               (void) fgets (junk, 100, stdin);
               if ((k = strlen (junk)) != 0)
                  junk[--k] = '\0';
               if ((junk[0] == '\0') || (junk[0] == '\n'))
                  break;

               if ((!k) || (!dexists (junk)))
                  break;

               (void) Upload (junk, (int) prot, p);
               break;

            case F_TERM_DOWNLOAD:
               scr_printf (MSG_TXT(M_READY_TO_RECEIVE));
               scr_printf (MSG_TXT(M_WHICH_PROTOCOL));
               scr_printf ("Z)modem     S)EAlink     T)elink     X)modem\r\n");
               if (extern_protocols != NULL)
                  {
                  scr_printf (extern_protocols);
                  scr_printf ("\r\n");
                  }
               scr_printf (MSG_TXT(M_CHOOSE));
               junk[0] = '\0';
               (void) fgets (junk, 100, stdin);
               if ((junk[0] == '\0') || (junk[0] == '\n'))
                  break;
               if (!(prot = (char) toupper (junk[0])))
                  break;
               p = NULL;
               if ((strchr (native_protocols, prot) == NULL)
               && ((extern_protocols == NULL) ? (1) : (p = strchr (extern_protocols, prot)) == NULL))
                  {
                  scr_printf (MSG_TXT(M_DONT_KNOW_PROTO));
                  break;
                  }

               (void) Download (NULL, (int)prot, p);
               break;

            case F_TERM_HELPSCREEN:
               main_help ();
               break;

            default:
               break;
            }
         }
      if (c == -1)
         time_release ();
      }

   (void) KbMapSet(OldKeyFncHdr);

   set_prior(2);                                          /* Regular */
   return (retval);
}

/*
 * Handle polls from terminal mode.
 */

void term_Poll (ADDRP address)
{
   unsigned save1, save2, save3;

   save1 = comm_bits;
   save2 = parity;
   save3 = stop_bits;

   un_attended = 1;
   if (fullscreen)
      {
      sb_dirty ();
      opening_banner ();
      mailer_banner ();

      (void) sprintf (junk, "%s", Full_Addr_Str (address));
      junk[28] = '\0';

      sb_fill (hold_hWnd, ' ', colors.hold);
      SendMessage( hold_hWnd, WM_COMMAND, GD_MODE, 0L );
      SendMessage( hold_hWnd, WM_COMMAND, GD_CLR, 0L );
      sb_move (hold_hWnd, 2, 12);
      sb_puts( hold_Poll, MSG_TXT(M_POLLING_COLON));
      sb_move (hold_hWnd, 4, 16 - strlen (junk) / 2);
      sb_puts( hold_Addr, junk);
      sb_show ();
      }
   else
      {
      scr_printf (MSG_TXT(M_MAILER_MODE));
      }
   if (!CARRIER)
      mdm_hangup ();
   (void) do_mail (address, 1);
   un_attended = 0;
   if (fullscreen)
      {
      screen_clear ();
      }
   else
      {
      scr_printf ("\r\n");
      }
   scr_printf (MSG_TXT(M_MANUAL_MODE));

   comm_bits = save1;
   parity = save2;
   stop_bits = save3;
   program_baud ();

   gong ();
   vfossil_cursor (1);
}
