/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*               This module was written by Vince Perriello                 */
/*                                                                          */
/*                                                                          */
/*              BinkleyTerm External Protocol Handler Module                */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

#ifdef Snoop
#include "snserver.h"
extern HSNOOP hsnoop;
#endif

void do_extern (char *cmd, int prot, char *name)
{
   int j;
   struct baud_str *i;
   char junk[100];
   char *c, *p, *m;
   FILE *ctlfile;

   for (j = 0; j < 100; j++)                     /* Make sure it's all  */
      junk[j] = '\0';                            /* zeroes...           */

   for (j = 0; j < 5; j++)
      {
      if (protos[j].first_char == (char) prot)
         break;
      }
   j = protos[j].entry;
   c = m = protocols[j];
   p = NULL;
   while (*m)                                    /* Until end of string */
      {
      if ((*m == '\\') || (*m == ':'))           /* Look for last path  */
         p = m;                                  /* Delimiter           */
      m++;
      }
   m = &junk[0];
   /* It doesn't pay to be too smart here. Dots can appear in dir names   */
   while (c != p)                                /* Copy to last '\'    */
      *m++ = *c++;
   while (*c != '.')                             /* Then to the dot     */
      *m++ = *c++;
   (void) strcat (&junk[0], ".ctl");                    /* Then add extension  */

   /*
    * At this point we have the Control File name in (junk), Now let's open
    * the file and put our good stuff in there.
    */

   (void) unlink (junk);                                /* Delete old copies   */
   if ((ctlfile = fopen (junk, "at")) == NULL)   /* Try to open it      */
      {
      status_line (MSG_TXT(M_NO_CTL_FILE), junk);
      return;
      }

   (void) fprintf (ctlfile, "Port %d\n", (port_ptr + 1));      /* Port n              */
   if (lock_baud && (cur_baud.rate_value >= (unsigned)lock_baud))
      i = &max_baud;
   else i = &btypes[baud];

   (void) fprintf (ctlfile, "Modem %x %x %x %x %x\n",   /* All modem params    */
         hfComHandle, i->rate_value, handshake_mask, carrier_mask, i->rate_mask);
   (void) fprintf (ctlfile, "Baud %u\n", i->rate_value);/* Baud Rate           */
   (void) fprintf (ctlfile, "%s %s\n", cmd, name);      /* Actual command      */
   (void) fclose (ctlfile);
   /* The file is now written. Turn off everything. */

   if (!share)
      MDM_DISABLE ();                            /* Turn off FOSSIL     */

#ifdef Snoop
   if (hsnoop != (HSNOOP)NULL)
      snoop_close();
#endif /* Snoop */

   if (status_log != NULL)
      (void) fclose (status_log);                       /* Close status log    */

   /* We're all set. Build the command and execute it. */

   c = protocols[j];
   (void) sprintf (e_input, "%s %s -p%d -b%u %s", c, c, (port_ptr + 1), i->rate_value, junk);
   b_spawn (e_input);                            /* Execute command     */

   /* Back from external protocol. Turn it all back on. */

   if (Cominit (port_ptr, buftmo) != 0x1954)     /* FOSSIL back on      */
      {
      (void) printf ("\n%s\n", MSG_TXT(M_FOSSIL_GONE));
      exit (1);
      }

   if (status_log != NULL)                       /* Reopen status log   */
      {
      if ((status_log = share_fopen (log_name, "at", DENY_WRITE)) == NULL)
         {
         (void) printf ("\n%s\n", MSG_TXT(M_NO_LOGFILE));
         }
      }

   program_baud ();
   XON_ENABLE ();                                /* and reenable XON/XOF */
}

