/*--------------------------------------------------------------------------*/
/*                                                                          */
/*                                                                          */
/*      ------------         Bit-Bucket Software, Co.                       */
/*      \ 10001101 /         Writers and Distributors of                    */
/*       \ 011110 /          Freely Available<tm> Software.                 */
/*        \ 1011 /                                                          */
/*         ------                                                           */
/*                                                                          */
/*  (C) Copyright 1987-91, Bit Bucket Software Co., a Delaware Corporation. */
/*                                                                          */
/*                                                                          */
/*               This module was written by Vince Perriello                 */
/*                                                                          */
/*                                                                          */
/*                       BinkleyTerm "HELP" Module                          */
/*                                                                          */
/*                                                                          */
/*    For complete  details  of the licensing restrictions, please refer    */
/*    to the License  agreement,  which  is published in its entirety in    */
/*    the MAKEFILE and BT.C, and also contained in the file LICENSE.250.    */
/*                                                                          */
/*    USE  OF THIS FILE IS SUBJECT TO THE  RESTRICTIONS CONTAINED IN THE    */
/*    BINKLEYTERM  LICENSING  AGREEMENT.  IF YOU DO NOT FIND THE TEXT OF    */
/*    THIS  AGREEMENT IN ANY OF THE  AFOREMENTIONED FILES,  OR IF YOU DO    */
/*    NOT HAVE THESE FILES,  YOU  SHOULD  IMMEDIATELY CONTACT BIT BUCKET    */
/*    SOFTWARE CO.  AT ONE OF THE  ADDRESSES  LISTED BELOW.  IN NO EVENT    */
/*    SHOULD YOU  PROCEED TO USE THIS FILE  WITHOUT HAVING  ACCEPTED THE    */
/*    TERMS  OF  THE  BINKLEYTERM  LICENSING  AGREEMENT,  OR  SUCH OTHER    */
/*    AGREEMENT AS YOU ARE ABLE TO REACH WITH BIT BUCKET SOFTWARE, CO.      */
/*                                                                          */
/*                                                                          */
/* You can contact Bit Bucket Software Co. at any one of the following      */
/* addresses:                                                               */
/*                                                                          */
/* Bit Bucket Software Co.        FidoNet  1:104/501, 1:343/491             */
/* P.O. Box 460398                AlterNet 7:491/0                          */
/* Aurora, CO 80046               BBS-Net  86:2030/1                        */
/*                                Internet f491.n343.z1.fidonet.org         */
/*                                                                          */
/* Please feel free to contact us at any time to share your comments about  */
/* our software and/or licensing policies.                                  */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/* Include this file before any other includes or defines! */

#include "includes.h"

void main_help ()
{
#ifndef MILQ
   char *c;
   int i;
   char j[255];

   screen_clear ();
   for (i = 0; i <= 10; i++)
      scr_printf (MSG_TXT(M_MAIN_HELP+i));

   for (i = 0; i < 9; i++)
      {
      if (keys[i] != NULL)
         {
         c = keys[i];
         while (*c && (*c != '\n'))
            {
            if (*c == '\r')
               *c = '|';
            ++c;
            }

         (void) sprintf (j, MSG_TXT(M_MACRO_HELP), i + 1, keys[i]);
         j[79] = '\0';
         scr_printf (j);

         c = keys[i];
         while (*c && (*c != '\n'))
            {
            if (*c == '|')
               *c = '\r';
            ++c;
            }
         }
      }

   scr_printf (MSG_TXT(M_PRESS_ANYKEY));
   (void) FOSSIL_CHAR ();
   scr_printf ("\r\n");
#else
   DialogBox( MilqueRsrc,
              "TrmnlHelp",
              MilqueTrmnlWnd,
              HelpDlgPrc );
#endif
}

void mailer_help ()
{
#ifndef MILQ
   int i;
   char j[100];

   screen_clear ();
   for (i = 0; i <= 14; i++)
      scr_printf (MSG_TXT(M_MAILER_HELP+i));

   if (do_screen_blank)
      {
      scr_printf (MSG_TXT(M_BLANK_HELP));
      }
      
   if (BBSreader != NULL)
      {
      (void) sprintf (j, MSG_TXT(M_EDITOR_HELP), BBSreader);
      scr_printf (j);
      }

   for (i = 0; i < 9; i++)
      {
      if (shells[i] != NULL)
         {
         (void) sprintf (j,MSG_TXT(M_SHELL_HELP), i + 1, shells[i]);
         scr_printf (j);
         }
      }

   scr_printf (MSG_TXT(M_PRESS_ANYKEY));
   (void) FOSSIL_CHAR ();
   scr_printf ("\r\n");
#else
   DialogBox( MilqueRsrc,
              "MailerHelp",
              MilqueMailerWnd,
              HelpDlgPrc );
#endif
}
