REM DRIVER PROGRAM FOR BATCH EDITOR (BED)

DEFINT A-Z
NUMFLDS% = 32
MAXCALLS = 8
DIM YNVAL$(NUMFLDS%),ROW%(NUMFLDS%),COL%(NUMFLDS%),PROMPT$(NUMFLDS%),_
    FLDSIZE%(NUMFLDS%),FLDTYPE$(NUMFLDS%),FLDVAL$(NUMFLDS%),HLP$(NUMFLDS%),_
    INITYN$(NUMFLDS%),INITVAL$(NUMFLDS%),CORDER(MAXCALLS),DEFORD(MAXCALLS)    

CALL INITIALIZE (NUMFLDS%,INITYN$(),ROW%(),COL%(),PROMPT$(),FLDSIZE%(),_
                FLDTYPE$(),INITVAL$(),HLP$()) 
DIM WRDS$(12),INLEN%(3),OUTORD%(3),SPINLEN%(3),SPOUTORD%(3)

DEFORD(1)=13
DEFORD(2)=11
DEFORD(3)=12
DEFORD(4)=14
DEFORD(5)=20
DEFORD(6)=19
DEFORD(7)=27
DEFORD(8)=30

YSPELLED = -1
NSPELLED = 0
ONESPACE$ = " "
AGRO = 23
AGCO = 14
AGPRO$ = "E)dit a file, Q)uit to DOS (E,Q): "
AGVAL$ = "EQ"
AGFLDSIZE = 15
YAG.RO = AGRO
YAG.CO = 5
YAG.PRO$ = "Use what editing specifications (<rtn>=new):"
VLDANS$="YN"
EDPR$ = "R)un, E)dit, S)ave, Q)uit (R,E,S,Q): "
EDRO% = 24
EDCO% = 13
EDVAL$="RESQ"

CALL BRKWORDS (COMMAND$,WRDS$())
NON.OPT = 1
WHILE INSTR(WRDS$(NON.OPT),"/")
   NON.OPT = NON.OPT + 1
WEND
RUN.BATCH = (INSTR(COMMAND$,"/B"))
SPEC.IN.FILE = (INSTR(COMMAND$,"/F"))
ON ERROR GOTO ERRINF
FFF$ = WRDS$(NON.OPT)
IF SPEC.IN.FILE THEN OPEN "I",#1,FFF$
ON ERROR GOTO 0
MORE.QUEUED = (WRDS$(NON.OPT)<>"")
MORE.SPECS = -1
NPASSES = 0

IF WRDS$(1)="" THEN CALL CREDITS
GOSUB GETSPEC
WHILE MORE.SPECS
   NPASSES = NPASSES + 1

   CALL PRTSCRN (NUMFLDS%,YNVAL$(),ROW%(),COL%(),PROMPT$(),FLDSIZE%(),_
                FLDTYPE$(),FLDVAL$(),HLP$())
   ASKAGN:
     IF RUN.BATCH THEN_
        ANS$ = "R"_
     ELSE_
        CO=1:CALL QPRINT (SPACE$(79),EDRO%,CO):_
        ANS$="E":CALL GETCHAR (EDRO%,EDCO%,EDPR$,EDVAL$,ANS$):_
        WHILE ANS$ = "E":_
          CALL GETSCRN (NUMFLDS%,YNVAL$(),ROW%(),COL%(),PROMPT$(),FLDSIZE%(),_
                     FLDTYPE$(),FLDVAL$(),HLP$()):_
          LOCATE EDRO%,1:PRINT SPACE$(79);:_
          ANS$="":CALL GETCHAR (EDRO%,EDCO%,EDPR$,EDVAL$,ANS$):_
        WEND
     IF ANS$ = "R" THEN GOTO DOEDITS
   IF ANS$ = "S" THEN_
       SPEC.FILE$ = FLDVAL$(4):_
       GOSUB SAVESPEC:_
       GOTO ASKAGN
   SKIPEDITS:

   GOSUB GETSPEC
WEND
CLOSE

END

REM ********   GOSUB SUBROUTINES    **********

GETSPEC:

  FFF$ = ""
  IF MORE.QUEUED THEN_
    GOSUB GETFILE
  IF NOT MORE.QUEUED THEN_
    IF RUN.BATCH THEN_
       MORE.SPECS = 0_
    ELSE_
       ANS$="E":_
       LOCATE AGRO,1:PRINT SPACE$(79);:_
       CALL GETCHAR (AGRO,AGCO,AGPRO$,AGVAL$,ANS$):_
       IF ANS$ = "Q" THEN_
          MORE.SPECS = 0_
       ELSE_
          CALL GETSTR (YAG.RO,YAG.CO,YAG.PRO$,AGFLDSIZE,FFF$)
  IF FFF$ = "" THEN_
       FOR I = 1 TO NUMFLDS%:_
         YNVAL$(I)=INITYN$(I):_
         FLDVAL$(I)=INITVAL$(I):_
       NEXT I:_
       RETURN
    ON ERROR GOTO ERRINF
    OPEN "I",#2,FFF$
    FOR I=1 TO NUMFLDS%
      IF FLDTYPE$(I) <> "L" THEN_
        LINE INPUT #2,YNVAL$(I):_
        LINE INPUT #2,FLDVAL$(I)
    NEXT I
    CLOSE #2
    ON ERROR GOTO 0

RETURN

GETFILE:

    IF SPEC.IN.FILE THEN_
      IF EOF(1) THEN_
        MORE.QUEUED = 0_
      ELSE_
        LINE INPUT #1,FFF$_
    ELSE_
      IF WRDS$(NON.OPT)="" THEN_
        MORE.QUEUED = 0_
      ELSE_
        FFF$ = WRDS$(NON.OPT):_
        NON.OPT = NON.OPT + 1
RETURN

SAVESPEC:
  ON ERROR GOTO ERROUT
  FFF$ = SPEC.FILE$
  OPEN "O",#2,FFF$
  FLDVAL$(4) = FFF$
  FOR I=1 TO NUMFLDS%
    IF FLDTYPE$(I)<>"L" THEN_
      PRINT #2,YNVAL$(I):_
      PRINT #2,FLDVAL$(I)
  NEXT I
  CLOSE #2
  ON ERROR GOTO 0
RETURN

DOEDITS:

   GOSUB DECODE
   IF REP.NUMDATE THEN_
       CALL INITDATE (NSPELLED,INFMT$,OUTFMT$,INYRLEN%,OUTYRLEN%,INLEN%(),_
              OUTORD%(),YPOS%,MONPOS%,TOUTLEN%,TINLEN%):_
       NINFLDS% = LEN(INFMT$):_
       NOUTFLDS% = LEN(OUTFMT$):_
       NFIL = (TOUTLEN% - TINLEN%)*(TINLEN% > TOUTLEN%):_
       FILLER$ = STRING$(NFIL,ONESPACE$):_
       TOUTLEN% = TOUTLEN% + NFIL
    IF REP.SPDATE THEN_
       CALL INITDATE (YSPELLED,SPINFMT$,SPOUTFMT$,INYRLEN%,OUTYRLEN%,_
              SPINLEN%(),SPOUTORD%(),SPYPOS%,SPMONPOS%,SPTOUTLEN%,SPTINLEN%):_
       SPNINFLDS% = LEN(SPINFMT$):_
       SPNOUTFLDS% = LEN(SPOUTFMT$):_
       NFIL = (SPTOUTLEN% - SPTINLEN%)*(SPTINLEN% > SPTOUTLEN%):_
       SPFILLER$ = STRING$(NFIL,ONESPACE$):_
       SPTOUTLEN% = SPTOUTLEN% + NFIL:_
REM       FOR I=1 TO 3:PRINT "SPINLEN-";I;"=";SPINLEN%(i);:next:print:input xxx$
REM       YROUTPOS% = INSTR(SPOUTFMT$,"Y"):_
REM       IF OUTYRLEN% < INYRLEN% THEN_
REM          SPFILLER$ = SPACE$(2+INYRLEN%-OUTYRLEN%)_
REM       ELSE_
REM          SPFILLER$ = "  "

   ON ERROR GOTO CHECKAUX
   NUMBADWORDS = 0
   IF BAD.WORDS THEN_
      FFF$ = BADWORDS.FILE$:_
      OPEN "I",#3,FFF$:_
      FLDVAL$(7) = FFF$:_
      NUMBADWORDS = 0:_
      WHILE NOT EOF(3):_
        LINE INPUT #3,X$:_
        NUMBADWORDS = NUMBADWORDS+1:_
      WEND:_
      REDIM BADWORD$(NUMBADWORDS):_
      CLOSE #3:_
      OPEN "I",#3,FFF$:_
      FOR I=1 TO NUMBADWORDS:_
        LINE INPUT #3,BADWORD$(I):_
      NEXT I:_
      CLOSE #3
   NUMLINES% = 0
   IF GLO.SANDR THEN_
      FFF$ = GSANDR.FILE$:_
      OPEN "I",#3,FFF$:_
      FLDVAL$(12) = FFF$:_
      NUMLINES% = 0:_
      WHILE NOT EOF(3):_
        LINE INPUT #3,X$:_
        NUMLINES% = NUMLINES%+1:_
      WEND:_
      REDIM GOT$(NUMLINES%),WANT$(NUMLINES%):_
      CLOSE #3:_
      OPEN "I",#3,FFF$:_
      FOR I=1 TO NUMLINES%:_
        INPUT #3,GOT$(I),WANT$(I):_
      NEXT I:_
      CLOSE #3

   NWRITE! = 0
   NSKIP!  = 0
   NREAD!  = 0

   ON ERROR GOTO ERRINF
   FFF$ = INFILE$
   OPEN "I",#3,FFF$
   FLDVAL$(2) = FFF$
   ON ERROR GOTO ERROUT
   FFF$ = OUTFILE$
   OPEN "O",#4,FFF$
   FLDVAL$(3) = FFF$
   FFF$ = EXC.FILE$
   IF SAVE.EXC THEN OPEN "O",#5,FFF$
   FLDVAL$(9) = FFF$

   IF RUN.BATCH=0 AND SPEC.FILE$ <> "" THEN_
       GOSUB SAVESPEC

   COLOR 0,7
   LOCATE 24,1:PRINT SPACE$(70);
   LOCATE 24,10:PRINT "READS:";
   LOCATE 24,30:PRINT "WRITES:";
   LOCATE 24,50:PRINT "SKIPS:";
 
   GOSUB SETCORDER
   ON ERROR GOTO ERRMAINLOOP
   WHILE NOT EOF(3)
     LINE INPUT #3,LL$
     NREAD! = NREAD!+1
     LOCATE 24,17:PRINT NREAD!;
     IF LEN(LL$) < MINLEN THEN GOTO SKIP
     IF MAXLEN > 0 THEN IF LEN(LL$) > MAXLEN THEN GOTO SKIP
     I=1
     CHK: IF I > NUMBADWORDS THEN GOTO NOSKIP
          IF INSTR(LL$,BADWORD$(I)) THEN GOTO SKIP ELSE I=I+1:GOTO CHK
     NOSKIP:
       FOR I = 1 TO NUMCALLS
         ON CORDER(I) GOTO DOREMOVE,DOUPCASE,DOGLOBAL,DOTRANS,DOCOMMAS,_
                           DOPARENS,DOSPELL,DONUMDATE
         GOTO NXTCALL
            DOREMOVE:  CALL REMOVE (LL$,BAD.CHARS$):GOTO NXTCALL
            DOUPCASE:  CALL UPCASE (LL$):GOTO NXTCALL
            DOGLOBAL:  CALL GLOBAL (LL$,GOT$(),WANT$()):GOTO NXTCALL
            DOTRANS:   CALL TRANSLATE (LL$,TRANS.FROM$,TRANS.TO$):GOTO NXTCALL
            DOCOMMAS:  CALL DELCOMMAS (LL$,RIGHT.JUS,MAXDEC):GOTO NXTCALL
            DOPARENS:  CALL REPPARENS (LL$):GOTO NXTCALL
            DOSPELL:   CALL SPELLDATE (LL$,DSEP$,SPINLEN%(),OUTYRLEN%,_
                          SPTINLEN%,SPTOUTLEN%,SPNINFLDS%,SPNOUTFLDS%,_
                          SPYPOS%,SPMONPOS%,SPOUTORD%(),SPFILLER$):GOTO NXTCALL
            DONUMDATE: CALL NUMDATE (LL$,DSEP$,INLEN%(),OUTYRLEN%,_
                          TINLEN%,TOUTLEN%,NINFLDS%,_
                          NOUTFLDS%,YPOS%,OUTORD%(),FILLER$):GOTO NXTCALL
            NXTCALL:
        NEXT I
     IF PAD.LEN     THEN CALL FIXLEN (LL$,PAD.LEN,SP$)
     PRINT #4,LL$
     NWRITE! = NWRITE!+1
     LOCATE 24,38:PRINT NWRITE!;

     GOTO GOODREC
     SKIP:
       NSKIP! = NSKIP! + 1
       LOCATE 24,57:PRINT NSKIP!;
       IF SAVE.EXC THEN PRINT #5,LL$

     GOODREC:
   WEND
   CLOSE #3
   CLOSE #4
   IF SAVE.EXC THEN CLOSE #5
   ON ERROR GOTO 0
   COLOR 7,0
GOTO SKIPEDITS

DECODE:
  INFILE$ = FLDVAL$(2)
  OUTFILE$ = FLDVAL$(3)
  SPEC.FILE$ = FLDVAL$(4)
  IF YNVAL$(6)="Y" THEN_
     MINLEN = VAL(FLDVAL$(6))_
  ELSE_
     MINLEN = 0
  BAD.WORDS = (YNVAL$(7)="Y")
  BADWORDS.FILE$ = FLDVAL$(7)
  IF YNVAL$(8)="Y" THEN_
     MAXLEN = VAL(FLDVAL$(8))_
  ELSE_
     MAXLEN = 0
  SAVE.EXC = (YNVAL$(9) = "Y")
  EXC.FILE$ = FLDVAL$(9)
  
  UPPER.CASE = (YNVAL$(11) <> "" AND YNVAL$(11) <> "N")
  
  GLO.SANDR = (YNVAL$(12)<>"" AND YNVAL$(12)<>"N")
  GSANDR.FILE$ = FLDVAL$(12)
  
  DEL.CHARS = (YNVAL$(13)<>"" AND YNVAL$(13)<>"N")
  BAD.CHARS$ = FLDVAL$(13)
  TRANS.CHARS = (YNVAL$(14) <> "" AND YNVAL$(14) <> "N")
  TRANS.FROM$ = FLDVAL$(14)
  TRANS.TO$   = FLDVAL$(15)
  PAD.LEN   = VAL(FLDVAL$(17))
  SP$ = " "
  FIX.PARENS  = (YNVAL$(19) <> "" AND YNVAL$(19) <> "N")
  OMIT.COMMAS = (YNVAL$(20) <> "" AND YNVAL$(20) <> "N")
  RIGHT.JUS   = (YNVAL$(21) = "Y")
  MAXDEC      = VAL(FLDVAL$(22))
    
  INYRLEN% = VAL(FLDVAL$(24))
  OUTYRLEN% = VAL(FLDVAL$(25))
  DSEP$ = FLDVAL$(26)
  REP.SPDATE = (YNVAL$(27) <> "" AND YNVAL$(27) <> "N")
  SPINFMT$  = FLDVAL$(28)
  SPOUTFMT$ = FLDVAL$(29)
  REP.NUMDATE = (YNVAL$(30) <> "" AND YNVAL$(30) <> "N")
  INFMT$ = FLDVAL$(31)
  OUTFMT$ = FLDVAL$(32)

RETURN

SETCORDER:
   REM 0 CALLS
   FOR I = 1 TO MAXCALLS
     CORDER(I) = 0
   NEXT I

   REM LOAD ORDER SPECIFIED (OVERLOAD DUPS)
   FOR I = 1 TO MAXCALLS
      X = INSTR("123456789",YNVAL$(DEFORD(I)))
      IF X THEN CORDER(X) = I
   NEXT

   REM COMPRESS IF SKIPPED ANY NUMBERS
   NUMCALLS = 0
   FOR I = 1 TO MAXCALLS
      IF CORDER(I)>0 THEN_
        NUMCALLS = NUMCALLS + 1:_
        CORDER(NUMCALLS)=CORDER(I)
   NEXT I

   REM ADD ANY Y's
   FOR I = 1 TO MAXCALLS
      IF YNVAL$(DEFORD(I))="Y" THEN_
         NUMCALLS = NUMCALLS + 1:_
         CORDER(NUMCALLS)=I
   NEXT I

RETURN

ERRINF:
   X$ = " while reading "
   GOTO GETINFILE

ERROUT:
   X$ = " while writing "
   GOTO GETOUTFILE

ERRMAINLOOP:
   IF ERR = 61 OR ERR = 57 THEN_
      X$ = "  Possible full disk."_
   ELSE X$=""
   X$ = "Error"+STR$(ERR)+" in main loop."+X$+"  Terminating."
   LOCATE 24,1:PRINT " "
   CALL EXPLAIN (X$)
   END

CHECKAUX:
   X$ = "near aux file "
   GOTO GETINFILE

GETINFILE:
      IF ERR = 53 THEN_
         X$="File "+FFF$+" does not exist!":_
         GOTO ASKFILE
GETOUTFILE:
      IF ERR = 64 OR ERR = 75 OR ERR = 76 OR ERR = 67 THEN GOTO ASKFILE
      IF ERR = 62 THEN X$ = ".  Check format.  Not enough data in "
      X$="Error"+STR$(ERR)+" "+X$+FFF$+".  Aborting.":_
      CALL EXPLAIN (X$):_
      END
ASKFILE:
      IF ERR = 64 THEN_
         X$ = FFF$+" is a bad or illegal file name."_
      ELSE IF ERR = 75 THEN_
         X$ = "Bad or illegal path in "+FFF$+"."_
      ELSE IF ERR = 76 THEN_
         X$ = "Path in "+FFF$+" does not exist."_
      ELSE_
         X$ = "Error 67.  "+FFF$+" is probably a bad file name."
      CALL EXPERR (X$)
      RO=23:CO=1:CALL QPRINT (SPACE$(79),RO,CO)
      CO=15:PROMPT$="Enter file name (<rtn> quits):":FLDSIZ=30
      FFF$=""
      CALL GETSTR (RO,CO,PROMPT$,FLDSIZ,FFF$)
      IF FFF$="" THEN END ELSE RESUME

