DEFINT A-Z
DECLARE FUNCTION TDiff! (TA!, TB!)
DECLARE FUNCTION Factorial# (I%)

' FACTOR - Lookup table demonstration using the
' factorial series.

CONST BigFact = 170 'largest factorial for doubles
CONST SecDay& = 24 * 60 * 60&

DIM Fact(0 TO BigFact) AS DOUBLE
DIM t1 AS SINGLE, t2 AS SINGLE, t3 AS SINGLE

' STEP 1 - compute each factorial nTrial times

INPUT "How many trials do you want (1 to 99)? ",_
      NTrials

CLS
PRINT "Step 1"
PRINT USING _
  "Now computing each factorial ## times"; NTrials

t1 = TIMER
FOR I = 1 TO NTrials
	FOR J = 0 TO BigFact
		F# = Factorial#(J)            ' f=j!
	NEXT
NEXT
t2 = TIMER

PRINT "Computing all factorials from 0..170"
PRINT USING "## times took ###.## seconds.";_
      NTrials; TDiff(t1, t2)

' STEP 2 - compute the table, then look up
'          each factorial nTrial times

PRINT : PRINT "Step 2"
PRINT "Now compute table and look up each ";
PRINT USING "factorial ## times."; NTrials

t1 = TIMER

FOR I = 0 TO BigFact
	Fact(I) = Factorial#(I)
NEXT

t2 = TIMER

FOR I = 1 TO NTrials
	FOR J = 0 TO BigFact
		F# = Fact(J)                 ' f=j!
	NEXT
NEXT

t3 = TIMER

PRINT USING "Computing table took ###.## secs.";_
       TDiff(t1, t2)
PRINT USING "Looking up each factorial ##";NTrials;
PRINT USING " times took ###.## seconds.";_
       TDiff(t2, t3)
PRINT USING "Total: ###.## seconds"; TDiff(t1, t3)

'STEP 3 - Compute each factorial as it is needed

PRINT : PRINT "Step 3"
PRINT "Clearing the table, and computing each "
PRINT USING_
   "factorial as it is needed (for ##) lookups.";_
     NTrials

t1 = TIMER
FOR I = 0 TO BigFact
	Fact(I) = -1        'unknown value
NEXT

FOR I = 1 TO NTrials
	FOR J = 0 TO BigFact
		F# = Fact(J)     'lookup
		IF F# < 0 THEN         'Check if valid
			Fact(J) = Factorial#(J)
		END IF
	NEXT
NEXT
t2 = TIMER

PRINT "Clearing table and computing each"
PRINT USING "factorial as it was needed for ##";_
     NTrials
PRINT USING "lookups took ###.## seconds.";_
     TDiff(t1, t2)

' STEP 4 - write the table to disk (we are
'   not timing this step, because if you are
'   loading it from disk, you presumably don't
'   care how long it took to compute it.

OPEN "Facts.Tmp" FOR RANDOM AS 1
FOR I = 1 TO BigFact
	PUT #1, I, Fact(I)
NEXT I
CLOSE 1

' Flush the disk buffer, so that the time
' is not affected by having the data in a
' disk buffer.

SHELL "CHkdsk > nul:"

' STEP 5 - read the table from disk, and
'          use each factorial 5 times

t1 = TIMER
OPEN "FACTS.TMP" FOR RANDOM AS 1
FOR I = 1 TO BigFact
	GET #1, I, Fact(I)
NEXT I
CLOSE 1
t2 = TIMER

FOR I = 1 TO NTrials
	FOR J = 0 TO BigFact
		F# = Fact(J)                 ' f=j!
	NEXT
NEXT

t3 = TIMER
PRINT : PRINT "Step 5"
PRINT USING_
  "Reading table from disk took ###.## secs.";_
   TDiff(t1, t2)
PRINT USING_
  "Looking up each factorial ## times";NTrials;
PRINT USING_
  " took ###.## seconds."; TDiff(t2, t3)
PRINT USING "Total: ###.## seconds"; TDiff(t1, t3)

'************************************************
' Factorial - compute the factorial of a number *
'
' INP:   i - the # to compute the factorial of
' OUT:     The factorial of the number, unless a
'          number greater than BIG_FACT or less
'          than zero is passed in (which results
'          in 0.0).
'************************************************
'
FUNCTION Factorial# (I%)

IF I = 0 THEN
	F# = 1
ELSE
	IF (I > 0) AND (I <= BigFact) THEN
		F# = 1
		FOR k = 1 TO I
			F# = F# * k
		NEXT
	ELSE
		F# = 0
	END IF
END IF

Factorial# = F#

END FUNCTION

FUNCTION TDiff! (TA!, TB!)
	TT! = TB! - TA!
	IF TT! < 0 THEN TT! = TT! + SecDay&
	TDiff = TT!
END FUNCTION
