/********************************************************/
/*							*/
/*	ro_post.c	post processor for ro		*/
/*							*/
/*	ro version 1.10					*/
/*							*/
/*	Copyright (c) 1990 by Ted A. Campbell		*/
/*		Bywater Software			*/
/*		P. O. Box 4023				*/
/*		Duke Station				*/
/*		Durham, NC  27706			*/
/*							*/
/* Permission is hereby granted for all commercial and	*/
/* non-commercial reproduction and distribution of this */
/* material provided this notice is included.		*/
/*							*/
/********************************************************/

#include "ro.h"

/* #define	DEBUG_PP */

#ifdef	POSTPROCESS

static	char	ps_tbuf[ PP_STRINGSIZE ];
static 	char 	temp[ PP_STRINGSIZE ];
static	int	pp = 0;

/***	Storage Areas for Printer/Terminal Control Strings ***/

char	ps_init[ PP_STRINGSIZE ] = { 0 };
char	ps_deinit[ PP_STRINGSIZE ] = { 0 };
char	ps_bdon[ PP_STRINGSIZE ] = { 0 };
char	ps_bdoff[ PP_STRINGSIZE ] = { 0 };
char	ps_iton[ PP_STRINGSIZE ] = { 0 };
char	ps_itoff[ PP_STRINGSIZE ] = { 0 };
char	ps_hup[ PP_STRINGSIZE ] = { 0 };
char	ps_hdn[ PP_STRINGSIZE ] = { 0 };

/****************************************************************

	pp_init()	Initialize post-processor

****************************************************************/

pp_init( name )
   char *name;
   {
   FILE *fp;

   /*** Attempt to open the post-processor TABfile ***/

   if ( ( fp = fopen( name, "r" )) == NULL )
      {
      fprintf( stderr, "Cannot open TABfile %s. \n", name );
      pp = 0;
      return -1;
      }

   /*** Read the name of the printer/terminal device ***/

   if ( feof( fp ) == 0 )
      {
      fgets( ps_tbuf, PP_STRINGSIZE - 1, fp );
      }

   if ( ro_verbose == TRUE )
      {
      fprintf( stderr, "Preparing output for %s \n", ps_tbuf );
      }

   /*** Read the remainder of the post-processor TABfile ***/

   while ( feof( fp ) == 0 )
      {
      fgets( ps_tbuf, PP_STRINGSIZE - 1, fp );
      pp_read( ps_tbuf );
      }

   /*** Close the post-processor TABfile ***/

   fclose( fp );
   pp = 1;

   /*** Send out initialization string ***/

   pp_puts( ps_init );

   }

pp_read( s )
   char *s;
   {
   register int c;

   /*** First read to whitespace to find identifier ***/ 

   c = 0;
   temp[ c ] = 0;
   while ( isspace( s[ c ] ) == 0 )
      {
      temp[ c ] = s[ c ];
      temp[ ++c ] = 0;
      }

#ifdef   DEBUG_PP
   fprintf( stderr, "DEBUG pp_init(): read string <%s> \n", s );
   fprintf( stderr, "DEBUG pp_init(): found identifier <%s> \n", temp );
#endif

   /*** See if the identifier matches our descriptions ***/

   if ( strcmp( temp, "twinit" ) == 0 )
      {
      pp_getstr( s, ps_init );
      }
   else if ( strcmp( temp, "twrest" ) == 0 )
      {
      pp_getstr( s, ps_deinit );
      }
   else if ( strcmp( temp, "bdon" ) == 0 )
      {
      pp_getstr( s, ps_bdon );
      }
   else if ( strcmp( temp, "bdoff" ) == 0 )
      {
      pp_getstr( s, ps_bdoff );
      }
   else if ( strcmp( temp, "iton" ) == 0 )
      {
      pp_getstr( s, ps_iton );
      }
   else if ( strcmp( temp, "itoff" ) == 0 )
      {
      pp_getstr( s, ps_itoff );
      }
   else if ( strcmp( temp, "up" ) == 0 )
      {
      pp_getstr( s, ps_hup );
      }
   else if ( strcmp( temp, "down" ) == 0 )
      {
      pp_getstr( s, ps_hdn );
      }
   else 
      {
      return -1;
      }
   }

pp_getstr( s, buf )
   char *s, *buf;
   {
   register int c, d;
   char delimiter;

#ifdef   DEBUG_PP
      fprintf( stderr, "\tDEBUG pp_getstr():  called \n" );
#endif

   /*** First wind past identifier ***/ 

   c = 0;
   while ( isspace( s[ c ] ) == 0 )
      {
      ++c;
      }

   /*** Now wind past whitespace ***/

   while( isspace( s[ c ] ) != 0 )
      {
      ++c;
      }

   /*** Identify delimiter ***/

   delimiter = s[ c ];
   ++c;

#ifdef   DEBUG_PP
      fprintf( stderr, "\tDEBUG pp_getstr():  delimiter is 0x%x <%c> \n", 
         delimiter, delimiter );
#endif

   /*** Process individual characters of the string ***/

   d = 0;
   while ( ( s[ c ] != delimiter ) && ( s[ c ] != 0 ))
      {

#ifdef   DEBUG_PP
      fprintf( stderr, "\tDEBUG pp_getstr():  char 0x%x <%c> \n", s[ c ], s[ c ] );
#endif

      switch( s[ c ] )
         {
         case '\\':
            ++c;
            switch( s[ c ] )
               {
               case '0':
                  buf[ d ] = ( s[ c + 1 ] - '0' ) * 010 
                     + ( s[ c + 2 ] - '0' );
                  c += 2;
                  ++d;
                  buf[ d ] = 0;
               default:
                  break;
               }
            break;
         default:
            buf[ d ] = s[ c ];
            ++d;
            buf[ d ] = 0;
            break;
         }
      ++c;
      }
   }

/****************************************************************

   ro_post()   Post-processor output function

****************************************************************/

ro_post( c )
   int c;
   {
   static int esc_pending = 0;

   if ( pp == 0 )
      {
      putchar ( c );
      return;
      }

   if ( esc_pending == 0 )
      {
      switch( c )
         {
         case ESCAPE:
            esc_pending = 1;
            return;
         default:
            putchar( c );
            return;
         }
      }
   else
      {
      esc_pending = 0;
      switch( c )
         {
         case ROMAN:
            pp_puts( ps_bdoff );
            pp_puts( ps_itoff );
            break;
         case ITALIC:
            pp_puts( ps_iton );
            break;
         case BOLD:
            pp_puts( ps_bdon );
            break;
         case HALFUP:
            pp_puts( ps_hup );
            break;
         case HALFDOWN:
            pp_puts( ps_hdn );
            break;
         default:
            fprintf( stderr, "Unrecognized output escape sequence ESC-0x%x \n", c );
            break;
         }
      }
   }

/****************************************************************

   pp_deinit()   Deinitialize post-processor

****************************************************************/

pp_deinit()
   {
   if ( pp == 1 )
      {
      pp_puts( ps_deinit );
      }
   }

pp_puts( s )
   char *s;
   {
   register int c;

   for ( c = 0; s[ c ] != 0; ++c )
      {
      putchar( s[ c ] );
      }

   }

#endif

