/***************************************************************

	ui_pbm.c        Portable Bit-Map Routines
			for the Bywater Graphical User Interface

			Copyright (c) 1991, Ted A. Campbell

			Bywater Software
			P. O. Box 4023 
			Duke Station 
			Durham, NC  27706

			email: tcamp@hercules.acpub.duke.edu

	Copyright and Permissions Information:

	All U.S. and international copyrights are claimed by the
	author. The author grants permission to use this code
	and software based on it under the following conditions:
	(a) in general, the code and software based upon it may be 
	used by individuals and by non-profit organizations; (b) it
	may also be utilized by governmental agencies in any country,
	with the exception of military agencies; (c) the code and/or
	software based upon it may not be sold for a profit without
	an explicit and specific permission from the author, except
	that a minimal fee may be charged for media on which it is
	copied, and for copying and handling; (d) the code must be 
	distributed in the form in which it has been released by the
	author; and (e) the code and software based upon it may not 
	be used for illegal activities. 

***************************************************************/


#include "stdio.h"
#include "ctype.h"

#ifdef  __STDC__
#include "malloc.h"
#include "stdlib.h"
#else
extern char * malloc();
#include "math.h"
#endif

#include "bw.h"
#include "gr.h"
#include "ui.h"

#define BUFSIZE 128
#define TESTINT 0
#define ACC 50

extern char *pbm_fgets();

ui_pbmread( file, pmstruct, foreground, background )
   char *file;
   struct pbm_struct *pmstruct;
   int foreground, background;
   {
   FILE *fp;
   char *p;
   static int w, h, i, ctr;
   register int x, y;
   static char tbuf[ BW_EBUFSIZE ];

   if ( ( fp = fopen( file, "r" ) ) == NULL )
      {
      strcpy( tbuf, ui_fontpath );
      strcat( tbuf, file );
      if ( ( fp = fopen( tbuf, "r" ) ) == NULL )
	 {
	 strcpy( tbuf, "../../fonts/" );
	 strcat( tbuf, file );
	 if ( ( fp = fopen( tbuf, "r" ) ) == NULL )
	    {
#ifdef OLD_DEBUG
	    fprintf( stderr, "Failed to open file %s \n", file );
#endif
	    return FALSE;
	    }
	 }
      }

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "Opened: %s   ", file );
   bw_debug( bw_ebuf );
#endif

   /* Read first line to check for PBM magic number */

   p = pbm_fgets( tbuf, BUFSIZE, fp );
   if ( tbuf[ 0 ] != 'P' )
      {
#ifdef DEBUG
      sprintf( bw_ebuf, "File %s is not in PBM format", file );
      bw_error( bw_ebuf );
#endif
      return BW_ERROR;
      }
   if ( tbuf[ 1 ] != '1' )
      {
#ifdef DEBUG
      sprintf( bw_ebuf, "File %s is not in PBM format", file );
      bw_error( bw_ebuf );
#endif
      return BW_ERROR;
      }

   /* Read next line to get width and height */

   p = pbm_fgets( tbuf, BUFSIZE, fp );
   sscanf( tbuf, "%d %d", &w, &h );
   pmstruct->xsize = w;
   pmstruct->ysize = h;

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "Sizes read: x: %03d  y: %03d   ", pmstruct->xsize, pmstruct->ysize );
   bw_debug( bw_ebuf );
#endif

   /* display the bitmap in hidden memory before getting image */

   y = 0;
   while ( ( y < pmstruct->ysize ) && ( feof( fp ) == 0 ))
      {
      x = 0;
      p = pbm_fgets( tbuf, BUFSIZE, fp );
      ctr = 0;
      if ( p == NULL )
	 {
#ifdef DEBUG
	 bw_error( "PBM file terminated prematurely" );
#endif
	 return FALSE;
	 }
      while( ( x < pmstruct->xsize ) && ( tbuf[ ctr ] != '\n' ))
	 {
	 i = pbm_nextc( tbuf, &ctr );
	 if ( i == 0 )
	    {
	    gr_pixel( GR_HIDDEN, x, ( pmstruct->ysize - y), background );
	    }
	 else if ( i == 1 )
	    {
	    gr_pixel( GR_HIDDEN, x, ( pmstruct->ysize - y), foreground );
	    }
	 ++x;
	 }
      ++y;
      }

   /* close the bitmap file */

   fclose( fp );

   /* save the image */

   gr_imsave( GR_HIDDEN, TRUE, 0, 1, x - 1, y, &( pmstruct->image ) );

   return TRUE;

   }

ui_pbmshow( screen, x, y, pmstruct )
   int screen;
   int x, y;
   struct pbm_struct *pmstruct;
   {

   if ( pmstruct == NULL )
      {
#ifdef DEBUG
      bw_error( "ui_pmshow() received NULL pbm structure" );
#endif
      return BW_ERROR;
      }

#ifdef OLD_DEBUG
   bw_debug( "Ready to show image" );
#endif
   gr_imsave( screen, FALSE, x, y + 1, x + pmstruct->xsize - 1,
      y + pmstruct->ysize - 1, &( pmstruct->image ) );

   }

char *
pbm_fgets( string, n, stream )
   char *string;
   int n;
   FILE *stream;
   {
   register int c;
   char *p;

   c = TRUE;
   while( c == TRUE )
      {
      p = fgets( string, n, stream );
      if ( p == NULL )
	 {
	 return NULL;
	 }
      if ( string[ 0 ] != '#' )
	 {
#ifdef OLD_DEBUG
	 sprintf( bw_ebuf, "read line <%s>", string );
	 bw_debug( bw_ebuf );
#endif
	 return p;
	 }
      }
   }

pbm_nextc( s, ctr )
   char *s;
   int *ctr;
   {
   static char tbuf[ 12 ];
   register int c;

#ifdef OLD_DEBUG
   bw_message( "entered pbm_nextc()" );
#endif

   while( isspace( s[ *ctr ] ) != FALSE )
      {
      ++*ctr;
      }

   c = 0;
   while( isspace( s[*ctr ] ) == FALSE )
      {
      tbuf[ c ] = s[ *ctr ];
      ++*ctr;
      ++c;
      tbuf[ c ] = 0;
      }

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "read char %d", atoi( tbuf ) );
   bw_debug( bw_ebuf );
#endif

   return atoi( tbuf );
   }

ui_pbmcenter( screen, x1, y1, x2, y2, pmstruct )
   int screen;
   int x1, y1, x2, y2;
   struct pbm_struct *pmstruct;
   {
   register int x, y;

   /* calculate coordinates */

   x = x1 + ((( x2 - x1 ) - ( pmstruct->xsize )) / 2 );
   y = y1 + ((( y2 - y1 ) - ( pmstruct->ysize )) / 2 );

   /* show the icon */

   ui_pbmshow( screen, x, y, pmstruct );

   }

ui_pbmtile( screen, x1, y1, x2, y2, pmstruct )
   int screen;
   int x1, y1, x2, y2;
   struct pbm_struct *pmstruct;
   {
   register int x, y;
   static int image;

   /* check size */

   if ( ( x2 - x1 ) < pmstruct->xsize )
      {
#ifdef DEBUG
      sprintf( bw_ebuf, "Area too small: x1 %d x2 %d:  xsize %d",
	 x1, x2, pmstruct->xsize );
      bw_error( bw_ebuf );
#endif
      return BW_ERROR;
      }

   if ( ( y2 - y1 ) < pmstruct->ysize )
      {
#ifdef DEBUG
      sprintf( bw_ebuf, "Area too small: y1 %d y2 %d:  ysize %d",
	 y1, y2, pmstruct->ysize );
      bw_error( bw_ebuf );
#endif
      return BW_ERROR;
      }

#ifdef OLD_DEBUG
   sprintf( bw_ebuf, "x1 %d, y1 %d, x2, %d, y2 %d, xsize, %d, ysize %d",
      x1, y1, x2, y2, pmstruct->xsize, pmstruct->ysize );
   bw_debug( bw_ebuf );
   bw_message( "           " );
#endif

   /* fill area with tile except right and top areas */

   for ( x = x1; x < ( x2 - pmstruct->xsize ); x += pmstruct->xsize )
      {

#ifdef OLD_DEBUG
      sprintf( bw_ebuf, "x = %d", x );
      bw_debug( bw_ebuf );
      bw_message( "           " );
#endif
      for ( y = y1; y < ( y2 - pmstruct->ysize ); y += pmstruct->ysize )
	 {
#ifdef OLD_DEBUG
	 sprintf( bw_ebuf, "y = %d", y );
	 bw_debug( bw_ebuf );
	 bw_message( "               " );
#endif
	 ui_pbmshow( screen, x, y, pmstruct );
#ifdef OLD_DEBUG
	 bw_debug( "icon displayed" );
	 bw_message( "              " );
#endif
	 }

      }

   /* first the right remaining area */

   if ( x != x2 )
      {
      gr_imsave( screen, TRUE, x1, y1, x1 + ( x2 - x ), y, &image );
      gr_imsave( screen, FALSE, x, y1, x2, y, &image );
      }
   gr_imfree( image );

   /* then the top remaining area */

   if ( y != y2 )
      {
      gr_imsave( screen, TRUE, x1, y1, x2, y1 + ( y2 - y ), &image );
      gr_imsave( screen, FALSE, x1, y, x2, y2, &image );
      }
   gr_imfree( image );
   }
