#include <stdio.h>
#include <math.h>
#include "astro.h"

/* corrects ra and dec, both in radians, for precession from epoch 1 to epoch 2.
 * the epochs are given by their modified JDs, mjd1 and mjd2, respectively.
 * N.B. ra and dec are modifed IN PLACE.
 * TODO: find a better algorithm; this one is not even symmetric.
 */
precess (mjd1, mjd2, ra, dec)
double mjd1, mjd2;	/* initial and final epoch modified JDs */
double *ra, *dec;	/* ra/dec for mjd1 in, for mjd2 out */
{
	static double lastmjd1 = -10000, lastmjd2 = -10000;
	static double m, n, nyrs;
	double dra, ddec;	/* ra and dec corrections */

	if (mjd1 != lastmjd1 || mjd2 != lastmjd2) {
	    double t1, t2; /* Julian centuries of 36525 days since Jan .5 1900*/
	    double m1, n1; /* "constants" for t1 */
	    double m2, n2; /* "constants" for t2 */
	    t1 = mjd1/36525.;
	    t2 = mjd2/36525.;
	    m1 = 3.07234+(1.86e-3*t1);
	    n1 = 20.0468-(8.5e-3*t1);
	    m2 = 3.07234+(1.86e-3*t2);
	    n2 = 20.0468-(8.5e-3*t2);
	    m = (m1+m2)/2;	/* average m for the two epochs */
	    n = (n1+n2)/2;	/* average n for the two epochs */
	    nyrs = (mjd2-mjd1)/365.2425;
	    lastmjd1 = mjd1;
	    lastmjd2 = mjd2;
	}

	dra = (m+(n*sin(*ra)*tan(*dec)/15))*7.272205e-5*nyrs;
	ddec = n*cos(*ra)*4.848137e-6*nyrs;
	*ra += dra;
	*dec += ddec;
	/* added by ECD */
	if (*dec > PI/2) {
	    *dec = PI - *dec;
	    *ra += PI;
	} else if (*dec < -PI/2) {
	    *dec = -PI - *dec;
	    *ra += PI;
	}
	range (ra, 2*PI);
}
