# Unix make file for ssystem
# Be sure to define machine in mconf.h
# and arithmetic precision in prec.h.
#
# If your system supports 80-bit long double arithmetic
# then add the following subroutines: sinl.c, atanl.c, tanl.c,
# asinl.c, polevll.c, floorl.c. Otherwise, leave them out.
#

# Name your compiler.
CC=gcc

# Optimizations:
CFLAGS= -O2

# Subroutine libraries:
LIBS= -lc -lm
#-lc881u -lm881u

OBJS= ssystem.o adams4.o runge.o aconst.o \
oblate.o precess.o epsiln.o nut1t.o zatan2.o \
rdnums.o ieee.o econst.o mtherr.o findcent.o \
reltiv.o jplmp.o \
asinl.o atanl.o sinl.o tanl.o sqrtl.o floorl.o polevll.o

# For real Unix:
#ssystem: $(OBJS)
#	$(CC) $(CFLAGS) -o ssystem $(OBJS) $(LIBS)

# For djgcc on MSDOS:
ssystem: $(OBJS)
	>ssystem.rf $(CFLAGS) $(OBJS) $(LIBS) -o ssystem
	$(CC) @ssystem.rf
	aout2exe ssystem

ssystem.o: ssystem.c ssystem.h ini118d.h mconf.h prec.h

adams4.o: adams4.c int.h prec.h mconf.h

runge.o: runge.c int.h prec.h mconf.h

aconst.o: aconst.c prec.h mconf.h ini118d.h

oblate.o: oblate.c ssystem.h mconf.h prec.h

precess.o: precess.c mconf.h prec.h

epsiln.o: epsiln.c mconf.h prec.h

nut1t.o: nut1t.c mconf.h prec.h

zatan2.o: zatan2.c

rdnums.o: rdnums.c

ieee.o: ieee.c ehead.h

econst.o: econst.c ehead.h

mtherr.o: mtherr.c mconf.h

reltiv.o: reltiv.c

findcent.o: findcent.c

jplmp.o: jplmp.c

asinl.o: asinl.c mconf.h

atanl.o: atanl.c mconf.h

sinl.o: sinl.c mconf.h

tanl.o: tanl.c mconf.h

polevll.o: polevll.c mconf.h

# IBM PC version
sqrtl.o: sqrtl.387
	as -o sqrtl.o sqrtl.387
floorl.o: floorl.387
	as -o floorl.o floorl.387

# 68k version
#sqrtl.o: sqrtl.sun
#	as -o sqrtl.o sqrtl.sun
#floorl.o: floorl.sun
#	as -o floorl.o floorl.sun
#
# The C version of sqrtl does not give a strictly rounded result.
#sqrtl.o: sqrtl.c mconf.h
#
#floorl.o: floorl.c mconf.h
#
