/* Orbital elements and perturbations for the planet Uranus
 * using formulas given by Meeus
 */
#include "planet.h"
#include "kep.h"

static double sineta = 0.0;
static double coseta = 0.0;
static double sinS = 0.0;
static double cosS = 0.0;
static double sin2S = 0.0;
static double cos2S = 0.0;

int pjup();

int ouranus(e,J)
struct orbit *e;
double J;
{
double p, q;

e->epoch = J;
manoms(J);
pjup();
	
f = ( 0.000079*T + 428.37911)*T + 72.64878;
f = mod360(f);
e->M = f;
M7 = f;
e->a = 19.21814;
e->ecc = ( 0.000000077*T - 0.00002658)*T + 0.0463444;
#if OFDATE
e->equinox = J;
e->i = ( 0.0000395*T + 0.0006253)*T + 0.772464;
f = (( -0.00000061*T - 0.0010745)*T + 0.9857650)*T + 98.071581;
e->w = mod360(f);
f = ( 0.0013117*T + 0.4986678)*T + 73.477111;
e->W = mod360(f);
f = (( -0.00000060*T + 0.0003160)*T + 429.863546)*T + 244.197470;
e->L = mod360(f);
#else
e->equinox = J2000;
e->i = ((1.23e-7*T - 2.7e-7)*T - 0.0017660)*T + 0.774950;
f = ((1.3904e-5*T - 0.00049812)*T + 0.0337219)*T + 99.021587;
e->w = mod360(f);
f = ((-1.4536e-5*T + 0.00042674)*T + 0.0545828)*T + 73.923501;
e->W = mod360(f);
f = e->M + e->w + e->W;
e->L = mod360(f);
#endif
G = 83.76922 + 218.4901*T;
G = mod360(G)*DTR;
H = modtp(2.0*G - S);
ze = modtp(S - P);
eta = modtp(S - Q);
th = modtp(G - S);

sin1H = sin(H);
cos1H = cos(H);
sin2H = 2.0*sin1H*cos1H;
cos2H = cos1H*cos1H - sin1H*sin1H;
sinth = sin(th);
costh = cos(th);
sin2th = 2.0*sinth*costh;
cos2th = costh*costh - sinth*sinth;
sineta = sin(eta);
coseta = cos(eta);
sinS = sin(S);
cosS = cos(S);
sin2S = 2.0*sinS*cosS;
cos2S = cosS*cosS - sinS*sinS;

/* perturbations in mean longitude */
p = (0.864319 - 0.001583*nu)*sin1H;
p += (0.082222 - 0.006833*nu)*cos1H;
p +=  0.036017*sin2H
     -0.003019*cos2H
     +0.008122*sinW;
e->L += p;

/* perturbations in the perihelion */
q = 0.120303*sin1H  + 0.006197*sin2H;
q = q +(0.019472 - 0.000947*nu)*cos1H;
e->w += q;
e->M = M7 + p - q/(e->ecc);

/* correction to the orbital eccentricity */        
q = ( -0.0003349 + 0.0000163*nu)*sin1H;
q = q + 0.0020981*cos1H
        +0.0001311*cos2H;
e->ecc += q;

/* perturbation in the semimajor axis */
e->a -= 0.003825*cos1H;
return(0);
}



/* Applied after solving Kepler's equation:
 */
int curanus(e)
struct orbit *e;
{
double q;

/* correction to the true longitude */
q = (0.010122 - 0.000988*nu)*sin(S+eta);

q += ((-0.001910*nu + 0.002031)*nu - 0.038581)*cos(S+eta);
f = (0.000868*nu - 0.001038)*nu + 0.034964;
q += f*cos( 2.0*S + eta );
q += 0.005594*sin(S + 3.0*th);
q = q
    -0.014808*sin(ze)
    -0.005794*sineta
    +0.002347*coseta
    +0.009872*sinth
    +0.008803*sin2th;
q -= 0.004308*sin(3*th);
e->L += q*DTR;

/* correction to the heliocentric latitude */        
f =     0.000458*sineta - 0.000642*coseta - 0.000517*cos(4.0*th);
q = f*sin(S);
f =    -(0.000347*sineta + 0.000853*coseta + 0.000517*sin(4.0*eta));
q += f*cosS;
q += 0.000403*(cos2th*sin2S + sin2th*cos2S);
e->plat = q*DTR;

/* correction to the radius vector */
q = -0.025948
    +0.004985*cos(ze)
    -0.001230*cosS
    +0.003354*coseta;
f =      0.005795*cosS - 0.001165*sinS + 0.001388*cos2S;
q += f*sineta;
f =      0.001351*cosS + 0.005702*sinS + 0.001388*sin2S;
q += f*coseta;
q += 0.000904*cos2th;
q += 0.000894*(costh - cos(3.0*th));
e->r += q;
return(0);
}
