;
; *** Listing 14-4 ***
;
; Copies the standard input to the standard output,
; converting all characters to uppercase. Does so
; one character at a time.
;
	jmp	Skip
; Storage for the character we're processing.
Character	db	?
ErrorMsg	db	'An error occurred', 0dh, 0ah
ERROR_MSG_LENGTH equ	$-ErrorMsg
;
Skip:
	call	ZTimerOn
CopyLoop:
	mov	ah,3fh	;DOS read fn
	sub	bx,bx	;handle 0 is the standard input
	mov	cx,1	;we want to get 1 character
	mov	dx,offset Character ;the character goes here
	int	21h	;get the character
	jc	Error	;check for an error
	and	ax,ax	;did we read any characters?
	jz	Done	;no, we've hit the end of the file
	mov	al,[Character]	;get the character and
	cmp	al,'a'		; convert it to uppercase
	jb	WriteCharacter	; if it's lowercase
	cmp	al,'z'
	ja	WriteCharacter
	and	al,not 20h	;it's uppercase-convert to
	mov	[Character],al	; uppercase and save
WriteCharacter:
	mov	ah,40h	;DOS write fn
	mov	bx,1	;handle 1 is the standard output
	mov	cx,1	;we want to write 1 character
	mov	dx,offset Character ;the character to write
	int	21h	;write the character
	jnc	CopyLoop ;if no error, do the next character
Error:
	mov	ah,40h	;DOS write fn
	mov	bx,2	;handle 2 is standard error
	mov	cx,ERROR_MSG_LENGTH ;# of chars to display
	mov	dx,offset ErrorMsg ;error msg to display
	int	21h	;notify of error
Done:
	call	ZTimerOff
