;
; *** Listing 13-19 ***
;
; Zeros the high-bit of each byte in a 100-byte array,
; using the LOOP instruction.
;
	jmp	Skip
;
ARRAY_LENGTH	equ	100
ByteArray	label	byte
	db	ARRAY_LENGTH dup (80h)
;
; Clears the high bit of each byte in an array of
; length ARRAY_LENGTH.
;
; Input:
;	BX = pointer to the start of the array to clear
;
; Output: none
;
; Registers altered: AL, BX, CX
;
ClearHighBits:
	mov	cx,ARRAY_LENGTH		;# of bytes to clear
	mov	al,not 80h		;pattern to clear
					; high bits with
ClearHighBitsLoop:
	and	[bx],al			;clear the high bit
					; of this byte
	inc	bx			;point to the next
					; byte
	loop	ClearHighBitsLoop	;repeat until we're
					; out of bytes
	ret
;
Skip:
	call	ZTimerOn
	mov	bx,offset ByteArray
				;array in which to clear
				; high bits
	call	ClearHighBits	;clear the high bits of the
				; bytes
	call	ZTimerOff
