;
; *** Listing 11-4 ***
;
; Converts all characters in a string to uppercase,
; using a loop containing non-string instructions
; and using only one pointer.
;
	jmp	Skip
;
SourceString	label	word
	db	'This space intentionally left not blank',0
;
; Converts a string to uppercase.
;
; Input:
;	DS:SI = start of string
;
; Output:
;	none
;
; Registers altered: AL, BX, SI
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
StringToUpper:
	mov	bl,'a'	;set up for fast register-register
	mov	bh,'z'	; comparisons
StringToUpperLoop:
	mov	al,[si]	;get the next character
	cmp	al,bl	;below 'a'?
	jb	IsUpper	;yes, not lowercase
	cmp	al,bh	;above 'z'?
	ja	IsUpper	;yes, not lowercase
	and	al,not 20h ;is lowercase-make uppercase
IsUpper:
	mov	[si],al	;put the uppercase character back
	inc	si	; into the string and point to the
			; following character
	and	al,al	;is this the zero that marks the
			; end of the string?
	jnz	StringToUpperLoop ;no, do the next character
	ret
;
Skip:
	call	ZTimerOn
	mov	si,offset SourceString	;point to the string
					; to convert
	call	StringToUpper		;convert it to
					; uppercase
	call	ZTimerOff
