;
; *** Listing 12-4 ***
;
; Measures the performance of JMP when 1) the prefetch queue
; is full when it comes time for each JMP to run and 2) the
; prefetch queue is allowed to fill faster than the
; instruction bytes after the JMP are requested by the EU,
; so the EU doesn't have to wait for instruction bytes.
;
	call	ZTimerOn
	rept	1000
	push	ax	;let the prefetch queue fill while
			; the first instruction byte after
			; each branch executes
	jmp	short $+2	;we'll do a short jump,
				; since the next instruction
				; is less than 127 bytes
				; away
	endm
	call	ZTimerOff
