
 Title 'Wolfware Assembler Sample', 'Key Reassignment'

;========================================================;
;             Key Reassignment Version 1.10              ;
;                                                        ;
; Reassign any string to any key via DOS 2.0.  The       ;
; ANSI.SYS device driver must be installed (see your DOS ;
; manual).  Once assembled, to reassign a key, type:     ;
;                                                        ;
; KEY <key code> <string>                                ;
;                                                        ;
; The parameters must be separated by a single space.    ;
; Each parameter may consist of any combination of       ;
; strings in double quotes and decimal ASCII codes,      ;
; seperated by semicolons.                               ;
;                                                        ;
; The key to reset (first parameter) should be the       ;
; key's character code (one or two bytes).  The new      ;
; assignment (second parameter) can be any combination   ;
; of strings and ASCII values.                           ;
;                                                        ;
; Examples:                                              ;
;                                                        ;
; KEY "g" "h"                                            ;
;   Assign lower-case h to the lower-case g key.         ;
;                                                        ;
; KEY 0;59 19                                            ;
;   Assigns ^S to the F1 key.  0;59 is the key code for  ;
;   F1.  Makes F1 act like Ctl NumLock when you are,     ;
;   for instance, TYPEing out a file.                    ;
;                                                        ;
; KEY 0;68 "DIR";13                                      ;
;   Assign DIR plus a carriage return to the F10 key.    ;
;                                                        ;
; The extended codes for all applicable keys can be      ;
; found in the BASIC manual right after the ASCII        ;
; character table.  Most application programs bypass     ;
; the DOS keyboard routines (i.e. the reassignments      ;
; won't work for them).  Keyboard reaasignment by this   ;
; method is probably best used for setting up the        ;
; function keys to use from the DOS command level.       ;
;========================================================;

 Proc Far

;----- print message

 Mov Dx, Offset Keymess ;message location
 Call Str_Display       ;string display

;----- number of characters

 Mov Cl, [Input]        ;number of characters
 Sub Ch, Ch
 Cmp Cl, 1              ;check if too few
 Jb Keyerror            ;jump if so

;----- print input and end CR

 Push Cx
 Mov Si, Input + 2      ;start after space
 Push Si

 Mov Dx, Offset Keymess2 ;message location
 Call Str_Display       ;string display

Keyiloop
 Lodsb                  ;load next byte
 Call Display           ;display
 Loop Keyiloop          ;loop CX times

;----- move a line down

 Mov Al, 10             ;byte to display, LF
 Call Display           ;display

 Pop Di
 Pop Bx

;----- scan for space

 Dec Bx                 ;do not count initial space
 Mov Cx, Bx             ;number of characters to search
 Mov Al,' '             ;look for space

 Repne
 Scasb                  ;scan until found or no more

;----- add semicolon

 Jne Keyerror           ;jump if not found
 Mov Byte [Di-1], ';'   ;save semicolon to location

;----- add start code

 Mov Ax, Ctl_Start      ;load starting control
 Mov [Input], Ax        ;save

;----- add end code

 Mov Ax, Ctl_End        ;load end control
 Mov [Input+Bx+2], Ax   ;save

;----- reset key

 Mov Dx, Input          ;control string location
 Call Str_Display       ;string display
 Jmps Exit

;----- error in parameters

Keyerror 
 Mov Dx, Offset Keyemess ;error message location
 Call Str_Display       ;string display

;----- exit

Exit
 Mov Ax, 4c00h          ;function
 Int 21h                ;execute

;===============================================;
;                    Display                    ;
; Display the character in AL to the screen.    ;
;===============================================;

Display Proc Near
 Mov Dl, Al             ;byte to display
 Mov Ah, 2              ;display byte function
 Int 21h                ;execute
 Ret
 Endp                   ;Display

;===============================================;
;                   Str_Display                 ;
; Display the string at DX terminated by a      ;
; dollar sign to the screen.                    ;
;===============================================;

Str_Display Proc Near
 Mov Ah, 9              ;string output function
 Int 21h                ;execute
 Ret
 Endp                   ;Str_Display

;===============================================;
;                  Program Data                 ;
;===============================================;

Input Equ 80h           ;parameter location

Ctl_Start Label Word
 Db 27,'['              ;start of reassignment sequence
Ctl_End Label Word
 Db 'p$'                ;end of reassignment sequence

Keymess Db 10,'Key Reassignment Version 1.10', 13, 10,'$'
Keymess2 Db '--> $'

Keyemess Db 10,'Error in parameters: <key code> <output>', 13, 10
 Db '  Each parameter may consist of any combination of', 13, 10
 Db '  strings in double quotes and decimal ASCII codes,', 13, 10
 Db '  seperated by semicolons.', 13, 10,'$'
 Endp

