
 Title 'Wolfware Assembler Sample', 'Pascal String Functions'

;===============================================;
;  Turbo Pascal String Functions Version 1.00   ;
;                                               ;
; This program contains three machine language  ;
; string routines for Turbo Pascal.  There is a ;
; routine for converting all the characters in  ;
; a string to lower-case, converting all the    ;
; characters to upper-case, and converting the  ;
; first character to upper and the remaining    ;
; characters to lower.                          ;
;                                               ;
; Assuming that the file is assembled to        ;
; CASE.COM, the routines should be declared in  ;
; a Pascal program in the following manner:     ;
;                                               ;
;   TYPE                                        ;
;     STR_TYP = STRING [255]; {any string type} ;
;                                               ;
;   FUNCTION LOWERCASE(S: STR_TYP): STR_TYP;    ;
;     EXTERNAL 'CASE.COM';                      ;
;   FUNCTION UPPERCASE(S: STR_TYP): STR_TYP;    ;
;     EXTERNAL LOWERCASE[2];                    ;
;   FUNCTION CAPITAL(S: STR_TYP): STR_TYP;      ;
;     EXTERNAL LOWERCASE[4];                    ;
;                                               ;
; Having done so, LOWERCASE, UPPERCASE, and     ;
; CAPITAL may be used as normal Pascal          ;
; functions.  Example:                          ;
;                                               ;
;   WRITE (LOWERCASE ('aBcD')); {writes 'abcd'} ;
;   WRITE (UPPERCASE ('aBcD')); {writes 'ABCD'} ;
;   WRITE (CAPITAL ('aBcD')); {writes 'Abcd'}   ;
;                                               ;
; All registers are saved, though the Turbo     ;
; Pascal manual says that only the registers    ;
; BP, CS, DS, and SS need to be saved.          ;
;===============================================;

 Proc Near

;----- table of routines, each jumps to set a function code
;----- that is interpreted later for the individual routines

 Jmps Lowcase           ;lower-case
 Jmps Uppcase           ;upper-case
 Jmps Capital           ;capitalize

;----- make the string lower-case

Lowcase
 Push Ax
 Mov Ax, 0              ;function code
 Jmps Start

;----- make the string upper-case

Uppcase
 Push Ax
 Mov Ax, 1              ;function code
 Jmps Start

;----- capitalize the string

Capital
 Push Ax
 Mov Ax, 2              ;function code

;----- function code is loaded to AX, start execution

Start
 Push Bx
 Push Dx
 Push Di
 Push Si
 Push Bp                ;save all modified regs
 Mov Bp, Sp             ;set pointer into stack

;----- set the location of the byte before the string in DI
;----- and the location of the byte after the string in SI

 Mov Di, 14             ;stack displacement to string parameter
 Mov Bl, [Bp+Di]        ;get string length
 Sub Bh, Bh             ;BX has length
 Mov Si, Di
 Add Si, Bx             ;pointer to end of string

 Mov Bl, 'a' - 'A'      ;translation value

;----- branch for particular function based 
;----- on the function code set earlier

 Or Ax, Ax
 Jz Lowcasedo           ;jump for lower-case
 Dec Ax
 Jz Uppcasedo           ;jump for upper-case
 Dec Ax
 Jz Capitaldo           ;jump for capitalize
 Jmps Finish            ;invalid code (should not happen)

;----- make all characters in the string lower-case

Lowcasedo
 Mov Dx, 'AZ'           ;letter limits
 Call Switchcase        ;switch the letters
 Jmps Finish

;----- make all characters in the string upper-case

Uppcasedo
 Mov Dx, 'az'           ;letter limits
 Neg Bl                 ;fix translation, lower to upper
 Call Switchcase        ;switch the letters
 Jmps Finish

;----- make the first character upper-case and the remaining lower-case

Capitaldo
 Cmp Si, Di             ;check if zero length string
 Je Finish              ;jump if so, done

 Push Di
 Push Si                ;save pointers for first letter
 Mov Dx, 'AZ'           ;letter limits
 Call Switchcase        ;switch the all letters to lower case
 Pop Si
 Pop Di

 Mov Si, Di
 Inc Si                 ;make end pointer one byte past start
 Mov Dx, 'az'           ;letter limits
 Neg Bl                 ;fix translation, lower to upper
 Call Switchcase        ;switch the first letter to upper-case

;----- finished

Finish
 Pop Bp
 Pop Si
 Pop Di
 Pop Dx
 Pop Bx
 Pop Ax                 ;restore all regs
 Ret                    ;return to main Pascal program

;===============================================;
;                   Switchcase                  ;
; Switch the case of the letters from [BP+DI]   ;
; to [BP+SI] in the stack segment. DL should    ;
; have the lower limit of letters to change and ;
; DH the upper limit. BH should have the value  ;
; to add to make the switch.                    ;
;===============================================;

Switchcase Proc Near

;----- check if done

Caseloop
 Cmp Di, Si             ;check if at last byte
 Je Casedone            ;jump if so, finished

;----- load next byte

 Inc Di                 ;advance pointer
 Mov Al, [Bp+Di]        ;get next character
 Cmp Al, Dl             ;check lower limit
 Jb Caseloop
 Cmp Al, Dh             ;check upper limit
 Ja Caseloop

;----- switch byte

 Add Al, Bl             ;switch case
 Mov [Bp+Di], Al        ;save result
 Jmps Caseloop

;----- finished

Casedone Ret            ;return
 Endp                   ;Switchcase

 Endp                   ;main program

