Program TokStr_A;

{ Sorts the typed array of assembly language/MASM tokens,
  builds them into 255-char strings (suitable for incorporation
  as typed constant arrays into a Pascal program),
  outputs to CONV_A.DAT.

  v1.1
    Fixed a bug where first word in output lines was NOT properly
    preceded by a space.
    Added Uc string uppercase function as EXTERNAL.
}

CONST
  TokFilename : STRING[10] = 'CONV_A.DAT';


{$I TOKENS_A.INC}

{$F+}

{v1.1 Link in the Uc string uppercase function}
{$L UC}

FUNCTION Uc(S : STRING) : STRING; EXTERNAL;

{$F-}



PROCEDURE Quick_Sort;

  PROCEDURE Alpha_Sort(l,r : INTEGER);
    VAR
      i,j : INTEGER;
      X,W : STRING[20];
    BEGIN
      i := l;
      j := r;

      X := Uc(CToken[ (l+r) ShR 1 ]);   {v1.1}

      REPEAT
        WHILE Uc(CToken[i]) < X DO Inc(i);  {v1.1}
        WHILE X < Uc(CToken[j]) DO Dec(j);  {v1.1}

        IF i <= j THEN BEGIN
          W := CToken[i];
          CToken[i] := CToken[j];
          CToken[j] := W;
          Inc(i);
          Dec(j);
        END
      UNTIL i > j;

      IF l < j THEN Alpha_Sort(l,j);
      IF i < r THEN Alpha_Sort(i,r)
    END;  {of Alpha_Sort}


  PROCEDURE Len_Sort(l,r : INTEGER);
    VAR
      i,j : INTEGER;
      X,W : STRING[20];
    BEGIN
      i := l;
      j := r;

      X := CToken[ (l+r) ShR 1 ];  {v1.3}

      REPEAT
        WHILE LENGTH(CToken[i]) > LENGTH(X) DO Inc(i);
        WHILE LENGTH(X) > LENGTH(CToken[j]) DO Dec(j);

        IF i <= j THEN BEGIN
          W := CToken[i];
          CToken[i] := CToken[j];
          CToken[j] := W;
          Inc(i);
          Dec(j);
        END
      UNTIL i > j;

      IF l < j THEN Len_Sort(l,j);
      IF i < r THEN Len_Sort(i,r)
    END;  {of Len_Sort}

  BEGIN  {Quick_Sort}
    Len_Sort(0,NRTOKENS);
    Alpha_Sort(0,NRTOKENS);
  END;  {of Quick_Sort}


VAR
  Text_File : TEXT;
  indx : Word;
  Tok       : String;

BEGIN  {main}

  Quick_sort;

  Assign(Text_File,'CONV_A.DAT');
  Rewrite(Text_File);

  Tok := ' ';                   {Initialize Token string}
                                { with leading space v1.1}

  FOR indx := 0 TO NRTOKENS DO BEGIN
    IF LENGTH(Tok) + LENGTH(CToken[indx]) < 253 {string isn't too long}
    THEN Tok := Tok + CToken[indx] + ' '        {so continue to concatenate}
    ELSE BEGIN                                  {string is max length,
                                                 can't add token yet}
      Writeln(Text_File,Tok);            {v1.1 write out the long string}
      Tok := ' ' + CToken[indx] + ' ';   {leading space,   v1.1
                                          pick up the token
                                          that wouldn't fit last time}
    END;
  END;
  IF Tok <> ''                          {if any remaining line}
  THEN Writeln(Text_File,Tok);          {write it out}
  Close(Text_File);
END.
