;===============================================
; PROGRAM DSIZE  Version 1.00 by Dave Whitman
;
; Syntax:  DSIZE [d:]
;
; Examines the disk in the specified drive
; and sets ERRORLEVEL as follows:
;
;  0 = unknown format
;  1 = single sided, 8 sectors (160K)
;  2 = single sided, 9 sectors (180K)
;  3 = double sided, 8 sectors (320K)
;  4 = double sided, 9 sectors (360K)
;
; DSIZE will only run under DOS 2.0
;
; This source file is in CHASM assembler syntax.
;===============================================

;===============
; Equates
;===============
@getver        equ     30H     ;get DOS version number
@getfsp        equ     36H     ;get disk free space
@prnstr        equ     09H     ;print string to console
@exit          equ     4CH     ;exit and set ERRORLEVEL

cr     equ     0DH             ;carriage return
lf     equ     0AH             ;linefeed
beep   equ     07H             ;bell

drv1   equ     [5CH]           ;drive number in 1st fcb

dsize  proc    far

       cmp     al, 0FFH           ;is the drivespec valid?
       jne     chkver             ;yes, continue
       mov     dx, offset(baddrv) ;no, bitch
       mov     ah, @prnstr        ;print message
       int     21H                ;with dos call
       jmps    exit               ;and quit

chkver mov     ah,@getver         ;what DOS are we under?
       int     21H                ;ask DOS.

       cmp     al,00              ;earlier than 2.0?
       jne     chkdsk             ;no, continue
       mov     dx, offset(baddos) ;yes, bitch
       mov     ah, @prnstr        ;print message
       int     21H                ;with dos call
       jmps    exit               ;and quit

chkdsk mov     dl, drv1           ;get drive number
       mov     ah, @getfsp        ;ask for disk info
       int     21H                ;with dos call

       cmp     dx, 0162H          ;360K
       jne     c1
       mov     dx, offset(K360)   ;print message
       mov     ah, @prnstr
       int     21H
       mov     al, 04H            ;and set errorlevel
       jmps    seterr

c1     cmp     dx, 015FH          ;180K
       jne     c2
       mov     dx, offset(K180)   ;print message
       mov     ah, @prnstr
       int     21H
       mov     al, 02H            ;and set errorlevel
       jmps    seterr

c2     cmp     dx, 013BH          ;320K
       jne     c3
       mov     dx, offset(K320)   ;print message
       mov     ah, @prnstr
       int     21H
       mov     al, 03H            ;and set errorlevel
       jmps    seterr

c3     cmp     dx, 0139H          ;160K
       jne     unkwn
       mov     dx, offset(K160)   ;print message
       mov     ah, @prnstr
       int     21H
       mov     al, 01H            ;and set errorlevel
       jmps    seterr

unkwn  mov     dx, offset(K?)     ;print message
       mov     ah, @prnstr
       int     21H
       mov     al, 00H            ;and set errorlevel

seterr mov     ah, @exit          ;set errorlevel
       int     21H                ;and exit


exit   int     20H                ;abnormal exit for errors
       endp
;====================
; Messages
;====================
K360   db cr lf '360K disk' cr lf cr lf '$'
K180   db cr lf '180K disk' cr lf cr lf '$'
K320   db cr lf '320K disk' cr lf cr lf '$'
K160   db cr lf '160K disk' cr lf cr lf '$'
K?     db cr lf beep 'Unrecognized disk format' cr lf cr lf '$'

baddrv db cr lf beep 'Invalid drive specifier!' cr lf '$'
baddos db cr lf beep 'This utility only works under DOS 2.0!' cr lf '$'
