;-------------------------------------------------------------------------------
;
;    video.asm                                        created 5-11-85
;
;    VIDEO ROUTINES
;    (C) COPYRIGHT 1985 BY THOMAS D. WEBB
;
;    MODIFIED FOR MICROSOFT 'C' BY GREGORY ETCHELL            4-1-86
;
;    ALL RIGHTS RESERVED.
;    PERMISSION IS GRANTED FOR UNLIMITED PERSONAL, NON-COMMERCIAL USE ONLY.
;
;-------------------------------------------------------------------------------
TITLE              VIDEO

_TEXT   SEGMENT  BYTE PUBLIC 'CODE'
_TEXT   ENDS

CONST   SEGMENT  WORD PUBLIC 'CONST'
CONST   ENDS

_BSS    SEGMENT  WORD PUBLIC 'BSS'
_BSS    ENDS

_DATA   SEGMENT  WORD PUBLIC 'DATA'
_DATA   ENDS

DGROUP  GROUP    CONST, _BSS, _DATA
        ASSUME    CS: _TEXT, DS: DGROUP, SS: DGROUP, ES:DGROUP


_BSS               SEGMENT

BUFFER_SIZE        EQU       2000D    ;THE VIDEO BUFFER SIZE IN WORDS
NUM_BYTES_IN_ROW   EQU       80       ;NUMBER OF BYTES IN A ROW
MONOCHROME_SEGADR  EQU       0B000H   ;ADDRESS OF MONOCHROME BUFFER
GRAPHICS_SEGADR    EQU       0B800H   ;ADDRESS OF GRAPHICS BUFFER
                   EVEN
_BSS               ENDS

_TEXT              SEGMENT

;-------------------------------------------------------------------------------
; CLEAR            (ROUTINE 1)
;      THIS ROUTINE CLEARS THE SCREEN
; THE C LANGUAGE CALL IS:
;      CLEAR();
; THE ASSEMBLY CALL IS:
;      CALL CLEAR
;-------------------------------------------------------------------------------
                   PUBLIC    _clear
_clear             PROC      NEAR
                   PUSH      BP          ;THE FRAME POINTER
                   MOV       AH,6        ;SCROLL ACTIVE PAGE UP
                   MOV       AL,019H     ;CLEAR 25 LINES
                   MOV       CX,0H       ;UPPER LEFT OF SCROLL
                   MOV       DX,2479H    ;LOWER RIGHT OF SCROLL
                   MOV       BH,7H       ;USE NORMAL ATTRIBUTE ON BLANKED LINE
                   INT       10H         ;VIDEO-IO
                   POP       BP          ;THE FRAME POINTER
                   RET
_clear             ENDP

;-------------------------------------------------------------------------------
; LOCATE           (ROUTINE 2)
;        THIS ROUTINE WILL LOCATE THE CURSOR AT A ROW AND COLUMN ON THE SCREEN
; THE C LANGUAGE CALL IS:
;        LOCATE(ROW,COLUMN);
; THE ASSEMBLY CALL IS:
;        MOV    DX,COL     ;RANGE IS 0 - 79
;        PUSH   DX
;        MOV    DX,ROW     ;RANGE IS 0 - 24
;        PUSH   DX
;        CALL   LOCATE
;-------------------------------------------------------------------------------
                   PUBLIC    _locate
_locate            PROC      NEAR                ;PROC TO LOCATE THE CURSOR
                   PUSH      BP                  ;THE FRAME POINTER
                   MOV       BP,SP               ;POINT TO MOST RECENT STACK ELE
                   MOV       DH,[BP+4]           ;GET THE ROW..
                   MOV       DL,[BP+6]           ;..AND THE COL
                   MOV       BH,0H               ;GRAPHICS PAGE NO.
                   MOV       AH,2H               ;SET_CURSOR_POSITION
                   INT       10H                 ;VIDEO-IO
                   POP       BP                  ;THE FRAME POINTER
                   RET
_locate            ENDP

;-------------------------------------------------------------------------------
; CURSIZE          (ROUTINE 3)
;        THIS ROUTINE SETS THE SIZE OF THE CURSOR
; THE C LANGUAGE CALL IS:
;        CURSIZE(START_LINE,STOP_LINE);
; THE ASSEMBLY CALL IS:
;        MOV    DX,STOP_LINE   ;13 IS NORMAL STOP_LINE FOR MONOCHROME ADAPTOR
;        PUSH   DX
;        MOV    DX,START_LINE  ;12 IS NORMAL START_LINE FOR MONOCHROME ADAPTOR
;        PUSH   DX
;        CALL   CURSIZE
;-------------------------------------------------------------------------------
                   PUBLIC    _cursize
_cursize           PROC      NEAR
                   PUSH      BP                  ;THE FRAME POINTER
                   MOV       BP,SP               ;POINT TO MOST RECENT STACK ELE
                   MOV       CH,[BP+4]           ;CURSOR START LINE
                   MOV       CL,[BP+6]           ;CURSOR STOP LINE
                   MOV       AH,1H               ;SET CURSOR TYPE
                   INT       10H                 ;VIDEO-IO
                   POP       BP                  ;THE FRAME POINTER
                   RET
_cursize           ENDP

;-------------------------------------------------------------------------------
; GET_MODE         (ROUTINE 4)
;     THIS ROUTINE RETURNS THE CRT MODE IN AL, AND THE NUMBER OF CHARACTER
;     COLUMNS ON THE SCREEN IN AH
; THE C LANGUAGE CALL IS: mode_area.value = get_mode();
;     WHERE mode_area is defined as:
; union
;   {
;    int value;
;    struct
;       {
;         char al;           /*al EQ 7 is monochrome*/
;         char ah;           /*number of character columns on the screen*/
;       } al_ah;
;   } mode_area;
;
; THE ASSEMBLY CALL IS:
;      CALL GET_MODE
;-------------------------------------------------------------------------------
                   PUBLIC      _get_mode
_get_mode          PROC        NEAR
                   PUSH        BP           ;THE FRAME POINTER
                   MOV         AX,0         ;CLEAR THE REG
                   MOV         AH,15        ;GET CURRENT VIDEO MODE
                   INT         10H          ;VIDEO-IO
                   POP         BP           ;THE FRAME POINTER
                   RET
_get_mode          ENDP

;-------------------------------------------------------------------------------
; SET_VIDEO_ADDRESS (ROUTINE 5)
;     THIS ROUTINE IS USED IN SEVERAL OF THE OTHER ROUTINES TO TEST THE VIDEO
;     MODE AND TO SET THE CORRECT VIDEO BUFFER ADDRESS (MONOCHROME OR GRAPHICS).
;     THE VIDEO BUFFER ADDRESS IS RETURNED IN AX.
;     THIS IS AN INTERNAL ROUTINE SO THE C LANGUAGE AND ASSEMBLY LANGUAGE
;     CALLS ARE NOT SHOWN IN THIS PROLOGUE.
;-------------------------------------------------------------------------------
SET_VIDEO_ADDRESS  PROC      NEAR
                   CALL      _get_mode           ;GET CRT MODE
                   CMP       AL,7H               ;IS IT A MONOCHROME CARD?
                   JNE       ITS_GRAPHICS
                   MOV       AX,MONOCHROME_SEGADR ;MONOCHROME BUFFER SEG ADDR
                   JMP       RETURN
ITS_GRAPHICS:      MOV       AX,GRAPHICS_SEGADR  ;GRAPHICS BUFFER SEG ADR
RETURN:            RET
SET_VIDEO_ADDRESS  ENDP

;-------------------------------------------------------------------------------
; CALC_VIDEO_OFFSET   (ROUTINE 6)
;     THIS ROUTINE IS USED BY SEVERAL OF THE ROUTINES TO CALCULATE THE OFFSET
;     INTO THE VIDEO BUFFER FOR MOVING CHARACTERS INTO OR FROM THE VIDEO BUFFER.
;     DX MUST BE SET TO THE ROW, AND CX MUST BE SET TO THE COLUMN BEFORE THIS
;     ROUTINE IS EXECUTED. THE OFFSET IS RETURNED IN AX.
;     THIS IS AN INTERNAL ROUTINE SO THE C LANGUAGE AND ASSEMBLY LANGUAGE
;     CALLS ARE NOT SHOWN IN THIS PROLOGUE.
;-------------------------------------------------------------------------------
CALC_VIDEO_OFFSET PROC      NEAR
                  MOV       AX,NUM_BYTES_IN_ROW ;NUMBER OF BYTES IN ROW
                  MUL       DX                  ;RESULT IS IN AX
                  ADD       AX,CX               ;THE COL
                  SHL       AX,1                ;MULTIPLY BY 2 FOR CHAR/ATTR
                  RET
CALC_VIDEO_OFFSET ENDP

;-------------------------------------------------------------------------------
; ISRTSTR         (ROUTINE 7)
;       THIS ROUTINE POSITIONS ITSELF IN THE VIDEO BUFFER, THEN INSERTS A
;       NULL-TERMINATED STRING, ALONG WITH AN ATTRIBUTE, DIRECTLY INTO THE VIDEO
;       BUFFER
; THE C LANGUAGE CALL IS:  ISRTSTR(ROW,COL,STRING,ATTR);
; THE ASSEMBLY CALL IS:
;        MOV    DX,ATTRIBUTE   ;THE ATTRIBUTE BYTE (VALUE OF NORMAL IS 7)
;        PUSH   DX
;        LEA    DX,STRING      ;GET ADDRESS OF THE STRING
;        PUSH   DX
;        MOV    DX,COL         ;RANGE IS 0 - 79
;        PUSH   DX
;        MOV    DX,ROW         ;RANGE IS 0 - 24
;        PUSH   DX
;        CALL   ISRTSTR
;-------------------------------------------------------------------------------
                   PUBLIC    _isrtstr
_isrtstr           PROC      NEAR

                   PUSH      ES

                   PUSH      BP                  ;THE FRAME POINTER
                   MOV       BP,SP               ;POINT TO STACK

                   MOV       DX,[BP+6]           ;GET THE ROW
                   MOV       CX,[BP+8]           ;GET THE COLUMN
                   CALL      CALC_VIDEO_OFFSET   ;CALC OFFSET INTO VIDEO BUFFER
                   MOV       DI,AX               ;OFFSET WAS RETURNED IN AX

                   MOV       SI,[BP+10]          ;GET THE SOURCE STRING OFFSET
                   MOV       DH,[BP+12]          ;GET THE ATTRIBUTE BYTE

                   CALL      SET_VIDEO_ADDRESS   ;SET THE MONOCHROME OR GRAPHICS
                   MOV       ES,AX               ;..VIDEO BUFFER ADDRESS INTO ES

ISRT_LOOP:         MOV       DL,BYTE PTR [SI]    ;THE CHARACTER TO INSERT
                   CMP       DL,0                ;IS IT END OF STRING?
                   JE        ISRTSTR_EXIT        ;EXIT IF END OF STRING
                   MOV       ES:WORD PTR [DI],DX ;MOVE CHAR AND ATTR TO CRT BUF
                   ADD       DI,2H               ;POINT TO NEXT CRT BUF LOC
                   ADD       SI,1H               ;POINT TO NEXT SORC STRING BYTE
                   JMP       ISRT_LOOP           ;GO MOVE ANOTHER WORD

ISRTSTR_EXIT:      POP       BP                  ;THE FRAME POINTER
                   POP       ES

                   RET
_isrtstr           ENDP

;-------------------------------------------------------------------------------
; ISRTCNT          (ROUTINE 8)
;        THIS ROUTINE POSITIONS ITSELF IN THE VIDEO BUFFER, THEN INSERTS
;        N BYTES FROM AN ARRAY DIRECTLY INTO THE VIDEO BUFFER, ALONG WITH AN
;        ATTRIBUTE BYTE
; THE C LANGUAGE CALL IS:
;        ISRTCNT(ROW,COL,STRING,ATTR,NUM_BYTES);
; THE ASSEMBLY CALL IS:
;        MOV    DX,NUM_BYTES      ;THE NUMBER OF BYTES TO BE DISPLAYED
;        PUSH   DX
;        MOV    DX,ATTRIBUTE      ;THE ATTRIBUTE BYTE (NORMAL VALUE IS 7)
;        PUSH   DX
;        LEA    DX,ARRAY          ;GET THE CHARACTER ARRAY ADDRESS
;        PUSH   DX
;        MOV    DL,COL            ;RANGE IS 0 - 79
;        PUSH   DX
;        MOV    DL,ROW            ;RANGE IS 0 - 24
;        PUSH   DX
;        CALL   ISRTCNT
;-------------------------------------------------------------------------------
                   PUBLIC    _isrtcnt
_isrtcnt           PROC      NEAR

                   PUSH      ES

                   PUSH      BP                  ;THE FRAME POINTER
                   MOV       BP,SP               ;POINT TO STACK

                   MOV       DX,[BP+6]           ;GET THE ROW
                   MOV       CX,[BP+8]           ;GET THE COLUMN
                   CALL      CALC_VIDEO_OFFSET   ;CALC OFFSET INTO VIDEO BUFFER
                   MOV       DI,AX               ;OFFSET WAS RETURNED IN AX

                   MOV       SI,[BP+10]          ;GET THE SOURCE STRING OFFSET
                   MOV       DH,[BP+12]          ;GET THE ATTRIBUTE BYTE
                   MOV       CX,[BP+14]          ;GET NUMBER OF BYTES TO INSERT

                   CALL      SET_VIDEO_ADDRESS   ;SET THE MONOCHROME OR GRAPHICS
                   MOV       ES,AX               ;..VIDEO BUFFER ADDRESS INTO ES

ISRTCNT_LOOP:      MOV       DL,BYTE PTR [SI]    ;THE CHARACTER TO INSERT
                   MOV       ES:WORD PTR [DI],DX ;MOVE CHAR AND ATTR TO CRT BUF
                   ADD       DI,2H               ;POINT TO NEXT CRT BUF LOC
                   ADD       SI,1H               ;POINT TO NEXT SORC STRING BYTE
                   LOOP      ISRTCNT_LOOP        ;GO MOVE ANOTHER WORD

ISRTCNT_EXIT:      POP       BP                  ;THE FRAME POINTER
                   POP       ES

                   RET
_isrtcnt           ENDP

;-------------------------------------------------------------------------------
; PUTCHAT          (ROUTINE 9)
;     WRITES A CHARACTER AND ATTRIBUTE TO THE SCREEN. THE CURSOR DOES NOT MOVE.
; THE C LANGUAGE CALL IS:  PUTCHAT(CHARACTER,ATTR);
; THE ASSEMBLY LANGUAGE CALL IS:
;         MOV    DX,0
;         MOV    DL,CHARACTER      ;THE CHARACTER TO BE DISPLAYED
;         PUSH   DX
;         MOV    DL,ATTRIBUTE      ;THE ATTRIBUTE TO BE DISPLAYED
;         PUSH   DX
;         CALL   PUTCHAT
;-------------------------------------------------------------------------------
                   PUBLIC    _putchat
_putchat           PROC      NEAR
                   PUSH      BP                  ;THE FRAME POINTER
                   MOV       BP,SP               ;POINT TO STACK
                   MOV       AL,[BP+4]           ;THE CHARACTER
                   MOV       BL,[BP+6]           ;THE ATTRIBUTE
                   MOV       BH,0H               ;DISPLAY PAGE #
                   MOV       CX,1H               ;NUMBER OF CHARACTERS TO WRITE
                   MOV       AH,9H               ;WRITE CHAR/ATTR AT CURPOS
                   INT       10H                 ;VIDEO_IO
                   POP       BP                  ;THE FRAME POINTER
                   RET
_putchat           ENDP

;-------------------------------------------------------------------------------
; CRTBUF           (ROUTINE 10)
;       ACCEPTS TWO PARAMETERS:
;          1.   SAVE = 0 AND REPLACE = 1.
;          2.   THE ADDRESS TO SAVE THE VIDEO BUFFER INTO OR REPLACE THE VIDEO
;               BUFFER FROM
;       CALLS CRTSAVE TO SAVE THE CRT BUFFER,
;       CALLS CRTREPL TO REPLACE THE CRT BUFFER.
; THE C LANGUAGE CALL IS: CRTBUF(SAVE,SAVE_AREA); OR CRTBUF(REPLACE,SAVE_AREA);
; THE ASSEMBLY CALL IS:
;            LEA  DX,SAVE_AREA ;GET ADDRESS OF SAVE_AREA
;            PUSH DX
;            MOV  DX,0         ;SAVE (MOV DX,1 TO REPLACE)
;            PUSH DX
;            CALL CRTBUF
;-------------------------------------------------------------------------------
                   PUBLIC    _crtbuf
_crtbuf            PROC      NEAR
                   PUSH      BP                  ;THE FRAME POINTER
                   MOV       BP,SP               ;POINT TO STACK

                   MOV       DX,[BP+4]           ;SAVE/RESTORE INDICATOR
                   CMP       DX,0                ;SAVE THE CRT BUFFER?
                   JNE       RESTORE_IT
SAVE_IT:           CALL      CRTSAVE
                   JMP       CRTBUF_EXIT
RESTORE_IT:        CALL      CRTREPL

CRTBUF_EXIT:       POP       BP                  ;THE FRAME POINTER

                   RET
_crtbuf            ENDP

;-------------------------------------------------------------------------------
; CRTSAVE          (ROUTINE 11)
;      THIS ROUTINE IS CALLED BY CRTBUF TO SAVE THE CRT BUFFER INTO A SAVE AREA.
;
;-------------------------------------------------------------------------------
CRTSAVE            PROC      NEAR

                   PUSH      ES                  ;ES AND DS ARE MODIFIED..
                   PUSH      DS                  ;..SO SAVE THEM

                   PUSH      BP                  ;SAVE THE FRAME POINTER
                   MOV       BP,SP               ;ADDRESS THE STACK

                   MOV       CX,DS               ;DATA SEG IS THE DESTINATION
                   MOV       ES,CX               ;ES HAS DESTINATION SEG ADDR
                   MOV       DI,[BP+14]          ;DESTINATION OFFSET

                   MOV       CX,BUFFER_SIZE      ;THE BUFFER SIZE IN WORDS

                   CALL      SET_VIDEO_ADDRESS   ;SET THE MONOCHROME OR GRAPHICS
                   MOV       DS,AX               ;..VIDEO BUFFER ADDRESS INTO DS

                   MOV       SI,0                ;SOURCE OFFSET

                   CLD                           ;SET DF=0 TO MOVE FORWARD
REP                MOVSW                         ;MOVE 2000 WORDS
                                                 ;THE FRAME POINTER
                   POP       BP                  ;MUST RESTORE DS..
                   POP       DS                  ;..AND ES
                   POP       ES
                   RET
CRTSAVE            ENDP

;-------------------------------------------------------------------------------
; CRTREPL          (ROUTINE 12)
;   THIS ROUTINE IS CALLED BY CRTBUF TO REPLACE THE CRT BUFFER FROM A SAVE AREA.
;
;-------------------------------------------------------------------------------
CRTREPL            PROC      NEAR

                   PUSH      ES                  ;ES IS MODIFIED, SO SAVE IT

                   PUSH      BP                  ;SAVE THE FRAME POINTER
                   MOV       BP,SP               ;ADDRESS THE STACK

                   MOV       SI,[BP+12]          ;SOURCE OFFSET

                   CALL      SET_VIDEO_ADDRESS   ;SET THE MONOCHROME OR GRAPHICS
                   MOV       ES,AX               ;..VIDEO BUFFER ADDRESS INTO ES

                   MOV       DI,0                ;DESTINATION OFFSET

                                                 ;DS HAS SOURCE SEG ADDR
                   MOV       CX,BUFFER_SIZE      ;THE BUFFER SIZE IN WORDS

                   CLD                           ;SET DF=0 TO MOVE FORWARD
REP                MOVSW                         ;MOVE 2000 WORDS

                   POP       BP                  ;THE FRAME POINTER
                   POP       ES                  ;MUST RESTORE ES
                   RET
CRTREPL            ENDP

;-------------------------------------------------------------------------------
; SCANCRT          (ROUTINE 13)
;   POSITIONS ITSELF IN THE CRT BUFFER, THEN MOVES N BYTES, NOT NULL-TERMINATED,
;   TO THE ADDRESS OF AN ARRAY PROVIDED BY THE CALLER.
;
; THE C LANGUAGE CALL IS:  SCANCRT(ROW,COL,STRING,NUM_BYTES);
; THE ASSEMBLY CALL IS:
;        MOV    DX,NUM_BYTES        ;THE NUMBER OF BYTES TO MOVE
;        PUSH   DX
;        LEA    DX,ARRAY            ;GET CHARACTER ARRAY ADDRESS
;        PUSH   DX
;        MOV    DX,COL              ;RANGE IS 0 - 79
;        PUSH   DX
;        MOV    DX,ROW              ;RANGE IS 0 - 24
;        PUSH   DX
;        CALL   SCANCRT
;-------------------------------------------------------------------------------
                   PUBLIC    _scancrt
_scancrt           PROC      NEAR

                   PUSH      ES                  ;ES IS MODIFIED, SO SAVE IT

                   PUSH      BP                  ;THE FRAME POINTER
                   MOV       BP,SP               ;POINT TO STACK

                   MOV       DX,[BP+6]           ;GET THE ROW
                   MOV       CX,[BP+8]           ;GET THE COLUMN
                   CALL      CALC_VIDEO_OFFSET   ;CALC OFFSET INTO VIDEO BUFFER
                   MOV       DI,AX               ;OFFSET WAS RETURNED IN AX

                   MOV       SI,[BP+10]          ;GET THE SOURCE STRING OFFSET
                   MOV       CX,[BP+12]          ;NUMBER OF BYTES TO MOVE

                   CALL      SET_VIDEO_ADDRESS   ;SET THE MONOCHROME OR GRAPHICS
                   MOV       ES,AX               ;..VIDEO BUFFER ADDRESS INTO ES

SCAN_LOOP:         MOV       DL,ES:BYTE PTR [DI] ;GET CHAR FROM CRT BUFFER
                   MOV       BYTE PTR[SI],DL     ;MOVE CHAR TO STRING IN CALLER
                   ADD       DI,2H               ;POINT TO NEXT CRT_BUF LOC
                   ADD       SI,1H               ;POINT TO NEXT DEST STRING BYTE
                   LOOP      SCAN_LOOP

SCANCRT_EXIT:      POP       BP                  ;THE FRAME POINTER
                   POP       ES                  ;MUST RESTORE ES

                   RET
_scancrt           ENDP


_TEXT              ENDS
                   END
