/******************************************************************************
 * File: lview.c
 * Desc: view contents of .lzh files
 * Date: 03/28/89
 *****************************************************************************/

/*

	Daniel Durbin___________________________________________________
	SysOp: Cygnus X-1 BBS		| CIS: 73447,1744
	(805) 541-8505 (data)		| GEnie: D.DURBIN
	EL major at PolySlo		| ddurbin@polyslo.CalPoly.EDU 

	This code is a result of looking at the header information
	for an example .lzh file shown in the lzh.h file included.

	This code is released to the public and is freely copyable
	and usable for any use

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dir.h>

#include "lzh.h"

char lview(FILE *stream);
void nice(char *s);

void main(int argc, char *argv[])
{
	FILE *arc;
	struct ffblk ffblk;
	char string[81];
	char ok;

	if (argc < 2) {
		puts("Syntax: lview filename[.lzh]");
		return;
	}
	strcpy(string, argv[1]);
	if (strchr(string, '.') == NULL)
		strcat(string, ".lzh");
	if (strchr(string, '*') || strchr(string, '?')) {
		ok = findfirst(string, &ffblk, 0) == 0;
		while (ok) {
			printf("Found %s\n", ffblk.ff_name);
	        	arc = fopen(ffblk.ff_name, "rb");
			if (arc == NULL) {
				printf("Cannot open %s\n", ffblk.ff_name);
				return;
			}
			lview(arc);
			ok = findnext(&ffblk) == 0;
		}
	}
	else {
        	arc = fopen(string, "rb");
		if (arc == NULL) {
			printf("Cannot open %s\n", string);
			return;
		}
		lview(arc);
		fclose(arc);
	}
}

char lview(FILE *arc)
{
	struct lzhlfh header;		/* Local file header */
	char *fname;			/* filename */
	int crc;			/* crc-16 */

	char string[96];		/* output */
	char method[7];			/* compression method */
	char s1[9];			/* date */
	char s2[9];			/* time */
	char ok = 1;			/* while */
	char i;				/* loop variable */
	int num;			/* number of files in archive */
	char pct;			/* percent compressed */
	long t_fsize = 0;		/* unarched file size */
	long t_csize = 0;		/* arched file size */

	fseek(arc, 0L, SEEK_SET);
	num = 0;
        puts("  #  FileName      Stowage    UnLZH Sz  LZH Size  Pct  Date      Time      CRC");
	puts("                ");
	while (ok) {
		ok = fread(&header, sizeof(header), 1, arc) == 1;
		if (!ok || !header.namelen) break;
                fname = malloc(header.namelen);
		if (fname == NULL) {
			puts("memory allocation error");
			return(num);
		}
		fread(fname, header.namelen, 1, arc);
		*(fname+header.namelen) = 0;
		fread(&crc, sizeof(short), 1, arc);
		for (i = 0; i < 5; i++)
			*(method + i) = *(header.method + i);
		num++;	/* increment total number of files */
		sprintf(s1, "%02.2d/%02d/%02d",
			(header.fdate & 0x01e0) / 32,
			(header.fdate & 0x001f),
			(header.fdate & 0xfe00) / 512 + 80
		);
		sprintf(s2, "%02d:%02d:%02d",
			(header.ftime & 0xfc00) / 2048,
			(header.ftime & 0x07e0) / 32,
			(header.ftime & 0x001f)
		);
		t_fsize += header.fsize;
		t_csize += header.csize;
		if (header.fsize == 0L)
			header.fsize = 1L;
		pct = 100 - (char)((header.csize * 100) / header.fsize);
		nice(fname);
		sprintf(string, "%3d  %-12s  %9.5s  %8ld  %8ld  %2d%c  %s  %s  %04X",
			num,
			fname,
			method,
			header.fsize,
			header.csize,
			pct,
			'%',
			s1,
			s2,
			crc
		);
		puts(string);
		if (fname != NULL) free(fname);
		fseek(arc, header.csize, SEEK_CUR);
	}
	puts("                   ");
	sprintf(string, "%3d  File(s)       Arc Total  %8ld  %8ld  %2d%c",
		num,
		t_fsize,
		t_csize,
		100 - (char)((t_csize * 100) / t_fsize),
		'%'
	);
	puts(string);
	return(num);
}

void nice(char *s)
{
	char *p;

	strlwr(s);
	*s -= 32;
	p = strchr(s, ' ');
	if (p != NULL) *(p+1) -= 32;
}
