/*1854339PC360:UTIL:APDEFN.IPSA.H.12.18525. */
/* ======================================= */
/*                                         */
/*  sharp apl pc interrupt definitions.    */
/*                                         */
/* ======================================= */
/*                                         */
#define INTSFS 96 /* file system interrupt               */
#define INTSVP 97 /* shared variable processor interrupt */
#define INTPOST 98 /* task post interrupt                */
#define INTDISP 99 /* entry to task dispatcher from low priority
                      task only */
#define INTSHUT 100 /* task shutdown */
/* ======================================= */
/*                                         */
/*  sharp apl svp/pc percmd definition     */
/*                                         */
/* ======================================= */
/*                                         */
struct percmd
{
 unsigned char  pccmd ; /* svp command*/
 unsigned char  pcflags;/* command flags: reserved: must be 0 */
 unsigned long  pcp1,pcp2,pcp3; /* major parameters and results */
/*
   svp percmd contents:

cmd       pcp1     pcp2    pcp3
         in   out  in  out   in  out


share    ascv  -    -   doc   -   -
retract  scvpo -    -   doc   -  chron
useinit  scvpo -    -   len   -   -

usedata  scvpo -   aval  -   len  -
copydata scvpo -   aval  -   len  -
setinit  scvpo -    -   len   -   -

setdata  scvpo -   aval  -   len  -
seize    scvpo -    -   len   -   -

release  scvpo -    -    -    -   -
svc      scvpo -   acv  ccv   -   -

svs      scvpo -    -   ccv   -   -
scan     ascv  -    -    -    -   -
signon   apcv  -    -   ppi   -   -
signoff  apcv  -    -    -    -   -
retrall  apcv  -    -    -    -   -
setclone apcv  -   cid   -    -   -

contents of fields:

scvpo:   peroffer index, from scvpo as the result of share or scan.
apcv:    mainstore address of processor control vector.
ascv:    mainstore address of share control vector.
asv:     access state vector.
acv:     access control vector.
ppi:     perproc index assigned to this processor.
aval:    mainstore address of value.
ccv:     combined access state vector, access control vector.
cid:     new cloneid.
len:     length of value in bytes. If len is a result, -1 indicates
         no value available.
chron:   chronology of new offer.
doc:     previous degree of coupling.
*/
} ;
/*                                                                   */
/*                                                                */
/*       SHARED VARIABLE OPERATION CODES.                         */
/*                                                                */
/*                                                                */
                     /* retract all variables. used only by APL   */
#define SVPSVRA 2
                      /* SIGN ON.                           */
#define SVPON   3
                      /* SIGN OFF.                          */
#define SVPOFF  4
/*                                                          */
                    /* SCAN FOR OFFERS.                     */
#define SVPSVQ  5
                    /* SHARE.                               */
#define SVPSVO  6
                    /* RETRACT.                             */
#define SVPSVR  7
/*                                                          */
                    /* SET ACCESS CONTROL.                  */
#define SVPSVC  8
                    /* RETURN ACCESS STATE (AND CONTROL VECTOR) */
#define SVPSVS  9
/*                                                          */
                    /* USE INITIAL SELECTION.               */
#define SVPUIS 10
                    /* SET INITIAL SELECTION.               */
#define SVPSIS 11
                    /* COPY INITIAL SELECTION. (SEIZE).     */
#define SVPCIS 12
/*                                                          */
                    /* USE DATA TRANSFER.                   */
#define SVPUDT 13
                    /* SET DATA TRANSFER.                   */
#define SVPSDT 14
                    /* COPY DATA TRANSFER.                  */
#define SVPCDT 15
                    /* NO DATA TRANSFER (RELEASE).          */
#define SVPNDT 16
/*                                                          */

                    /* SET NEW CLONEID. Used only by APL.   */
#define SVPCID 17

#define SVPMAX 17   /* maximum legal svp command */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*                                                                   */
/*       SHARED VARIABLE PROCESSOR RETURN CODES...                   */
/*                                                                   */
/*       - RETURNED TO THE CALLING PROGRAM BY THE SSVP.              */
/*                                                                   */
                 /* VARIABLE IS AN OFFER (NO OTHER SHARER).   */
#define SVZNOS 1
/*                                                                   */
/*       NOTE ...        SVZNOS OCCURS IN COMBINATION WITH OTHER     */
/*                       RETURN CODES, IE, IF RELEVANT IT WILL BE    */
/*                       ORED WITH THE ACTUAL COMPLETION CODE.       */
/*                                                                   */
                  /* REJECTION BECAUSE OF ACCESS CONTROL.  */
#define SVZLOCK 0
                  /*TEMPORARY SETDATA REJECTION BECAUSE OF */
/*                       INSUFFICIENT S.V. STORAGE. CONTROL RETAINED.*/
#define SVZSVSF 2
                  /*USE, SET, OR COPY DATA TRANSFER INCORRECT*/
#define SVZILI 4
                  /*SCAN, NO OFFERS FOUND.                   */
#define SVZNOF 6
                  /*NORMAL END - REQUEST COMPLETED SUCCESSFULLY.*/
#define SVZNE 8
                  /*PROCESSOR ID IN USE.                        */
#define SVZNIU 10
                  /*PROCESSOR NOT SIGNED ON TO SVP.             */
#define SVZNSO 12
                  /*PROCESSOR ALREADY SIGNED ON WITH SAME ID.   */
#define SVZASO 14
                  /*INVALID REQUEST SEQUENCE.                   */
#define SVZIVS 16
                  /*(USEINIT) NO VALUE AVAILABLE IN S.V.S.      */
#define SVZNV 18
                  /*STORAGE PROTECTION EXCEPTION.               */
#define SVZSPE 20
                  /*SVP NOT AVAILABLE (NOT RUNNING).              */
#define SVZNA 22
                  /*PERSHARE TABLE FULL.                          */
#define SVZPSF 24
                  /*PROCESSOR TABLE FULL.                         */
#define SVZPPF 26
                  /*VALUE TOO LARGE (WILL NEVER FIT).             */
#define SVZVTL 28
                  /*ARGUMENT ERROR DETECTED IN VALIDITY CHECK.    */
#define SVZARG 30
                       /*MUST BE MAX/SVZCODES.                    */
#define SVZMAX SVZARG

/* SVP degrees of coupling */
#define COUPLE0 0
#define COUPLE1 1
#define COUPLE2 2





/* ============================================= */
/*                                               */
/*  sharp apl svp/pc processor control vector    */
/*                                               */
/* ============================================= */
/*                                               */
struct perpcv
{
/* perscv and perpcv assume that id,nid come first in same format */
 long  pcvid ;             /* processor id           */
 long  pcvnid;             /* cloneid                */
 unsigned int pcvpost;     /* reasons for post       */
/*                                                   */
/* extension of pcv     for task dispatcher fields.  */
/*                                                   */
 unsigned long  pcvtcs   ; /* cs:ip value for task dispatch*/
 unsigned long  pcvtss   ; /* ss:sp value for task dispatch*/
 unsigned long  pcvtds   ; /* ds:dx value for task dispatch*/
 unsigned int   pcvtbp   ; /*    bp value for task dispatch*/
} ;

/*  pcvpost values. */
                         /* end of storage wait */
#define perpwfs   1
                         /* share completed     */
#define perpshar  2
                         /* retraction          */
#define perpretr  4
                         /* use data            */
#define perpuse   8
                         /* set data            */
#define perpset  16
                         /* release             */
#define perprels 32
                         /* set acv             */
#define perpsacv 64
                         /* offer received      */
#define perpoffr 128
/*
   The next 4 bits are reserved for use by auxiliary processors.
   The svp will not set these bits, not make any use of them.
   They are intended for simple communication among APs.
*/
                         /* AP post bit 0.      */
#define perpap0  256
                         /* AP post bit 1.      */
#define perpap1  512
                         /* AP post bit 2.      */
#define perpap2  1024
                         /* AP post bit 3.      */
#define perpap3  2048
                         /* AP shutdown bit.    */
#define perpshut 4096
/* next 3 bits are reserved for future expansion*/





/* ======================================= */
/*                                         */
/*  sharp apl svp/pc perscv definition     */
/*                                         */
/* ======================================= */
/*                                         */
#define MAXPSN 11
struct perscv
{
 long  scvcount; /* byte count of value, if any        */
 unsigned int scvsos; /* must be 0 or 1 */
   /* if 1, a scan or share issued by
      this processor will examine only offers
      resulting from share, and will ignore offers
      resulting from retract.
      Also, this procesor will not
      recouple to an offer resulting from this
      processor retracting. The other processor
      is not affected, and may retract and reshare,
      unless it too sets scvsos. */

/* ppidsrch assumes that id,pid are identical in scv,pcv */
 long  scvid  ;  /* processor id */
 long  scvnid ;  /* cloneid*/
 unsigned long  scvalue;  /* mainstore address of value, if any */
 unsigned long  scvchron; /* chronology */
 unsigned long  scvpo   ; /* peroffer associated with this perscv.*/
 long  scvother; /* processor id of partner*/
 long  scvnothr; /* clone id of partner */
 unsigned char scvnamel; /*length of name, or longest acceptable name*/
                  /* maximum identifier length */
 unsigned char  scvname[MAXPSN]; /* name of shared variable. if first
                    character is binary 0, any name will match.*/
} ;
/*APL CHARACTER EQUATES */
#define QALPHA   42
#define QOMEGA   46
#define QA       86
#define QB       87
#define QC       88
#define QD       89
#define QE       90
#define QF       91
#define QG       92
#define QH       93
#define QI       94
#define QJ       95
#define QK       96
#define QL       97
#define QM       98
#define QN       99
#define QO       100
#define QP       101
#define QQ       102
#define QR       103
#define QS       104
#define QT       105
#define QU       106
#define QV       107
#define QW       108
#define QX       109
#define QY       110
#define QZ       111
#define QDELTA   112

#define QAU      113
#define QBU      114
#define QCU      115
#define QDU      116
#define QEU      117
#define QFU      118
#define QGU      119
#define QHU      120
#define QIU      121
#define QJU      122
#define QKU      123
#define QLU      124
#define QMU      125
#define QNU      126
#define QOU      127
#define QPU      128
#define QQU      129
#define QRU      130
#define QSU      131
#define QTU      132
#define QUU      133
#define QVU      134
#define QWU      135
#define QXU      136
#define QYU      137
#define QZU      138
#define QDELTAU  139

#define Q0       140
#define Q1       141
#define Q2       142
#define Q3       143
#define Q4       144
#define Q5       145
#define Q6       146
#define Q7       147
#define Q8       148
#define Q9       149
#define QBLANK   152
#define QSEMIC    18
/*=================================*/
/*                                 */
/*     asdata                      */
/*     apl shared variable array   */
/*                                 */
/*=================================*/

/*========================================*/
/*                                        */
/*     apl array object definition.       */
/*     all fields are 370 format.         */
/*     see IBM System/370 Principles of   */
/*     Operation (GA22-7000) for details. */
/*                                        */
/*========================================*/


/* Note that the byte ordering of the System/370 and the 8088 are   */
/* reversed from one another. The 8088 stores the low-order byte in */
/* the lowest-numbered storage location, and the 370 stores the     */
/* low-order byte in the the highest-numbered storage location.     */
/* This means that a function must be used to reverse the order of  */
/* bytes as they are stored or fetched into the asdata array.       */

struct asdata
 {
 char astype;           /* type of apl object */

 char mt2;              /* unused. must be 0  */
 short asrank;          /* 4 * rank of object,*/
                        /* byte count of shape vector which follows*/

/* for example, a scalar has asrank of 0, a vector has asrank of   */
/* 4, and a rank-3 array has asrank of 12.                         */
 long asshape[];        /* shape vector, data follows */
 }; /* end asdata */

/* format of asdata entries:                                         */

/* values of astype and their meanings:      */

#define typb 1          /* array is boolean   */
#define typi 2          /* array is integer   */
#define typf 3          /* array is real      */
#define typc 4          /* array is character */
#define typp 5          /* array is package   */
#define typa 6          /* array is enclosed  */
#define typz 7          /* arrays is complex  */

/* All data elements are stored in ravel order. Each data type has   */
/* a different number of bits per element:                           */

/* Data Type   Number of bits per element

   Boolean     1
   Integer     32
   Floating    64
   Character   8
   Package     indeterminate
   Enclosed    indeterminate
   Complex     128

All arrays are stored left-justified in the 370 word, and all byte
counts must be a multiple of 4. The left-justification is only
evident in Boolean and character arrays.

Boolean arrays are stored as 1 bit per element:
Assume B is the boolean matrix: 3 4 reshape 1 0 1 0 1 0 1 1 1 0 1 0.
B looks like:
         01 00 00 08     type and rank
         00 00 00 03     shape vector
         00 00 00 04
         AB A0 00 00     value.

Integer arrays are stored as 4 bytes per element:
Assume B is the integer scalar: 272.
B looks like:
         02 00 00 00    type and rank
         00 00 01 10    value (note no shape vector).

The array iota 0 looks like:
         02 00 00 04    type and rank.
         00 00 00 00    shape.
                        note no value.

Floating arrays are stored as 8 bytes per element:
Assume B is the floating point vector 3 .5.
B is stored in 370 Double Precision floating point format,
and looks like:

         03 00 00 04    type and rank
         00 00 00 02    shape vector
         41 30 00 00    value
         00 00 00 00
         40 80 00 00
         00 00 00 00

Note that floating and complex values must be stored in normalized
form, and that zeros must be true zeros(8 bytes of 0), or APL will
produce incorrect results.
Also, note that S/370 floating point is not compatible with
IEEE floating point. They aren't even close.

Package and Enclosed data types are not described in this release of
SHARP APL/PC.

Complex arrays are stored as 16 bytes per element, as pairs
of S/370 floating point numbers, representing the real and imaginary
parts, respectively.
Assume B is the complex scalar (-1)*.5.
B looks like:

         07 00 00 00    type and rank
         00 00 00 00    value of 0J1.
         00 00 00 00
         41 10 00 00
         00 00 00 00

Note that floating and complex values must be stored in normalized
form, and that zeros must be true zeros(8 bytes of 0), or APL will
produce incorrect results.
Also, note that S/370 floating point is not compatible with
IEEE floating point. They aren't even close.

*/
