-- ********************************************
-- *                                          *
-- *  Buoy_Sensor_Interface                   *  BODY
-- *                                          *
-- ********************************************
package body Buoy_Sensor_Interface is

  My_Position : constant array (BUOY_ID) of LOCATION :=
      ((Latitude  => (NORTH, 47.0),
        Longitude => (EAST,  25.0)),
       (Latitude  => (NORTH, 35.2),
        Longitude => (EAST,  10.1)),
       (Latitude  => (NORTH, 10.5),
        Longitude => (EAST,  80.0)),
       (Latitude  => (SOUTH, 30.0),
        Longitude => (EAST,   5.0)),
       (Latitude  => (SOUTH, 25.2),
        Longitude => (WEST,  10.0)),
       (Latitude  => (SOUTH, 70.0),
        Longitude => (EAST,  10.0)),
       (Latitude  => (SOUTH, 70.0),
        Longitude => (EAST,  20.0)),
       (Latitude  => (SOUTH, 70.0),
        Longitude => (EAST,  30.0)),
       (Latitude  => (SOUTH, 70.0),
        Longitude => (EAST,  40.0)),
       (Latitude  => (SOUTH, 70.0),
        Longitude => (EAST,  50.0)),
       (Latitude  => (SOUTH, 60.0),
        Longitude => (EAST,  60.0)),
       (Latitude  => (NORTH, 55.2),
        Longitude => (WEST,  70.5)),
       (Latitude  => (NORTH, 67.2),
        Longitude => (EAST,  22.2)),
       (Latitude  => (NORTH, 34.0),
        Longitude => (EAST,  89.0)),
       (Latitude  => (SOUTH, 76.2),
        Longitude => (EAST,  55.0)),
       (Latitude  => (NORTH, 12.0),
        Longitude => (EAST,  12.0)),
       (Latitude  => (SOUTH, 12.0),
        Longitude => (EAST,  12.0)),
       (Latitude  => (NORTH, 12.0),
        Longitude => (WEST,  12.0)),
       (Latitude  => (SOUTH, 12.0),
        Longitude => (WEST,  12.0)),
       (Latitude  => (NORTH,  1.0),
        Longitude => (EAST,  80.0)));

  type BUOY_INDEX is array (BUOY_ID) of NATURAL;
  Air_Temp_Index   : BUOY_INDEX :=
      (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 5);
  Water_Temp_Index : BUOY_INDEX :=
      (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 5);
  Wind_Speed_Index : BUOY_INDEX :=
      (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 5);
  Red_Index : BUOY_INDEX :=
      (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 5);
  Yellow_Index : BUOY_INDEX :=
      (0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0, 5);

  type TEMP_ARRAY is array (NATURAL range <>) of TEMPERATURE;
  type SPEED_ARRAY is array (NATURAL range <>) of SPEED;
  type FLAG_ARRAY is array (NATURAL range <>) of OFF_ON;

  Air_Temp : constant TEMP_ARRAY :=
    (50.0, 55.0, 60.0, 65.0, 70.0, 75.0, 80.0, 85.0, 90.0, 95.0,
     100.0, 110.0, 120.0, 130.0, 140.0, 150.0, 145.0, 140.0, 120.0,
     100.0, 80.0, 70.0, 60.0);

  Water_Temp : constant TEMP_ARRAY :=
    (32.0, 32.0, 34.0, 37.0, 38.0, 40.0, 42.0, 50.0, 60.0, 65.0,
     70.0, 75.0, 80.0, 82.0, 83.0, 84.0, 80.0, 78.0, 82.0, 70.0,
     60.0, 50.0, 40.0, 35.0, 30.0, 25.0, 20.0, 15.0, 10.0, 17.0,
     20.0, 22.0, 27.0, 30.0, 31.0);

  Wind : constant SPEED_ARRAY :=
    (5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 25.0, 22.0, 20.0, 17.0, 14.0,
     12.0, 9.0, 7.0, 4.0, 2.0, 1.0, 0.0, 0.0, 1.0, 3.0);

  Red_Light_Status : constant FLAG_ARRAY :=
    (OFF, OFF, OFF, ON, ON, OFF, OFF, OFF, ON, OFF, OFF, OFF, OFF,
     ON, ON, OFF, OFF, OFF, OFF, OFF, OFF, OFF, ON, OFF, OFF, OFF);

  Yellow_Light_Status : constant FLAG_ARRAY :=
    (OFF, ON, OFF, OFF, ON, OFF, OFF, OFF, OFF, ON, OFF, OFF, OFF,
     ON, OFF, OFF, OFF, ON, OFF, OFF, ON, OFF);

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Air_Temperature    .  BODY
  -- .                                           .
  -- .............................................
  function Air_Temperature (ID : in BUOY_ID) return TEMPERATURE is
  begin
    return Air_Temp(Air_Temp_Index(ID));
  end Air_Temperature;

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Water_Temperature  .  BODY
  -- .                                           .
  -- .............................................
  function Water_Temperature (ID : in BUOY_ID) return TEMPERATURE is
  begin
    return Water_Temp(Water_Temp_Index(ID));
  end Water_Temperature;

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Wind_Speed         .  BODY
  -- .                                           .
  -- .............................................
  function Wind_Speed (ID : in BUOY_ID) return SPEED is
  begin
    return Wind(Wind_Speed_Index(ID));
  end Wind_Speed;

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Global_Position    .  BODY
  -- .                                           .
  -- .............................................
  function Global_Position (ID : in BUOY_ID) return LOCATION is
  begin
    return My_Position(ID);
  end Global_Position;

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Red_Light          .  BODY
  -- .                                           .
  -- .............................................
  function Red_Light (ID : in BUOY_ID) return OFF_ON is
  begin
    return Red_Light_Status(Red_Index(ID));
  end Red_Light;

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Yellow_Light       .  BODY
  -- .                                           .
  -- .............................................
  function Yellow_Light (ID : in BUOY_ID) return OFF_ON is
  begin
    return Yellow_Light_Status(Yellow_Index(ID));
  end Yellow_Light;

  -- .............................................
  -- .                                           .
  -- .  Buoy_Sensor_Interface.Update             .  BODY
  -- .                                           .
  -- .............................................
  procedure Update (ID : in BUOY_ID) is
  begin
    Air_Temp_Index(ID) := Air_Temp_Index(ID) + 1;
    if Air_Temp_Index(ID) > Air_Temp'LAST then
      Air_Temp_Index(ID) := 0;
    end if;
    Water_Temp_Index(ID) := Water_Temp_Index(ID) + 1;
    if Water_Temp_Index(ID) > Water_Temp'LAST then
      Water_Temp_Index(ID) := 0;
    end if;
    Wind_Speed_Index(ID) := Wind_Speed_Index(ID) + 1;
    if Wind_Speed_Index(ID) > Wind'LAST then
      Wind_Speed_Index(ID) := 0;
    end if;
    Red_Index(ID) := Red_Index(ID) + 1;
    if Red_Index(ID) > Red_Light_Status'LAST then
      Red_Index(ID) := 0;
    end if;
    Yellow_Index(ID) := Yellow_Index(ID) + 1;
    if Yellow_Index(ID) > Yellow_Light_Status'LAST then
      Yellow_Index(ID) := 0;
    end if;
  end Update;

end Buoy_Sensor_Interface;
