-- Problem 2.9
-- by Rick Conn
with Text_IO;
procedure Main is

  type BIT is (OFF, ON);
  for BIT'SIZE use 1;
  for BIT use (OFF => 0, ON => 1);

  type BINIT is array (1..2) of BIT;
  pragma Pack (BINIT);

  type STATUS_WORD is record
    Carry_Bit    : BIT;
    Overflow_Bit : BIT;
    Zero_Bit     : BIT;
    Special      : BINIT;
  end record;
  for STATUS_WORD'SIZE use 5;
  for STATUS_WORD use record
    Carry_Bit    at 0 range 0..0;
    Overflow_Bit at 0 range 1..1;
    Zero_Bit     at 0 range 2..2;
    Special      at 0 range 3..4;
  end record;

  One_Status : STATUS_WORD := (Carry_Bit    => ON,
                               Overflow_Bit => OFF,
                               Zero_Bit     => ON,
                               Special      => (OFF, ON));

  Two_Status : STATUS_WORD := (Carry_Bit    => OFF,
                               Overflow_Bit => OFF,
                               Zero_Bit     => OFF,
                               Special      => (OFF, OFF));

  Tre_Status : STATUS_WORD := (Carry_Bit    => ON,
                               Overflow_Bit => ON,
                               Zero_Bit     => ON,
                               Special      => (ON, ON));

  procedure Display (Item : in STATUS_WORD) is
  begin
    Text_IO.Put_Line ("Carry_Bit      : " &
        BIT'IMAGE(Item.Carry_Bit));
    Text_IO.Put_Line ("  Overflow_Bit : " &
        BIT'IMAGE(Item.Overflow_Bit));
    Text_IO.Put_Line ("  Zero_Bit     : " &
        BIT'IMAGE(Item.Zero_Bit));
    Text_IO.Put_Line ("  Special      : " &
        BIT'IMAGE(Item.Special(1)) &
        BIT'IMAGE(Item.Special(2)));
  end Display;

begin -- Main

  Display (One_Status);
  Display (Two_Status);
  Display (Tre_Status);

end Main;
