-- DAT2TXT.ADA   Ver. 2.00   25-MAR-1991   Copyright 1988-1991 John J. Herro
-- Software Innovations Technology
-- 1083 Mandarin Drive NE, Palm Bay, FL  32905-4706   (407)951-0233
--
-- Run this program on a PC before installing ADA-TUTR on another computer.
-- It translates ADA_TUTR.DAT to TUTOR.TXT, a text file that can be easily
-- transferred to other computers.  Then compile and run TXT2DAT.ADA on the
-- other machine to create ADA_TUTR.DAT from TUTOR.TXT.
--
with DIRECT_IO, TEXT_IO;
procedure DAT2TXT is
   subtype BLOCK_SUBTYPE is STRING(1 .. 64);
   package RANDOM_IO is new DIRECT_IO(BLOCK_SUBTYPE);
   DATA_FILE  : RANDOM_IO.FILE_TYPE;                         -- The input file.
   TEXT_FILE  : TEXT_IO.FILE_TYPE;                          -- The output file.
   BLOCK      : BLOCK_SUBTYPE;             -- A block of 64 bytes being copied.
   OK         : BOOLEAN := TRUE;     -- True when both files open successfully.
   LEGAL_NOTE : constant STRING := " Copyright 1988-91 John J. Herro ";
                       -- LEGAL_NOTE isn't used by the program, but it causes
                       -- most compilers to place this string in the .EXE file.
begin
   begin
      RANDOM_IO.OPEN(DATA_FILE, RANDOM_IO.IN_FILE, NAME => "ADA_TUTR.DAT");
   exception
      when RANDOM_IO.NAME_ERROR =>
         TEXT_IO.PUT_LINE(
              "I'm sorry.  The file ADA_TUTR.DAT seems to be missing.");
         OK := FALSE;
   end;
   begin
      TEXT_IO.CREATE(TEXT_FILE, NAME => "TUTOR.TXT");
   exception
      when others =>
         TEXT_IO.PUT_LINE("I'm sorry.  I can't seem to create TUTOR.TXT.");
         TEXT_IO.PUT_LINE("Perhaps that file already exists?");
         OK := FALSE;
   end;
   if OK then
      while not RANDOM_IO.END_OF_FILE(DATA_FILE) loop
         RANDOM_IO.READ(DATA_FILE, ITEM => BLOCK);
         TEXT_IO.PUT_LINE(FILE => TEXT_FILE, ITEM => BLOCK);
      end loop;
      RANDOM_IO.CLOSE(DATA_FILE);
      TEXT_IO.CLOSE(TEXT_FILE);
      TEXT_IO.PUT_LINE("TUTOR.TXT created.");
   end if;
end DAT2TXT;
