-- CHANGESN.ADA   Ver. 2.00   25-MAR-1991   Copyright 1988-1991 John J. Herro
-- Software Innovations Technology
-- 1083 Mandarin Drive NE, Palm Bay, FL  32905-4706   (407)951-0233
--
-- Used to change the serial number in ADA_TUTR.DAT after registering.
--
with TEXT_IO, DIRECT_IO; use TEXT_IO;
procedure CHANGESN is
   subtype BLOCK_SUBTYPE is STRING(1 .. 64);
   package RANDOM_IO is new DIRECT_IO(BLOCK_SUBTYPE); use RANDOM_IO;
   DATA_FILE_NAME : constant STRING := "ADA_TUTR.DAT";
   DATA_FILE      : RANDOM_IO.FILE_TYPE;
   BLOCK          : BLOCK_SUBTYPE;            -- Block read from the data file.
   BLOCK_NUM      : RANDOM_IO.COUNT := 40;      -- Number of the current block.
   PLACE          : INTEGER;                 -- Index to search for "Serial #".
   FOUND          : BOOLEAN := FALSE;         -- True when "Serial #" is found.
   SERIAL_NUM     : STRING(1 .. 5);             -- The serial number, in ASCII.
   INPUT          : STRING(1 .. 6);                     -- Input that you type.
   LEN            : INTEGER;                          -- Length of typed input.
   LEGAL_NOTE     : constant STRING := " Copyright 1988-91 John J. Herro ";
                       -- LEGAL_NOTE isn't used by the program, but it causes
                       -- most compilers to place this string in the .EXE file.
begin
   RANDOM_IO.OPEN(DATA_FILE, MODE => INOUT_FILE, NAME => DATA_FILE_NAME);
   while not FOUND loop
      BLOCK_NUM := BLOCK_NUM + 1;
      READ(FILE => DATA_FILE, ITEM => BLOCK, FROM => BLOCK_NUM);
      PLACE := 0;
      while not FOUND and PLACE <= 50 loop
         PLACE := PLACE + 1;
         FOUND := BLOCK(PLACE .. PLACE + 7) = "Serial #";
      end loop;
   end loop;
   SERIAL_NUM := BLOCK(PLACE + 10 .. PLACE + 14);
   PUT_LINE("Old serial number is " & SERIAL_NUM & ".");
   PUT("New serial number:   ");
   INPUT := SERIAL_NUM & " ";
   GET_LINE(INPUT, LEN);
   NEW_LINE;
   BLOCK(PLACE + 10 .. PLACE + 14) := INPUT(1 .. 5);
   WRITE(FILE => DATA_FILE, ITEM => BLOCK, TO => BLOCK_NUM);
   CLOSE(DATA_FILE);
   PUT_LINE("Serial number changed to " & INPUT(1 .. 5) & ".");
exception
   when RANDOM_IO.NAME_ERROR =>
      PUT("I'm sorry.  The file " & DATA_FILE_NAME);
      PUT_LINE(" seems to be missing.");
   when RANDOM_IO.END_ERROR =>
      PUT("I'm sorry.  I couldn't find a serial number in ");
      PUT_LINE(DATA_FILE_NAME & ".");
end CHANGESN;
