;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                       ;;
;;   PTEST.ASM    Last modified: 09/29/87    R. Trevithick    MASM 4.0   ;;
;;-----------------------------------------------------------------------;;
;;    Tests and displays the printer control code files used by PSEND.   ;;
;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


CR      equ     0dh                             ; carriage return
LF      equ     0ah                             ; line feed
BS      equ     08h                             ; backspace
TAB     equ     09h                             ; tab character
BELL    equ     07h                             ; sound the horn
BSIZE   equ     07fffh                          ; 32K buffer should do it!


PRT     SEGMENT PARA PUBLIC 'CODE'              ; some info for the assembler
        ASSUME  CS:PRT, DS:PRT
        ORG     0100h


start:  cmp     byte ptr ds:[80h], 1            ; any parameters?
        jg      parm
        mov     dx, offset usage                ; no, usage message
        call    msg                             ; ...and abort
        inc     errors
        jmp     exit

parm:   mov     si, 82h
parm2:  cmp     byte ptr ds:[si], 0dh
        jne     parm3
        mov     byte ptr ds:[si], 0             ; insert zero byte for DOS
        jmp     short open
parm3:  inc     si
        jmp     short parm2

open:   mov     dx, 82h                         ; point to filespec in PSP
        mov     ax, 3d00h                       ; try to open for read-only
        int     21h
        jnc     read
        mov     dx, offset op_err
        call    msg
        inc     errors
        jmp     exit

read:   mov     bx, ax                          ; get handle into bx
        mov     dx, offset ds:buffer            ; point to the buffer
        mov     ah, 03fh                        ; read service
        mov     cx, BSIZE                       ; size of read buffer
        int     21h
        jnc     read2
        mov     dx, offset rd_err
        call    msg
        inc     errors
        jmp     exit

read2:  cmp     ax, 0                           ; special case, 0 byte file
        jne     read3
        mov     dx, offset no_data
        call    msg
        inc     errors
        jmp     exit

read3:  cmp     ax, BSIZE                       ; see if too large a file
        jb      disp
        mov     dx, offset too_big
        call    msg
        inc     errors
        jmp     exit

;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; here's where the work get's done
;
; bh = parser flag, bl = strlen
;

disp:   push    ax                              ; save return value
        mov     dx, offset codes                ; show 'Codes:' message
        call    msg
        pop     cx                              ; bytes read into loop counter

        call    pr_chk                          ; check the printer

        xor     bx, bx                          ; zero out our flags
        mov     si, offset buffer               ; pointer into file buffer
        mov     di, offset pr_buff              ; pointer into printer string

disp2:  mov     dx, offset bad_len              ; most likely error here
        mov     al, byte ptr ds:[si]            ; get a character
        cmp     al, '<'                         ; is it a start char?
        jne     disp3                           ; no, process it further
        inc     bh                              ; yes, set flag
        inc     count                           ;  track number found
        mov     al, 20h                         ;   make it a space
        jmp     short disp5                     ;    and display it

disp3:  cmp     bh, 0                           ; is flag set?
        je      disp6                           ; no, skip this one
        cmp     al, '>'                         ; is it an end char?
        jne     disp4                           ; no, see if length ok

        xor     bh, bh                          ; yes, turn off parser flag
        cmp     bl, 0                           ; any valid chars?
        je      abort                           ; no, flag it as error

        call    print                           ; try to send it to printer

        xor     bl, bl                          ;  reset length counter
        mov     di, offset pr_buff              ;   reset pointer to output
        jmp     short disp6                     ;    and back for more

disp4:  inc     bl                              ; bump up length counter
        cmp     bl, 3                           ; max length allowed
        ja      abort                           ; no good, skip numeric test

        mov     dx, offset bad_val              ; ready for value error
        cmp     al, '0'                         ; check for valid numeric
        jb      abort
        cmp     al, '9'
        ja      abort                           ; not numeric, abort

        jmp     short disp5                     ; ok, let this one through

abort:  xor     bh, bh                          ; bad code - reset system
        cmp     bl, 1                           ; have we shown any yet?
        ja      abort2                          ; yes, show the dash
        inc     dx                              ; no, display error alone

abort2: xor     bl, bl
        inc     errors                          ; bump up our error count
        call    msg                             ; dx already set

        jmp     short disp6                     ; back for more

disp5:  mov     dl, al                          ; display this byte
        mov     ah, 02h                         ;  using DOS service
        int     21h


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; build up printer output string
;
        cmp     dl, 20h                         ; skip the 1st one (space)
        je      disp6

        sub     dl, '0'                         ; convert to binary
        mov     byte ptr ds:[di], dl            ; stick it in print buffer
        inc     di                              ; bump up print buffer pointer

disp6:  inc     si                              ; point to next byte
        dec     cx                              ; unless end of buffer
        jz      done                            ; end, done

        jmp     disp2                           ; more, go get next byte


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
done:   cmp     count, 0                        ; any codes found?
        ja      errmsg                          ; yes
        mov     dx, offset nothing              ; no, mention the fact
        call    msg
        jmp     short exit                      ;  and skip other messages

errmsg: cmp     errors, 0                       ; any errors?
        je      final                           ; no
        mov     dx, offset bomb                 ; yes, error message
        call    msg

final:  cmp     pr_flag, 0                      ; printer message needed?
        ja      exit                            ; no, just exit
        mov     dx, offset pr_msg               ; yes, send it
        call    msg                             ; and fall through to exit

;
;----------------------------------------------------------------------------
; misc routines coded below


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; general exit routine
;
exit:   mov     al, errors                      ; set errorlevel == errors
        mov     ah, 4ch
        int     21h


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; send a message to console
;
msg:    mov     ah, 09h                         ; display a message
        int     21h
        ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; send codes to printer
;
print:  push    dx
        push    cx

        xor     dx, dx                          ; zero out output byte
        dec     di                              ; last digit found

        mov     dl, byte ptr ds:[di]            ; get ones digit
        dec     di
        dec     bl
        jz      pr_out

        mov     al, byte ptr ds:[di]            ; this is tens digit
        mov     cl, 10
        mul     cl
        add     dl, al
        dec     di                              ; back up again
        dec     bl
        jz      pr_out

        mov     al, byte ptr ds:[di]            ; this is hundreds digit
        mov     cl, 100
        mul     cl
        jc      pr_val                          ; carry flag, error
        add     dl, al
        jc      pr_val                          ; check again after add

pr_out: cmp     pr_flag, 0                      ; is printer on-line?
        jz      prexit                          ; no, just return
        mov     ah, 05h                         ; get ready to send
        int     21h                             ; send out the value
        jmp     short prexit                    ; and skip error routine

pr_val: mov     dx, offset bad_val              ; show the error with dash
        call    msg
        inc     errors                          ; bump up our error counter

prexit: pop     cx
        pop     dx
        ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; see if printer is ready
;
pr_chk: xor     dx, dx                          ; default printer
        mov     ah, 2                           ; printer status function
        int     17h                             ; of bios printer services
        cmp     ah, 10010000b                   ; printer on-line?
        jne     ck_ret
        mov     pr_flag, 1                      ; ok to print, flag it
ck_ret: ret


;
;----------------------------------------------------------------------------
; data storage area


usage   db      CR, LF, 'Test printer control code files ', 0feh, ' '
        db      'R.Trevithick 09/29/87', CR, LF, LF, '    '
        db      'PTEST [d:][path]filename.ext', CR, LF, '$'

op_err  db      TAB, 'cannot open file', BELL, '$'
rd_err  db      TAB, 'read error',       BELL, '$'
too_big db      TAB, 'file too large',   BELL, '$'
no_data db      TAB, 'file is empty',    BELL, '$'

codes   db      CR, LF, 'Codes:$'

bad_len db      '-<L>$'
bad_val db      '-<V>$'

nothing db      ' none found', CR, LF, '$'
bomb    db      CR, LF, TAB, 'errors found in codes!', BELL, '$'
pr_msg  db      CR, LF, TAB, 'printer not accepting characters$'

pr_flag db      0
errors  db      0
count   db      0

pr_buff db      3 dup (?)
buffer  db      BSIZE dup (?)

PRT     ENDS
        END     START

