/****************************************************************************
*
*					 MegaVision Application Framework
*
*			A C++ GUI Toolkit for the MegaGraph Graphics Library
*
*					Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: tframe.cpp $
* Version:		$Revision: 1.2 $
*
* Language:		C++ 3.0
* Environment:	IBM PC (MS DOS)
*
* Description:	Member functions for the TFrame class.
*
* $Id: tframe.cpp 1.2 1994/03/09 11:50:36 kjb Exp $
*
****************************************************************************/

#include "mvision.hpp"

#pragma	hdrstop

#include "tframe.hpp"

/*----------------------------- Implementation ----------------------------*/

void TFrame::handleEvent(TEvent& event,phaseType)
/****************************************************************************
*
* Function:		TFrame::handleEvent
* Parameters:	event	- Event to handle
*				phase	- Current phase for the event (pre,focus,post)
*
* Description:	Event handling routine for the TFrame class. If we have
*				a mouse down event inside the frame, we post a resize
*				event to resize the window.
*
****************************************************************************/
{
	switch (event.what) {
		case evMouseDown:
			if (event.mouse.buttons & mbLeftButton) {
				Point temp(event.where);
				globalToLocal(temp);
				if (!inner().includes(temp)) {
					event.what = evCommand;
					event.message.command = cmResize;
					event.message.infoPtr = NULL;
					putEvent(event);
					clearEvent(event);
					}
				}
			break;
		}
}

void TFrame::drawSolid()
/****************************************************************************
*
* Function:		TFrame::drawSolid
*
* Description:	Draws a solid frame in the current color and fill pattern.
*
****************************************************************************/
{
	int		w,h;
	TRect	r(bounds);

	MGL_getPenSize(&w,&h);
	MGL_setPenSize(width,width);			// Adjust pen size

	r.bottom() -= width-1;					// Compensate rectangle size
	r.right() -= width-1;
	MGL_rect(r);							// Draw the frame

	MGL_setPenSize(w,h);
}

void TFrame::draw(const TRect& clip)
/****************************************************************************
*
* Function:		TFrame::draw
* Parameters:	clip	- Clipping rectangle to use
*
* Description:	Draws the representation of the frame.
*
****************************************************************************/
{
	MGL_setClipRect(clip);				// Clip text to clip rect

	if (solid || width < 3) {
		MGL_setColor(getColor(state & sfActive ? 4 : 5));
		drawSolid();
		MGL_setColor(getColor(2));
		drawRect(bounds);
		}
	else {
		// Draw a 3d frame.
		TRect	r(bounds);

		MGL_setBorderColors(getColor(1),getColor(2));
		MGL_setColor(getColor(state & sfActive ? 3 : 5));
		drawBorder(r,BDR_OUTSET,1);
		r.inset(_MVIS_sysLineWidth,_MVIS_sysLineWidth);
		for (int i = 0; i < width-(2*_MVIS_sysLineWidth); i++) {
			MGL_rect(r);
			r.inset(1,1);
			}
		drawBorder(r,BDR_INSET,1);
		}
}

TRect TFrame::inner()
/****************************************************************************
*
* Function:		TFrame::inner
* Returns:		Rectangle representing the inner portion of the frame.
*
****************************************************************************/
{
	return TRect(bounds.left()+width,bounds.top()+width,
		bounds.right()-width,bounds.bottom()-width);
}
