/*
** This file defines common structures used by the INFO*SHARE
** message system.  These structures define file formats, user
** accounting information, and other items.
**
*/

#ifndef STRUCTS_DEF

#define STRUCTS_DEF

#define IDLETIME 20         /* minutes for idle timer */

#define uidlen 32
#define outbufsiz 10240
#define ibufsz 2048				/* should need 1024 at most, but give some
								 * space */

struct acct_rec
{
	char acctname[uidlen];		/* user name - null until it is claimed */
	char realname[uidlen];		/* user's REAL name */
	char street[32];			/* billing address */
	char city[22];
	char state[16];
	char zip[12];
	char phone[16];				/* billing phone number             */
	char pword[12];				/* user - supplied password */
	char compter;				/* single character computer type */
	char linfed;				/* y=line feed reqd, n=not reqd */
	unsigned log_date;			/* date/time of last logon     */
	unsigned log_time;
	unsigned creat_date;		/* date account was created */
	unsigned expire_date;		/* date account expires */
	unsigned birthday;			/* date field for birthday */
	unsigned linlen;			/* number of bytes per screen line */
	unsigned dloads;			/* number of files downloaded */
	unsigned long logons;		/* number of logons this month */
	unsigned long totlogons;	/* total number of logons */
	unsigned long acctime;		/* total minutes of connect time this month */
	unsigned long totacctime;	/* total minutes of connect time */
	unsigned acmsgdate[2];		/* date/time of last message read  */
    char setupques[6][40];      /* answers to sysop-specific questions  */
    int new_flag;               /* set to 1 when account created. */
    long uploadflags[2];
    int use_credits;            /* 1 if credit user, 0 if timed user */
	int priv_level;				/* this is the privilege level. */
	/* system, unrestricted, restricted */
	int verbose;				/* 1 = verbose, 0 = short */
	unsigned long tlcf_time;
	long msgskipflags[2];
	long msgreadflags[2];
	long msgpostflags[2];
    long dloadflags[2];
	long accessflags;
	unsigned uploads;
	char acctnum[10];			/* account number - optional */
	char a_comment[30];
    int dayacctime;             /* how long has he been online today? */
	int sex;					/* 1 = male, 0 = female */
	unsigned long bulreadtime;	/* date/time of last time bulletins read */
	unsigned AUTO1_date;		/* reserved fields! */
	unsigned AUTO1_time;		/* do not disturb! */
	unsigned prev_logdate;
	unsigned prev_logtime;		/* date and time of previous log on */
	char wphone[16];
	int lines_per_page;			/* normally 24 */
	int protocol;				/* users preferred protocol */
	unsigned long upload_k;		/* kbytes uploaded */
	unsigned long download_k;	/* kbytes downloaded */
	long credits;				/* credits this guy has */
    unsigned int logoff_date;
    unsigned int logoff_time;
    unsigned int prev_logoff_date;
    unsigned int prev_logoff_time;
    int account_type;
    char unused_space_2[14];    /* for future expansion */
};

#define priv_system     5
#define priv_sysop      4
#define priv_unrestricted 3
#define priv_demo       2
#define non_paying      1
#define priv_restricted 0

#define userbioaccess   1L
#define tlcf_access     2L
#define postemailaccess 4L
#define filessaccess    8L
#define subopaccess     16L
#define sysopaccess     32L
#define networkaccess   64L
#define submenuaccess   128L
#define submenu2access  256L
#define submenu3access  512L
#define submenu4access  1024L
#define submenu5access  2048L
#define sendallowed     4096L
#define stealthallowed  8192L
#define num_access_flags 14

/* the next structure is used by the software to manage
   each account while the user is on-line.
   current menu information and other pertinent information
   is kept in this structure.
*/

struct user_rec
{
	int u_stat;					/* primary state - indicates current
								 * subsystem */
	int u_stat2;				/* sub-state - function within subsystem */
	int u_eltime;				/* elapsed time from logon */
	unsigned int u_work1;		/* general purpose work variable */
	unsigned int u_work2;		/* general purpose work variable */
	int u_btusts;				/* current breakthru status */
	int u_paged;				/* user paged flag */
	int u_prflvl;				/* profanity level */
	int visitor;				/* is this just a visitor ? */
	int u_ansi;					/* 1 =supports ansi graphics, 0 = not */
	int u_idletime;				/* the amount of time to allow this user 2b
                                 * idle, in minutes */
	int door_inq;				/* doors input queue number    user->door */
	int door_outq;				/* doors output queue number   door->user */
	char doors_id[10];			/* doors program ID string */
	int u_doortcb;
	int u_privateflag;
	int u_timeroff;				/* activity timer disabled ? */
	unsigned int u_ticker;		/* 1-second ticker for user programs */
	int u_work3;				/* used by editor */
	int u_curmenu;				/* menu number for return in main menu */
	int connecttimer;			/* how many mins left on this call */
	int idletimer;
	int bgrdflag;				/* this guy performing bgrd xfers? */
	int current_cost;			/* credits per minute for current activity */
	unsigned baudrate;
	int time_left_today;		/* how many minutes left for the day ? */
	int time_on_thiscall;		/* how many minutes he's been online */
	int stealth;
    unsigned char ignore[9]; /* one bit for each line, if non-0 then */
                            /* the corresponding line is being ignored */
    unsigned char gag;   /* if non-0, user is gagged, cannot .send or */
                            /* talk in tlcf. */
    unsigned int insysopchat;
    unsigned int chatwith;
    int busyflag;           /* for turning off .sends */
    char unused_u_space[20];    /* for future expansion, so doors won't
								 * change */
};

#define vbsmsg 1
#define shortmsg 0

struct timestamp
{
	unsigned ts_date;			/* bit fields for date */
	unsigned ts_time;			/* bit fields for time */
	int ts_year;
	int ts_month;
	int ts_day;
	int ts_hour;
	int ts_minute;
	char ts_str[15];
};

#define EMBUFSIZE 8192

struct em_rec
{
	char em_acct[uidlen];		/* addressee */
	char em_origid[uidlen];		/* sender's id */
	char em_subject[40];		/* email subject */
	char em_filename[14];		/* for attached files */
	unsigned em_date;
	unsigned em_time;
	int em_new;					/* 1 if this is new message */
    char em_msg[EMBUFSIZE];          /* 100 lines, 80 chars (approx) */
};

struct u_em_rec
{
	char addr[uidlen];
	unsigned long cur_pos;
	int readnew;
	char cur_list[20];
	char subject[40];
	char fname[14];
	int pos_list_count;
	int list_indx;
	int receipt;				/* return receipt requested ? */
};

struct mail_list_rec
{
	char owner_id[uidlen];
	char listname[20];
	int entrycount;
	char list_entry[64][32];
};

/*
** Record structure for download file listings.
*/

#define DLREC_TEXT_SIZE 1200

struct dloadrec
{
    struct dload_header
    {
        unsigned dl_btype;          /* library number */
        unsigned dl_cat;            /* category */
        char dl_name[14];           /* full name, spaces allowed */
        long int dl_filesize;       /* file size */
        char dl_acctid[32];         /* who uploaded it */
        unsigned dl_date;           /* when was it uploaded */
        unsigned dl_lastdl;         /* last time it was downloaded */
        unsigned dl_count;          /* how many times it was dloaded */
        char dl_password[8];        /* password for file, if req'd */
    } dload_hdr;
    char dl_info[DLREC_TEXT_SIZE];  /* variable text to describe file */

};


struct windows
{
	char w_name[20];
	int x_max;
	int y_max;
	int last_x;
	int x_pos;
	int y_pos;
};

#define maxresp 100
#define msg_fixed_size 70
#define msg_resp_size  40

struct msg_record
{
	unsigned msgfolder;
	unsigned msgnum;
	unsigned last_update[2];
	char subject[60];
	unsigned respcnt;
	struct resp_rec
	{
		char orig_id[uidlen];
		unsigned post_time[2];
		unsigned long msgsequence;	/* uniquely identifies text */
	}   resp[maxresp];
};

#define xascii 0
#define xmodem 1
#define ACK 06
#define EOT 04
#define NAK 21
#define SOH 01
#define CAN 24
#define STX 02

/*
** The flags are defined as follows -
**   bit  0   is eot-sent flag
**   bit  1   is file-open flag
*/

#define eot_sent 1
#define crcflag  2
#define file_open 4
#define sendcflag 8
#define ymodemflag 16
#define no_save -1

typedef int (*faddr) ();		/* function address */

struct xfer_rec
{
	int xf_state;
	int xf_count;
	long xf_totsize;
	int xf_protocol;
	faddr xf_ulcompfunc;		/* function to execute when upload done */
	int bye_when_done;
	char xf_name[40];
	char xf_xkwd[4][16];		/* keywords to use in search */
};

#define FALSE 0
#define TRUE 1

/*
** State definitions for infoshare programs.
*/

#define st_idle           0		/* line not active */
#define st_logon          1		/* ring detected, user logging on */
#define st_newacct        2		/* new account processing */
#define st_main           3		/* main menu has been shown */
#define st_tlcf           4     /* teleconferencing */
#define st_userlist       5     /* user list                */
#define st_extern         6		/* executing a 'doors' program   */
#define st_logoff         7     /* user is receiving logoff message */
#define st_exitting       8     /* logging off */
#define st_system         9     /* system users menu */
#define st_system_disp   10     /* displaying user info */
#define st_system_edit   11     /* editting a user account */
#define st_oocredits     12     /* out of credits... leave feedback ? */
#define st_network       26     /* a second port for a door */

/*
** Operator (system console) state definitions
*/

#define opr_st_idle    0
#define opr_st_quit    1
#define opr_st_sendmenu   2
#define opr_st_send    3
#define opr_st_brcast  4
#define opr_st_monitor 5
#define opr_st_util    6
#define opr_st_fback   7
#define opr_st_hangup  8
#define opr_st_tlcf    9

#define opr_st_send2   10
#define opr_st_tlcf2   11

#define opr_st_showtlcf 12
#define opr_st_sim0 13			/* simulating channel 0 */
#define opr_st_sim1 14
#define opr_st_acctdel 15
#define opr_st_acctmyn 16

#define opr_st_acctedit  17
#define opr_st_record    18
#define opr_st_util3     19
#define opr_st_chat1     20
#define opr_st_chat2     21

#endif


