
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMS Interface for Borland C/C++, Version 1.1			*/
/*	Developed by Tanescu A. Horatiu					*/
/*	April 1997							*/
/*									*/
/* ---------------------------------------------------------------------*/
/*	C sources							*/
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMSA20.C							*/
/*									*/
/*	A20 management routines						*/
/*	(globalenableA20, globaldisableA20, localenableA20,		*/
/*	localdisableA20, queryA20)					*/
/*									*/
/* ---------------------------------------------------------------------*/

#include "xms.h"

#pragma inline

/* globalenableA20 - global enable A20
 */

int globalenableA20(void)
{
  asm	xor	bl, bl
  asm	mov	ah, 0x03
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* globaldisableA20 - global disable A20
 */

int globaldisableA20(void)
{
  asm	xor	bl, bl
  asm	mov	ah, 0x04
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* localenableA20 - local enable A20
 */

int localenableA20(void)
{
  asm	xor	bl, bl
  asm	mov	ah, 0x05
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* localdisableA20 - local disable A20
 */

int localdisableA20(void)
{
  asm	xor	bl, bl
  asm	mov	ah, 0x06
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}

/* queryA20 - query A20
 */

int queryA20(void)
{
  asm	xor	bl, bl
  asm	mov	ah, 0x07
  asm	call	dword ptr [xmscontrol]
  asm	mov	xmserrno, bl
  return (_AX);
}