
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMS Interface for Borland C/C++, Version 1.1			*/
/*	Developed by Tanescu A. Horatiu					*/
/*	April 1997							*/
/*									*/
/* ---------------------------------------------------------------------*/
/*	C sources							*/
/* ---------------------------------------------------------------------*/
/*									*/
/*	XMSINIT.C							*/
/*									*/
/*	Initialization Functions					*/
/*	(_xmsdefaultcontrol, _xmsdrivercheck, _getxmsfunct, initxms)	*/
/*									*/
/* ---------------------------------------------------------------------*/

#include "xms.h"

#pragma inline

unsigned char xmserrno = 0;
unsigned char xmsinstalled = 0;

/* default XMS control function
 */

void far _xmsdefaultcontrol(void)
{
  asm	xor	ax, ax
  asm	mov	bl, 0x80
  asm	mov	xmserrno, bl
}

void (far *xmscontrol)(void) = _xmsdefaultcontrol;

/* _xmsdrivercheck - determine if an XMS driver is installed
 */

int _xmsdrivercheck(void)
{
  asm	mov	ax, 0x4300
  asm	int	0x2F
  asm	xor	ah, ah
  asm	sub	ax, 0x80
  return (!_AX);
}

/* _getxmsfunct - get the address of the XMS driver's control function
 */

void _getxmsfunct(void)
{
  asm	mov	ax, 0x4310
  asm	int	0x2F
  asm	mov	word ptr [xmscontrol], bx
  asm	mov	word ptr [xmscontrol+2], es
}

/* initxms - initialization routine
   THIS ROUTINE MUST BE CALLED BEFORE ANY OTHER ROUTINE OR ALL THE OTHER
   ROUTINES WILL FAIL WITH ERROR CODE 0x80.
 */

int initxms(void)
{
  register int check = _xmsdrivercheck();
  if (check) _getxmsfunct();
  xmsinstalled = check;
  return (check);
}