/*****************************************************************************
*                                                                            *
*  File: AwcAp150.H                                                          *
*                                                                            *
*  This file contains definitions for all variables and functions            *
*  used in standard I/O, string and Web-Server operations.                   *
*                                                                            *
******************************************************************************
*                                                                            *
*  Copyright 1999-2000 Advanced Web Communication, division of Xecom, Inc.   *
*                                                                            *
*  This software is  the property of  Advanced Web Communication, Division   *
*  of Xecom, Inc.  which  specifically grants the user the right to use and  *
*  distribute this software provided this notice is not removed or altered.  *
*  All other rights are reserved by AWC(Xecom).                              *
*                                                                            *
*  XECOM MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH REGARD  TO  *
*  THIS SOFTWARE.  IN  NO EVENT  SHALL XECOM BE LIABLE  FOR  INCIDENTAL  OR  *
*  CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING FROM THE FURNISHING,  *
*  PERFORMANCE, OR USE OF THIS SOFTWARE.                                     *
*                                                                            *
*  So that all may benefit from your experience, please report any problems  *
*  or suggestions  about  this  software back to Xecom  Please include your  *
*  name, company, telephone number, Xecom product  requiring  support   and  *
*  question or problem encountered.                                          *
*                                                                            *
*  Advanced WEB Communication (AWC), Division of Xecom, Inc.                 *
*  374 Turquoise Street, Milpitas, CA 95035                                  *
*                                                                            *
*  Worldwide support and contact information available at:                   *
*  http://www.xecom.com/                                                     *
*  http://www.xecom.com/support/web-controller.htm                           *
*                                                                            *
******************************************************************************
*                                                                            *
*  Revision record:                                                          *
*                                                                            *
*   07-28-2000 MicroRTOS Revision 1.50 released                              *
*   03-20-2000 MicroRTOS Revision 1.01 released                              *
*   02-01-2000 MicroRTOS Revision 1.00 released                              *
*   10-11-1999 MicroRTOS established with Web-Server function                *
*   08-01-1999 Initiated for the Embedded Web Server Controller              *
*                                                                            *
*****************************************************************************/

#define TRUE    1
#define FALSE   0
#define NULL    0

#define BYTE    unsigned char
#define WORD    unsigned int
#define DWORD   unsigned long

#define MK_FP(seg,ofs) ((void _seg *)(seg) + (void _near *)(ofs))
#define FP_SEG(fp)     ((unsigned)(void _seg *)(void _far *)(fp))
#define FP_OFF(fp)     ((unsigned)(fp))

#define Disable()       asm CLI     /* Disable interrupts */
#define Enable()        asm STI     /* Enable  interrupts */

#define SMTP_MARK       0xB0
#define POP3_MARK       0xB2

typedef struct {
    void *  func;
    char *  name;
    int     id;
    int     prio;
    WORD    stack_size;
} FUNC_TAB;

typedef struct{
	unsigned char code;
	unsigned char level;
	char Name[12];
	char Password[12];
	unsigned char DateTime[6];
} ACCOUNT;

typedef struct _XMS {
    char        far * name;
    WORD              type;
    WORD              cont;
    void        far * data;
    struct _XMS far * prev;
    struct _XMS far * next;
} XEMSG;

typedef struct {
    void            * nf;
    char            * nn;
    int               nl;
    char            * nh;
    char        far * name;
    WORD              type;
    WORD              cont;
    void        far * data;
    struct _XMS far * prev;
    struct _XMS far * next;
    void        far * func;
    WORD              level;
    char        far * help;
} USER_CMD;

#define TYPE_USER_CMD   0xfff0

#define LED_NORMAL  1
#define LED_LEFT    2
#define LED_RIGHT   3
#define LED_FLASH   4

typedef union _IPADDR {
    unsigned char   addr[4];
    unsigned long   address;
    } IPADDR;

typedef struct {
    BYTE    		mark;
    BYTE    		type;
    IPADDR  		ip;
    char    		from[24];
} SMTP_REC;

typedef struct {
    BYTE    		mark;
    BYTE    		type;
    IPADDR  		ip;
    char    		user[12];
    char    		pswd[12];
} POP3_REC;

typedef struct _CGI_OPTION {
    char    		*name;
    char    		*value;
    } CGI_OPTION;

typedef struct _CGI_PRG {
    void    		*proc;
    char    		*name;
    } CGI_PRG;

typedef struct _GST_LIST {
    IPADDR          ip;
    char            fname[14];
    unsigned int    t[6];
    unsigned int    n;
    } GST_LIST;

typedef struct _FBREC {
    IPADDR  		ip;
    char 			name[21];
    char 			pswd[11];
    char 			data[256];
    } FBREC;

/*****************************************************************************
				Macro define
*****************************************************************************/
#define DIO00 00
#define DIO01 01
#define DIO02 02
#define DIO03 03
#define DIO04 04
#define DIO05 05
#define DIO06 06
#define DIO07 07
#define DIO08 08
#define DIO09 09
#define DIO10 10
#define DIO11 11
#define DIO12 12
#define DIO13 13
#define DIO14 14
#define DIO15 15
#define DIO16 16
#define DIO17 17
#define DIO18 18
#define DIO19 19
#define DIO20 20
#define DIO21 21
#define DIO22 22
#define DIO23 23
#define DIO24 24
#define DIO25 25

#define PIN10 DIO00
#define PIN11 DIO01
#define PIN12 DIO02
#define PIN13 DIO03
#define PIN14 DIO04
#define PIN15 DIO05
#define PIN16 DIO06
#define PIN17 DIO07
#define PIN18 DIO08
#define PIN19 DIO09
#define PIN40 DIO10
#define PIN41 DIO11
#define PIN42 DIO12
#define PIN43 DIO13
#define PIN44 DIO14
#define PIN45 DIO15
#define PIN46 DIO16
#define PIN47 DIO17
#define PIN48 DIO18
#define PIN49 DIO19
#define PIN50 DIO20
#define PIN51 DIO21
#define PIN36 DIO22
#define PIN37 DIO23
#define PIN38 DIO24
#define PIN39 DIO25

#define DEVICE_USED         DWORD _dev_table[4] = {(
#define DIO_INPUT           0),(
#define DIO_OUTPUT_0        0),(
#define DIO_OUTPUT_1        0),(
#define USED_END            0)};

#define PIN10_DIO00_TXDA    0x00000001 |
#define PIN11_DIO01_RXDA    0x00000002 |
#define PIN12_DIO02_RTSB    0x00000004 |
#define PIN13_DIO03_CTSB    0x00000008 |
#define PIN14_DIO04_TXDB    0x00000010 |
#define PIN15_DIO05_RXDB    0x00000020 |
#define PIN16_DIO06         0x00000040 |
#define PIN17_DIO07         0x00000080 |
#define PIN18_DIO08_INT2    0x00000100 |
#define PIN19_DIO09_INT4    0x00000200 |
#define PIN40_DIO10         0x00000400 |
#define PIN41_DIO11         0x00000800 |
#define PIN42_DIO12         0x00001000 |
#define PIN43_DIO13_INT6    0x00002000 |
#define PIN44_DIO14_INT5    0x00004000 |
#define PIN45_DIO15_TIN0    0x00008000 |
#define PIN46_DIO16_TOUT0   0x00010000 |
#define PIN47_DIO17         0x00020000 |
#define PIN48_DIO18         0x00040000 |
#define PIN49_DIO19         0x00080000 |
#define PIN50_DIO20         0x00100000 |
#define PIN51_DIO21         0x00200000 |
#define PIN36_DIO22         0x00400000 |
#define PIN37_DIO23         0x00800000 |
#define PIN38_DIO24         0x01000000 |
#define PIN39_DIO25         0x02000000 |
#define PIN20_NMI           0x04000000 |
#define PIN21_INT_1         0x08000000 |
#define PIN22_INT_3         0x10000000 |
#define PIN23_CLKOUT        0x20000000 |

#define USE_ADC             0x00000001 |
#define USE_DAC             0x00000002 |
#define USE_CONSOLE_B       0x00000004 |
#define USE_TIMER_0         0x00000008 |
#define USE_CONSOLE_A       0x00000010 |
#define NOT_DETECT_MODEM    0x00000020 |

#define CGI_TABLE           CGI_PRG  _cgi_table[] = {
#define CGI_TABLEEND        {NULL,0}};

#define CMD_TABLE           USER_CMD _cmd_table[] = {
#define CMD_TABLEEND        {0,0,NULL,NULL}};

#define TSK_TABLE           FUNC_TAB _tsk_table[] = {
#define TSK_TABLEEND        {NULL,0,0,0,0}};

#ifdef CMDFILE
    #define FILE_CMD    0x81
#else
    #define FILE_CMD    0x00
    WORD _cmd_table     = 0;
#endif

#ifdef CGIFILE
    #define FILE_CGI    0x82
#else
    #define FILE_CGI    0x00
    WORD _cgi_table     = 0;
#endif

#ifdef TASKFILE
    #define FILE_TASK   0x84
#else
    #define FILE_TASK   0x00
    WORD _tsk_table     = 0;
#endif

WORD    FileType = FILE_CMD | FILE_CGI | FILE_TASK;

/*****************************************************************************
			String Macro define
*****************************************************************************/
#define strcat(x,y)			_fstrcat(x,y)
#define strchr(x,y)     	_fstrchr(x,y)
#define strcmp(x,y)     	_fstrcmp(x,y)
#define strcpy(x,y)     	_fstrcpy(x,y)
#define strcspn(x,y)    	_fstrcspn(x,y)
#define strdup(x)       	_fstrdup(x)
#define stricmp(x,y)    	_fstricmp(x,y)
#define strlen(x)       	_fstrlen(x)
#define strlwr(x)       	_fstrlwr(x)
#define strncat(x,y,z)  	_fstrncat(x,y,z)
#define strncmp(x,y,z)  	_fstrncmp(x,y,z)
#define strncpy(x,y,z)  	_fstrncpy(x,y,z)
#define strnicm(x,y,z)  	_fstrnicm(x,y,z)
#define strnset(x,y,z)  	_fstrnset(x,y,z)
#define strpbrk(x,y)    	_fstrpbrk(x,y)
#define strrchr(x,y)    	_fstrrchr(x,y)
#define strrev(x)       	_fstrrev(x)
#define strset(x,y)     	_fstrset(x,y)
#define strspn(x,y)     	_fstrspn(x,y)
#define strstr(x,y)     	_fstrstr(x,y)
#define strtok(x,y)     	_fstrtok(x,y)
#define strupr(x)       	_fstrupr(x)

/*****************************************************************************
			Digital I/O Functions
*****************************************************************************/
void        	far DinSet(WORD n);
int         	far DinGet(WORD n);
int         	far DinSetGet(WORD n);
void        	far DoutHigh(WORD n);
void        	far DoutLow(WORD n);
int         	far DioState(WORD n);
void        	far DoutSetHigh(WORD n);
void        	far DoutSetLow(WORD n);

/*****************************************************************************
			Analog I/O Functions
*****************************************************************************/
WORD        	far Ain(BYTE n);
void        	far AinAll(int far *ad);
void        	far AOut(WORD da0_code,WORD da1_code);

/*****************************************************************************
			Real Time Clock Functions
*****************************************************************************/
void        	far RtcSet( int far *t);
void        	far RtcGet( int far *t);
void        	far RtcON(void);
void        	far RtcOFF(void);

/*****************************************************************************
			COM-A Operation functions
*****************************************************************************/
int         	kbhit(void);
int         	getch(void);
int         	getche(void);
int         	putch(char c);
int         	far printf(const char far *s, ...);

/*****************************************************************************
			COM-B Operation functions
*****************************************************************************/
int         	far Bkbhit( void );
int         	far Bgetch( void );
int         	far Bgetche( void );
int         	far Bputch( char Char );
int         	far Bputs(char far *string);
void        	far BModeSet(int mode);
int         	far BModeGet(void);
int         	far BbaudSet(DWORD baud);
DWORD       	far BbaudGet(void); 

/*****************************************************************************
			Console Operation functions
*****************************************************************************/
int         	far ConHit(void);
int         	far ConGetch(void);
int         	far ConPutch(char c);
void        	far ConPuts(char far *s);

/*****************************************************************************
			The Data Record Functions
*****************************************************************************/
void far *  	far DataRecFind(unsigned char code);
void far *  	far DataRecNext(unsigned char code, void far *next);
int         	far DataRecWrite(void far * Rec);
int         	far DataRecUpdate(void far *Rec, void far * NeW);
int         	far DataRecDelete(void far *Rec);
int         	far DataRecSqueeze(void);

/*****************************************************************************
			The Message Functions
*****************************************************************************/
int         	far MsgCreate(XEMSG far *New);
int         	far MsgDelete(XEMSG far *MsgBox);
void far *  	far MsgFind(char far *Name, WORD type);
void far *  	far MsgNameFind(char far *Name, int n);
void far *  	far MsgTypeFind(WORD type, int n);

/*****************************************************************************
			The TCP/IP  Functions  
*****************************************************************************/
int         	far HostIP(char far *host, IPADDR far *ip);
int         	far SocketLink(IPADDR ip, int port);
int         	far SocketRead(int id, char far *buff, int len);
int         	far SocketWrite(int id, char far *data, int len);
int         	far SocketClose(int id);
int         	far SocketListen(int port);
int         	far SocketStatus(int id);

/*****************************************************************************
			Web Server Function
*****************************************************************************/
int             far WebSend(char far *s);
char far *      far CGIGetParaValue(char far *);
IPADDR          far GetCurDestIP(void);

/*****************************************************************************
			Email functions
*****************************************************************************/
int 			MailGet(IPADDR ip,
						char far *username,
						char far *password,
						char far *buff,
						int len,
						int letterID,
						int download,
						int del);

int 			MailSend(IPADDR ip,
						char far *from,
						char far *to,
						char far *cc,
						char far *subject,
						char far *message);

/*****************************************************************************
		System Functions
*****************************************************************************/
BYTE        	far DelayTime(BYTE h, BYTE m, BYTE s, WORD milli);
void        	near setvect(int v, void near *vect);
BYTE        	far SuspendTask(BYTE prio);
BYTE        	far ResumeTask(BYTE prio);

/*****************************************************************************
		User Account Functions
*****************************************************************************/
unsigned long	far AccountSearch(ACCOUNT far *UserAccount,int IfCheckPassword);
int				far AccountWrite(ACCOUNT far *UserAccount);
int				far AccountDelete(ACCOUNT far *UserAccount,int CheckPassword);
int             far AccountPswdCheck(char far * name,char far * pswd);
int             far AccountPswdChange(char far * name,char far * pswd,char far * newp);

/*****************************************************************************
			String Functions
*****************************************************************************/
int         	far atoi(char far *);
long        	far atol(char far *);
DWORD       	far strtoul(const char far *s, void far *endptr, int radix);
int         	far sprintf(char far *str, const char far *s, ...);
int         	far sscanf(char far *str, const char far *s, ...);

char far *  	far _fstrcat(char far *dest, const char far *src);
char far *  	far _fstrchr(const char far *s, int c);
int         	far _fstrcmp(const char far *s1, const char far *s2);
char far *  	far _fstrcpy(char far *dest, const char far *src);
unsigned    	far _fstrcspn(const char far *s1, const char far *s2);
char far *  	far _fstrdup(const char far *s);
int         	far _fstricmp(const char far *s1, const char far *s2);
unsigned    	far _fstrlen(const char far *s);
char far *  	far _fstrlwr(char far *s);
char far *  	far _fstrncat(char far *dest, char far *src, unsigned maxlen);
int         	far _fstrncmp(char far *s1, char far *s2, unsigned maxlen);
char far *  	far _fstrncpy(char far *dest, char far *src, unsigned maxlen);
int         	far _fstrnicmp(char far *s1, char far *s2, unsigned maxlen);
char far *  	far _fstrnset(char far *s, int ch, unsigned n);
char far *  	far _fstrpbrk(const char far *s1, const char far *s2);
char far *  	far _fstrrchr(const char far *s, int c);
char far *  	far _fstrrev(char far *s);
char far *  	far _fstrset(char far *s, int ch);
unsigned    	far _fstrspn(const char far *s1, const char far *s2);
char far *  	far _fstrstr(const char far *s1, const char far *s2);
char far *  	far _fstrtok(char far *s1, const char far *s2);
char far *  	far _fstrupr(char far *s);

/*****************************************************************************
			Input and Output Functions and Macro
*****************************************************************************/
#ifdef __BORLANDC__
BYTE			inp(WORD p);
WORD    		inpw(WORD p);
void    		outp(WORD p, BYTE d);
void    		outpw(WORD p, WORD d);
#endif

#ifdef _MSC_VER
#define inportb(x)          inp(x)
#define inportw(x)          inpw(x)
#define outportb(p,d)       outp(p,d)
#define outportw(p,d)       outpw(p,d)
#endif

/*****************************************************************************
			Memory Functions
*****************************************************************************/
void far *  	far _fmemcpy(void far *t, void far *s, unsigned int n);
void far *  	far _fmemset(void far *s, int c, unsigned int n);

/*****************************************************************************
			functions for AWC demo
*****************************************************************************/
int             far XeGuestGetNumber(void);
GST_LIST far *  far XeGuestGetInfo(int n);
