 REM Indent.bas v6.4b r1.0 - Symbolic Instruction Code; indent module.
 REM The public domain DOS programming interpreter utility.

 ' get standard include declarations
 REM $INCLUDE: 'SIC.INC'

 ' backwards compatible for bc 7.1
 REM $INCLUDE: 'bc7.inc'

 ' declare global error routine
 ON ERROR GOTO Error.Routine

 ' program code
 REDIM Program(1 TO Max.Lines) AS STRING

 ' initialize variables
 White.Space = CHR$(32) + CHR$(9)

 ' run program from command line
 Filename = COMMAND$
 IF LEN(Filename) = False THEN
    GOTO Boot.Usage
 END IF
 IF DIR$(Filename) = Nul THEN
    GOTO Boot.Usage
 END IF
 CALL New.Program
 Original.Filename$ = Filename
 CALL Load.Program(Filename)
 CALL Indent.Program(0)
 CALL Save.Program(Original.Filename$)
Error.Resume:
 CALL Quit.Program
 END

Boot.Usage:
 COLOR White, Black
 PRINT "INDENT v" + Version + " r" + Release + "; Usage:"
 COLOR Yellow, Black
 PRINT "INDENT <program name>"
 PRINT "   Starts INDENT and indents program."
 COLOR Plain, Black
 END

 ' standard error trap for all Sic functions.
Error.Routine:
 IF POS(0) > 1 THEN
    PRINT
 END IF
 COLOR White, Black
 PRINT "Indent utility error";Err
 CALL Key.Prompt
 RESUME Error.Resume

' declares indent structure types
Indent.Data:
 ' 1=indent right
 DATA "SELECTIF CASE", 1
 DATA "DO WHILE", 1
 DATA "DO", 1
 DATA "IF", 1
 DATA "SELECT CASE", 1
 DATA "DO UNTIL", 1
 DATA "FORIF", 1
 DATA "FOR", 1
 DATA "WHILE", 1
 DATA "LOOPIF", 1
 ' -1=indent left
 DATA "ENDIF", -1
 DATA "END IF", -1
 DATA "NEXTIF", -1
 DATA "NEXT", -1
 DATA "LOOP UNTIL", -1
 DATA "LOOP WHILE", -1
 DATA "END SELECT", -1
 DATA "WEND", -1
 DATA "END LOOPIF", -1
 DATA "LOOP", -1
 DATA "END SELECTIF", -1
 ' -2=indent left, then right
 DATA "ELSE", -2
 DATA "CASE", -2
 DATA "EOF", 0

' indents current program
SUB Indent.Program(X)
 COLOR White, Black
 CALL More.Prompt("Indent with tabs or spaces(t/s/q)?", "tsq", Output.Char$)
 SELECT CASE Output.Char$
 CASE "t"
    Tabs = True
 CASE "s"
    Tabs = False
 CASE "q"
    EXIT SUB
 END SELECT
 COLOR White, Black
 IF Tabs THEN
    PRINT "Enter number of tabs to indent";
 ELSE
    PRINT "Enter number of spaces to indent";
 END IF
 INPUT Increment
 Indent = False
 CALL Count.Lines(Last.Line)
 FOR Program.Line = 1 TO Last.Line
    IF Tabs THEN
       Number$ = CHR$(9)
    ELSE
       Number$ = SPACE$(6 - LEN(STR$(Program.Line)))
    END IF
    Out2 = Program(Program.Line)
    Out2 = STRIM$(Out2)
    IF LEN(Out2) THEN
       Temp1$ = STRIM$(Out2)
       Temp1$ = UCASE$(Temp1$)
       Temp1$ = TTRIM$(Temp1$, False)
       Next.Indent = False
       RESTORE Indent.Data
       DO
	  READ Keyword$, KeyIndent
	  IF Keyword$ = "EOF" THEN
	     EXIT DO
	  END IF
	  IF LEFT$(Temp1$, LEN(Keyword$)) = Keyword$ THEN
	     Next.Indent = KeyIndent
	     EXIT DO
	  END IF
       LOOP
       SELECT CASE Next.Indent
       CASE 1
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
	  Indent = Indent + 1
       CASE -1
	  Indent = Indent - 1
	  IF Indent < False THEN
	     PRINT "Indent error: Line:"; Program.Line
             EXIT SUB
	  END IF
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
       CASE -2
	  Indent = Indent - 1
	  IF Indent < False THEN
	     PRINT "Indent error: Line:"; Program.Line
             EXIT SUB
	  END IF
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
	  Indent = Indent + 1
       CASE ELSE
          IF Tabs THEN
             Out2 = STRING$(Indent * Increment, CHR$(9)) + STRIM$(Out2)
          ELSE
             Out2 = SPACE$(Indent * Increment) + STRIM$(Out2)
          END IF
       END SELECT
       Out2 = Number$ + Out2
       Program(Program.Line) = Out2
    END IF
 NEXT
 IF Indent <> False THEN
    PRINT "Indent error: Line:"; Program.Line
    EXIT SUB
 END IF
 PRINT "Program indented."
END SUB

' gets last line in program
SUB Count.Lines (Temp1%)
 Temp1% = False
 FOR Temp2% = Max.Lines TO 1 STEP -1
    Temp1$ = Program(Temp2%)
    Temp1$ = STRIM$(Temp1$)
    IF LEN(Temp1$) THEN
       EXIT FOR
    END IF
 NEXT
 Temp1% = Temp2%
END SUB

' loads a program from disk
SUB Read.Program
 CLOSE
 OPEN Filename FOR INPUT AS #1
 DO WHILE NOT EOF(1)
    LINE INPUT #1, Out2
    FOR Blanks = 1 TO LEN(White.Space)
       Imbedded = INSTR(Out2, MID$(White.Space, Blanks, 1))
       IF Imbedded THEN
          Line.Number = INT(VAL(LEFT$(Out2, Imbedded - 1)))
          IF Line.Number > False AND Line.Number <= Max.Lines THEN
             Program(Line.Number) = MID$(Out2, Imbedded)
             EXIT FOR
          END IF
       END IF
    NEXT
 LOOP
 CLOSE
END SUB

' replaces white spaces with blanks
' var = -1 skip blanks in quotes
FUNCTION TTRIM$(Var$, Var)
 VarX$ = Var$
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    FOR Blanks = 1 TO LEN(White.Space)
       IF MID$(VarX$, Temp, 1) = MID$(White.Space, Blanks, 1) THEN
          MID$(VarX$, Temp, 1) = " "
       END IF
    NEXT
 LOOP
 Temp = False
 DO
    Temp = Temp + 1
    IF Temp > LEN(VarX$) THEN
       EXIT DO
    END IF
    IF Var THEN
       IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
          DO
             Temp = Temp + 1
             IF Temp > LEN(VarX$) THEN
                EXIT DO
             END IF
             IF MID$(VarX$, Temp, 1) = CHR$(34) THEN
                EXIT DO
             END IF
          LOOP
       END IF
    END IF
    IF MID$(VarX$, Temp, 2) = "  " THEN
       VarX$ = LEFT$(VarX$, Temp) + MID$(VarX$, Temp + 2)
       Temp = Temp - 1
    END IF
 LOOP
 TTRIM$ = VarX$
END FUNCTION

' strips leading/trailing white spaces from string
FUNCTION STRIM$(Var$)
 XVar$ = Var$
 FOR Count = 1 TO LEN(White.Space)
    DO
       IF LEFT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = MID$(XVar$, 2)
       ELSE
	  EXIT DO
       END IF
    LOOP
    DO
       IF RIGHT$(XVar$, 1) = MID$(White.Space, Count, 1) THEN
	  XVar$ = LEFT$(XVar$, LEN(XVar$) - 1)
       ELSE
	  EXIT DO
       END IF
    LOOP
 NEXT
 STRIM$ = XVar$
END FUNCTION

' stops the Sic engine
SUB Quit.Program
 LineFeed = False
 CALL End.Program
 PRINT "Exiting to system.."
 END
END SUB

' prompts for a keystroke
SUB Key.Prompt
 COLOR White, Black
 LOCATE , , 1
 PRINT "Press any key to continue:";
 Input.Char$ = Nul
 DO
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       EXIT DO
    END IF
 LOOP
 PRINT
END SUB

' end of program routine
SUB End.Program
 SCREEN 0
 WIDTH 80, 25
 COLOR Plain, Black
 LOCATE , , , 8, 8
 IF LineFeed THEN
    PRINT
 END IF
 WHILE INKEY$ <> Nul
 WEND
END SUB

' stores current .sic program
SUB Save.Program(Temp.Name$)
 DO
    DO
       IF Temp.Name$ = Nul Then
          COLOR White, Black
          PRINT "Program name to save";
          IF Program.Name <> "<untitled>" THEN
             COLOR White, Black
             PRINT "("; Program.Name; ")";
          END IF
          INPUT Program.File$
       ELSE
          Program.File$ = Temp.Name$
       END IF
       IF Program.File$ = Nul THEN
	  IF Program.Name <> "<untitled>" THEN
             Program.File$ = Program.Name
	     EXIT DO
	  END IF
       ELSE
          Program.File$ = STRIM$(Program.File$)
          Program.File$ = LCASE$(Program.File$)
          IF RIGHT$(Program.File$, 4) = ".sic" THEN
             Program.File$ = LEFT$(Program.File$, LEN(Program.File$) - 4)
          END IF
	  EXIT DO
       END IF
    LOOP
    Program.File$ = LEFT$(Program.File$, 8)
    Filename = Program.File$ + ".sic"
    IF Temp.Name$ = Nul THEN
       COLOR White, Black
       PRINT "Save program as "; CHR$(34); Filename; CHR$(34);
       CALL More.Prompt("(y/n/q)?", "ynq", Output.Char$)
    ELSE
       Output.Char$ = "y"
    END IF
    SELECT CASE Output.Char$
    CASE "y"
       IF Temp.Name$ = Nul THEN
          Output.Char$ = "y"
          IF DIR$(Filename) <> Nul THEN
             PRINT "Program already exists. ";
             CALL More.Prompt("Overwrite(y/n)?", "yn", Output.Char$)
          END IF
       ELSE
          Output.Char$ = "y"
       END IF
       IF Output.Char$ = "y" THEN
          Program.Name = Program.File$
	  CALL Store.Program
	  COLOR White, Black
          PRINT "Program "; CHR$(34); Filename; CHR$(34); " saved to disk."
	  EXIT DO
       END IF
    CASE "q"
       COLOR White, Black
       PRINT "Program not saved to disk."
       EXIT DO
    END SELECT
 LOOP
END SUB

' writes out the current .sic program to file
SUB Store.Program
 CLOSE
 OPEN Filename FOR OUTPUT AS #1
 CALL Count.Lines(Last.Line)
 FOR Line.Number = 1 TO Last.Line
    ProgramLine$ = Program(Line.Number)
    IF STRIM$(ProgramLine$) <> Nul THEN
       IF INSTR(White.Space, LEFT$(ProgramLine$, 1)) THEN
          PRINT #1, MID$(STR$(Line.Number), 2) + ProgramLine$
       ELSE
          PRINT #1, MID$(STR$(Line.Number), 2) + " " + ProgramLine$
       END IF
    END IF
 NEXT
 CLOSE
END SUB

' remove current .sic program from memory
SUB New.Program
 ' erase/redimension program code array
 ERASE Program
 REDIM Program(1 TO Max.Lines) AS STRING
END SUB

' prompts for multiple input characters
SUB More.Prompt (Input.String$, Input.Mask$, Output.String$)
 COLOR White, Black
 PRINT Input.String$; " ";
 Input.Char$ = Nul
 DO
    LOCATE , , 1
    Input.Char$ = INKEY$
    IF LEN(Input.Char$) THEN
       Input.Char$ = LCASE$(Input.Char$)
       IF INSTR(Input.Mask$, Input.Char$) THEN
	  PRINT Input.Char$
	  Output.String$ = Input.Char$
	  EXIT DO
       END IF
    END IF
 LOOP
END SUB

' loads a .sic file
SUB Load.Program(Temp.Name$)
 IF Temp.Name$ = Nul THEN
    COLOR White, Black
    PRINT "Program name to load";
    INPUT Program.File$
 ELSE
    Program.File$ = Temp.Name$
 END IF
 IF Program.File$ = Nul THEN
    EXIT SUB
 END IF
 Program.File$ = STRIM$(Program.File$)
 Program.File$ = LCASE$(Program.File$)
 IF RIGHT$(Program.File$, 4) = ".sic" THEN
    Program.File$ = LEFT$(Program.File$, LEN(Program.File$) - 4)
 END IF
 Program.File$ = LEFT$(Program.File$, 8)
 Filename = Program.File$ + ".sic"
 CALL New.Program
 Program.Name = "<none>"
 CALL Read.Program
 Program.Name = LCASE$(Program.File$)
 COLOR White, Black
 PRINT "Program loaded."
END SUB

