// ***************************************
// GREP TO LOG TRANSLATOR
//
//
//                      Written by Gemicha
// ***************************************

// This program reads Turbo Grep output from stdin, translates it
// to log format, and writes translated text to stdout.
//
// POWER VIEW IDE LOG FORMAT DESCRIPTION
//
// All lines written to stdout must be in the format
//
// <file>,<line>,<column>,<message>\n
//
// where <file> is full file specification of the source file, <line>
// and <column> are location of the message (error) in the source file,
// and <message> is the text to be displayed by the IDE.
//
// If any of <file>, <line> or <column> are unknown, leave responding
// field empty, for example ",,,something" describes none of <file>,
// <line> and <column> are given, and the message is "something".
//
// It is a good idea, if compiler output is not recognized to copy all
// stdin lines to stdout in the form ",,,<message>", wich guarantees
// that all the messages will be displayed in the log.


#include <ctype.h>
#include <mem.h>
#include <stdio.h>
#include <stdlib.h>

#define MAX_LINE_SIZE     255

static char buffer[MAX_LINE_SIZE+1]; //buffer for read lines

static char *read( void )
{
  return fgets( buffer, MAX_LINE_SIZE, stdin );
}

static int write( char *l )
{
  return fputs( l, stdout );
}


void main( void )
{
  char file[128];
  int flag;

  *file = 0;
  flag = 0;
  while( read() != NULL )
  {
    if( *buffer<' ' ) continue;
    if( memcmp( buffer, "File ", 5 )==0 )
    {
      buffer[strlen(buffer)-2] = 0;
      strcpy( file, buffer + 5 );
      if( !flag ) flag = 1;
      continue;
    }
    if( !isdigit( *buffer ) )
    {
      if( flag ) flag = 2;
      write( ",,," );
      write( buffer );
      continue;
    }
    write( file );
    write( "," );
    buffer[7] = 0;
    write( buffer );
    write( ",," );
    write( buffer+8 );
  }
  if( flag==2 )
    write( ",,,*** Please run GREP using -n option! ***\n" );
  exit( 0 );
}
