 * File......: MOUSFUNC.PRG
 * Author....: Leo Letendre CIS: 73607,233
 * Date......: 6/23/93
 * Revision..: V2.0           // Update to Clipper 5.2 Release
 * Log file..: 
 * 
 * Copyright 1991-1993 Leo J. Letendre
 * Permission is automatically granted to those who wish to use these
 * routines in any application. Permission is not granted to anyone wishing
 * to include these in any third party shareware or commercial library.
 *
 *
 * Modification history:
 * ---------------------
 *
 *  V1.01   1/10/93      Added header

STATIC GMouseSpot:={}    // List of general hot spots
STATIC GFree_spot:=0     // Next location for general hot spot 0 = none left

STATIC nDefSleep:=0.2    // Default sleep time between sucessive mouse events
STATIC lDefRelease:=.F.  // Default release action for mouse events
STATIC nDblClkTime:=0.5  // Default double click time window

STATIC lMInkeyUseMouse:=.T. // Use mouse in Minkey

*+
FUNCTION AddHotSpot(aMouseSpot,nFreeSpot,aDef)
*
* This routine and all accompaning database structures are 
* Copyright (C) 1991 Leo J. Letendre. All rights reserved.
*
* Purpose: add a hot spot to the given array
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     7/7/91    LJL       Initial Version
*
* Calling parameters: aMouseSpot - an array of hot spots to receive the new one
*                     nFreeSpot - the next free spot - passed by reference
*                     aDef - an array defining the hot spot - See caller for
*                            structure
* Returns: the ID number of the hot spot
*
* Notes: None
*-
* LOCAL variables: 
LOCAL nNextSpot, lWorking, i

*
* Entry Point
*

IF (nFreeSpot=0)
	AADD(aMouseSpot,{})
	nNextSpot=LEN(aMouseSpot)
ELSE
	nNextSpot=nFreeSpot
	i=nNextSpot+1
	nFreeSpot=0
	lWorking=.T.
* find next free location
	DO WHILE i<LEN(aMouseSpot).AND.lWorking
		IF aMouseSpot[i,1]=-1
			lWorking=.F.
			nFreeSpot=i
		ENDIF
		i++
	ENDDO

ENDIF

* Now add the coordinates

aMouseSpot[nNextSpot]=aDef

RETURN nNextSpot

* End of AddHotSpot

******
*
* RemHotSpot()
*
* This subroutine clears the specified Hotspot 
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     10/24/91  LJ Letendre   Initial Version - taken from
*                                           mousbrow.prg
*
* Calling Parameters : nID - which is the ID number of the region to remove
*                            from active duty. It is given by AddHotSpot.
*                      aHotSpot - The array of hot spots.
*                      nFreeSpot - The next free spot in the array of hot spots
*
* Returns: Returns the next free hot spot
*
FUNCTION RemHotSpot(nID, aHotSpot, nFreeSpot)
*
* Local variables
*
LOCAL i, working

* Set values to those off of the screen and no code block

IF nId<=LEN(aHotSpot)
	aHotSpot[nID,1]:=aHotSpot[nID,2]:=aHotSpot[nID,3]:=aHotSpot[nID,4]:=-1
	aHotSpot[nID,5]=NIL
	IF nID<nFreeSpot.OR.nFreeSpot=0
		nFreeSpot=nID
	ENDIF

* Shrink array if possible

	i=LEN(aHotSpot)
	working=.T.
	DO WHILE i>=nFreeSpot.AND.working
		working=aHotSpot[i,1]<0
		i--
	ENDDO

	ASIZE(aHotSpot,i+1)
ENDIF


RETURN nFreeSpot

* End of RemHotSpot


*****
*
*  MDefSleep()
*
* This routine sets the default minimum time between servicing the mouse
* button when on a "hot spot". Useful for slowing things down.
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     10/25/91  LJ Letendre   Initial Version - Taken from
*                                           mousbrow.prg changed to be
*                                           applicable to all mouse events
*
/*  $DOC$
 *  $FUNCNAME$
 *     MDEFSLEEP()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Set default sleep time between servicing hot spots
 *  $SYNTAX$
 *     MDEFSLEEP(<nDefSleep>) -> <nCurSleep>
 *  $ARGUMENTS$
 *     <nSleepDef> - Number of seconds for the default interval.
 *                 If absent no change made.
 *  $RETURNS$
 *     <nCurSleep> which is the current setting
 *  $DESCRIPTION$
 *     This routine sets the default time between successive servicing of
 *     the same hot spot within any of the Mouse Interface routines. This
 *     time is used to prevent the many more calls to the servicing routine
 *     when the user sits on the mouse button. The default value is set
 *     to 0.2 seconds at start up. The value can be overridden when each
 *     hot spot is set up.
 *  $EXAMPLES$
 *     MDefSleep(0.3)   // Sets the default sleep to 0.3 seconds
 *  $SEEALSO$
 *     MDEFRELEASE()
 *  $INCLUDE$
 *     
 *  $END$
 */
*
FUNCTION MDefSleep(nSleepDef)

* Local Parameters
LOCAL oldsetting:=nDefSleep

* set new value if necessary

IF nSleepDef!=NIL
	nDefSleep=nSleepDef
ENDIF

RETURN oldsetting

* End of MDefSleep

*****
*
*  MDefRelease()
*
* This routine sets the default logical value controling if the program
* waits for the release of the mouse button before continuing when it is in
* a "Hot Spot"
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     10/25/91  LJ Letendre   Initial Version - Taken from 
*                                           mousbrow.prg for general use
*
/*  $DOC$
 *  $FUNCNAME$
 *     MDEFRELEASE()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Sets default for waiting for mouse release in Hot Spots
 *  $SYNTAX$
 *     MDEFRELEASE(<lDefaultRel>) -> <lCurrentRel>
 *  $ARGUMENTS$
 *     <lReleaseDef> - If present will set the default action on releasing 
 *                   the mouse button before continuing when servicing a 
 *                   "Hot Spot". If absent no change made. .T. causes
 *                   a wait for release.
 *  $RETURNS$
 *     <lCurrentRel> - The current value.
 *  $DESCRIPTION$
 *     This routine sets the default for whether or not a hot spot waits
 *     for the mouse button to be released before returning control to the
 *     GET/READ system. Its value can be overridden when each hot spot is
 *     created.
 *
 *     The default release action is not to require a release (= .F.)
 *  $EXAMPLES$
 *     MDefRelease(.T.)  // Make all hot spots wait for button release
 *  $SEEALSO$
 *     MDEFSLEEP()
 *  $INCLUDE$
 *     
 *  $END$
 */
* Calling Paramters: *
* Returns: current setting
*
*
* Note: 
*
*
FUNCTION MDefRelease(lReleaseDef)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=lDefRelease

IF lReleaseDef!=NIL
	lDefRelease=lReleaseDef
ENDIF

RETURN oldsetting

* End of MDefRelease

*****
*
* MDoubleClk
*
* Purpose: set the mouse double click interval
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     6/2/91    LJL       Initial Version - Use as a generic 
*                                       service routine
*
/*  $DOC$
 *  $FUNCNAME$
 *     MDOUBLECLK()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Set the mouse double click interval
 *  $SYNTAX$
 *     MDoubleCld(<nDblTime> -> <nOrigTime>
 *  $ARGUMENTS$
 *     <nDblTime> - The maximum time to wait for a double click.
 *               If no value is passed, the current setting is returned.
 *  $RETURNS$
 *     <nOrigTime> - The current setting.
 *  $DESCRIPTION$
 *     This routine sets the default time for detecting double clicks within
 *     the mouse interface system. The default value is 0.5 seconds.
 *
 *     Note: this does not affect the value in FT_MDBLCLK() nor does it
 *     have any affect on any code you may add on top of the present system.
 *  $EXAMPLES$
 *     MDoubleCld(0.65)  // set the double click to 0.65 seconds.
 *  $SEEALSO$
 *     
 *  $INCLUDE$
 *     
 *  $END$
 */
*

FUNCTION MDoubleClk(nDblTime)

* Local Parameters
LOCAL oldsetting

*Save old value
oldsetting=nDblClkTime

IF nDblTime!=NIL
	nDblClkTime=nDblTime
ENDIF

RETURN oldsetting

* End of MDoubleClk

*****
*
* MInkey()
*
* Purpose: Combined keyboard and mouse input wait state
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     3/1/92    LJL       Initial Version
*         V1.01     5/5/92    LJL       Added test for the presence of the
*                                       mouse.
/*  $DOC$
 *  $FUNCNAME$
 *     MInkey()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Combined key and mouse input wait state
 *  $SYNTAX$
 *     MInkey(<nSeconds>) -> <nInput>
 *  $ARGUMENTS$
 *     <nSeconds> - The maximum time (in seconds) to wait for input.
 *               If zero is passed, an infinite wait is executed.
 *               If nothing is passed, no waiting occurs.
 *  $RETURNS$
 *     <nInput> - The inkey code when a key has been struck. If the mouse
 *                button has been hit, then 1000 plus the mouse button value 
 *                is returned. The mouse button values are the sum of the bits
 *                with bit 0=left, 1=right and 2=middle. Thus left and right
 *                would give a value of 1003 (= 1000+3).
 *  $DESCRIPTION$
 *     This routine impliments an Inkey type wait state with the option
 *     of having the mouse interupt the wait.
 *
 *     This routine waits until the mouse buttons are released prior to
 *     starting its clock.
 *
 *     This routine mimics CLIPPER's InKey() and is therefore not a
 *     true wait state.
 *
 *     NOTE: This routine does not put the mouse cursor on the screen. If you 
 *     want it one you must do it yourself. However, the cursor need not be
 *     visible for the mouse to terminate this routine.
 *
 *  $EXAMPLES$
 *     MInkey(3)  // Wait for input for 3 seconds.
 *  $SEEALSO$
 *     MInkeyUseMouse()
 *  $INCLUDE$
 *     
 *  $END$
 */

FUNCTION MInkey(nSeconds)

LOCAL nMouseInput:=0, nKeyInput:=0
LOCAL nTime, nResult:=0
STATIC lMouseTested:=.F. // Has the presence of the mouse been determine for
                         // Minkey()
STATIC lMousePresent

* Check to see if the mouse is present the first time through

IF !lMouseTested .OR. !lMInkeyUseMouse
	lMousePresent=FT_MINIT()
ENDIF

* Mouse is present so use it

IF lMousePresent .AND. lMInkeyUseMouse

* wait for button to be released

	DO WHILE FT_MBUTREL(1)!=0
	ENDDO

* Will separate the two cases of <nSeconds> values to give the best response
* for the more typical call

	IF nSeconds=NIL.OR.nSeconds!=0
		IF nSeconds=NIL
			nSeconds=0
		ENDIF

* Get the current time
		nTime=SECONDS()

* correct for running at midnight
		IF nTime+nSeconds>86399
			nTime-=86399
	     ENDIF
* Now get input

		DO WHILE (nKeyInput:=Inkey())==0.AND.(nMouseInput:=FT_MGETPOS())==0;
			.AND. (SECONDS()-nTime)<nSeconds
		ENDDO
	ELSE
* Value of 0 given so we wait for input
		DO WHILE (nKeyInput:=Inkey())==0.AND.(nMouseInput:=FT_MGETPOS())==0
		ENDDO

	ENDIF

* No mouse present

ELSE
	nKeyInput=InKey(nSeconds)
ENDIF

* Now determine the value to return
IF nMouseInput>0
	nResult=1000+nMouseInput
ELSEIF nKeyInput>0
	nResult=nKeyInput
ENDIF

RETURN nResult



*****
*
* MInkeyIgnoreM()
*
* Purpose: Cause Minkey to ignore the presence of the mouse
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     5/5/92    LJL       Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     MInkeyUseMouse()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Make Minkey ignore mouse
 *  $SYNTAX$
 *     MInkeyUseMouse(<lUse>) -> <lState>
 *  $ARGUMENTS$
 *     <lUse> - Logical indicating desire to ignore mouse.
 *              .F. causes Minkey() to ignore mouse.
 *              If nothing is passed, the current state is returned.
 *  $RETURNS$
 *     <lState> - The state of MInkey()s use of the mouse prior to calling.
 *
 *  $DESCRIPTION$
 *     This routine lets you ignore the mouse if one is present when using 
 *     MInkey 
 *
 *  $EXAMPLES$
 *     MInkeyUseMouse(.F.)  // Turn of the use of the mouse
 *  $SEEALSO$
 *     MInkey()
 *  $INCLUDE$
 *     
 *  $END$
 */

FUNCTION MInkeyUseMouse(lUse)

LOCAL lCurState:=lMinkeyUseMouse

IF VALTYPE(lUse)='L'
	lMinkeyUseMouse=lUse
ENDIF

RETURN lCurState

* End of MInkeyUseMouse


******
*
* FUNCTION sleep(nSeconds,nInitial)
*
* Purpose: wait for a given period of time
*
* Modification History:
*        Version    Date      Who       Notes
*         V1.00     4/20/91   LJL       Initial Version
*         V1.01     8/27/91   LJL       Actually got it to work over midnight
*
* Calling parameters: nSeconds - Input the number of seconds to waste
*                     nInitial - Optional input - the clock value (from
*                                a call to SECONDS()) from which the
*                                nSeconds seconds are to elapse. Useful
*                                for setting a minimum time between the
*                                start of events which could take a variable
*                                amount of time.
*
* Returns: NIL
*
* Notes: This gives the best guess based upon speed of the machine.
*        Don't use for more than 24 hours
*
FUNCTION sleep(nSeconds,nInitial)
*
* LOCAL variables: none

*
* Entry Point
*
IF nInitial=NIL.OR.VALTYPE(nInitial)!="N"
	nInitial=SECONDS()
ENDIF

* correct for running at midnight

IF nInitial+nSeconds>86399
	nInitial=nInitial-86399
*  Wait until midnight
     DO WHILE SECONDS()>100  // no problem with a _very_ slow machine
     ENDDO
ENDIF


nSeconds+=ninitial

DO WHILE (SECONDS()<nSeconds)

ENDDO

RETURN NIL

* End of sleep

******
*
* GHotSpot()
*
* This function allows the caller to define a location on the screen which
* if clicked on with the mouse will cause an action to take place in any of 
* the mouse systems.
*
* Modification History:
*        Version    Date      Who         Notes
*         V1.00     5/25/92  LJL         Initial Version
* 
/*  $DOC$
 *  $FUNCNAME$
 *     GHOTSPOT()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     Defines Mouse Hot spots for all mouse subsystems
 *  $SYNTAX$
 *     GHotSpot( <nTopRow>, <nLeftCol>, <nBotRow>, <nRightCol>, <bAction>, ;
 *                <nButton>, <nSleep>, <lRelease>) -> <nId>
 *
 *  $ARGUMENTS$
 *     <nTopRow> - the top row of the area 
 *     <nLeftCol> - the left column of the area
 *     <nBotRow> - the bottom row of the area
 *     <nRightCol> - the right column of the area 
 *     <bAction> - Code block which will be executed when
 *              mouse is clicked in the area
 *     <nButton> - Optional button number for action to occur. IF
 *              equal to 0 or NIL, the action occurs on 
 *              clicking anybutton (the code block can decide 
 *              what to do with based upon the button). If equal
 *              to 1, code block executes only on left click,
 *              if equal to 2 only on right click and if equal
 *              to 4(?) then the middle button.
 *     <nSleep> - Optional value of a minimum time (in seconds) to
 *              wait between servicing multiple button presses. 
 *              Prevents routine from operating too quickly and 
 *              reading the press of a button multiple times 
 *              when not intended. If =NIL then the default value
 *              is used (see MDefSleep()).
 *     <lRelease> - Optional Logical Value. If set to .T. the
 *              servicing routine will pause after the completion
 *              of bAction for the release of the mouse button(s)
 *              Useful for guaranteeing no multiple hits on
 *              an area. If =NIL then the default is used (see
 *              MDefRelease())
 *     
 *  $RETURNS$
 *     nId which is an ID to be used to remove the area with a call
 *              to RemHotSpot(nId)
 *  $DESCRIPTION$
 *     This routine defines a hot spot for all mouse subsytems, which will 
 *     be activated if the user clicks the mouse in the defined area. The 
 *     action which is executed is defined by the code block bAction which 
 *     is called with five arguments:
 *
 *                 nButNum: the number of the button pressed with
 *                          1=left, 2=right, 4=middle(?).
 *                 nRow: The row that the mouse cursor was in when it
 *                       was clicked
 *                 nCol: The column that the mouse cursor was in when it
 *                       was clicked
 *                 nTime: The time returned by SECOND() shortly after the
 *                       button was clicked.
 *                 nId:   The hot spot Id number.
 *
 *        Thus the code block should have a form similar to the following
 *        if one wishes to use the button/cursor information:
 *
 *      {|nButNum, nRow, nCol, nTime, nId| MyFunc(NButNum,nRow,nCol,nTime,nId)}
 *
 *  $EXAMPLES$
 *      GHotSpot(1,10,1,20,{|| ShowHelp()},1,,.T.) // hot spot shows help
 *  $SEEALSO$
 *      GCOOLSPOT() GWARMSPOT() GREMHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*-

FUNCTION GHotSpot( nTopRow, nLeftCol, nBotRow, nRightCol, bAction, nButton,;
				 nSleep, lRelease)
*
* Local variables
*

* Entry point

* Now add the coordinates

RETURN AddHotSpot(GMouseSpot,@Gfree_spot,;
                 {nTopRow, nLeftCol, nBotRow, nRightCol, bAction,;
                  IIF(nSleep=NIL,MDefSleep(),nSleep),;
                  IIF(lRelease=NIL,MDefRelease(),lRelease),;
                  IIF(nButton=NIL,0,nButton),.T.})

* End of GHotSpot

******
*
* GRemHotSpot()
*
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/25/92  LJL           Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     GREMHOTSPOT()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     This subroutine clears the specified Hotspot 
 *  $SYNTAX$
 *     GRemHotSpot( <nId> ) -> NIL
 *  $ARGUMENTS$
 *     <nID> - the ID number of the region to remove from active duty. 
 *             It is given by GHotSpot.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine removes a mouse hot spot from the all mouse subsystem
 *      list of active hot spots.
 *  $EXAMPLES$
 *      GRemHotSpot(nHelpId)
 *  $SEEALSO$
 *      GHOTSPOT() GCOOLSPOT() GWARMSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*
* Returns: NIL
*
FUNCTION GRemHotSpot(nID)
*
* Local variables
*

* Call service routine

GFree_Spot=RemHotSpot(nId, GMouseSpot, GFree_Spot)

RETURN NIL

* End of GRemHotSpot

******
*
* GCoolSpot()
*
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     4/25/92   LJ Letendre   Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     GCOOLSPOT()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     This subroutine deactivates the specified General HotSpot
 *  $SYNTAX$
 *     GCOOLSPOT(<nId>) -> NIL
 *  $ARGUMENTS$
 *      <nID> - the ID number of the General Hot Spot to remove from active 
 *           duty. It is given by GHotSpot.
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine deactivates the specified hot spot without removing it
 *      from the list of hot spots. It can later be reactivated with
 *      GWarmSpot()
 *  $EXAMPLES$
 *      GCoolSpot(nHelpId)   // Cool off the help hot spot
 *  $SEEALSO$
 *      GWARMSPOT() GREMHOTSPOT() GHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*-

FUNCTION GCoolSpot(nID)
*
* Local variables
*

GMouseSpot[nid,9]=.F.

RETURN NIL

* End of GCoolSpot

******
*
* GWarmSpot()
*
* This subroutine reactivates the specified HotSpot which was deactivated
* by GCoolSpot
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/25/92   LJ Letendre   Initial Version
*
/*  $DOC$
 *  $FUNCNAME$
 *     GWARMSPOT()
 *  $CATEGORY$
 *     General
 *  $ONELINER$
 *     This subroutine reactivates the specified General Hot Spot
 *  $SYNTAX$
 *     GWARMSPOT(<nId>) -> NIL
 *  $ARGUMENTS$
 *      <nID> - the ID number of the General Hot Spot to return to active duty. 
 *           It is given by GHotSpot and should have been deactivated by
 *           GCoolSpot()
 *  $RETURNS$
 *      NIL
 *  $DESCRIPTION$
 *      This routine reactivates the specified General hot spot after having 
 *      been deactivated by GCoolSpot(). 
 *  $EXAMPLES$
 *      GWarmSpot(nHelpId)   // Turn the help hot spot back on
 *  $SEEALSO$
 *      GCOOLSPOT() GREMHOTSPOT() GHOTSPOT()
 *  $INCLUDE$
 *
 *  $END$
 */
*
FUNCTION GWarmSpot(nID)
*
* Local variables
*

GMouseSpot[nId,9]=.T.

RETURN NIL

* End of GWarmSpot




******
*
* GeneralSpot()
*
* This subroutine checks for and executes any general hot spots
*
* Modification History:
*        Version    Date      Who           Notes
*         V1.00     5/25/92   LJ Letendre   Initial Version
*
* Calling Parameters:
*                    nButton - Button which was hit - reserved for future
*                    nRow - Row coordinate of mouse pointer when button hit
*                    nCol - Col coordinate of mouse pointer
*                    nTime - The system time that the button was clicked
*
* Returns: working which indicates if more work should be done because
*          no match was found within the general hot spot list
*

FUNCTION GeneralSpot(nButton, nRow, nCol, nTime)

*
* Local variables
*
LOCAL j
LOCAL working:=.T.

* First check to see if any action hot spots were clicked on

j=LEN(GMouseSpot)
DO WHILE (j>=1.AND.working)

* Check coordinates
	working=.NOT.(GMouseSpot[j,9].AND.;
				nRow>=GMouseSpot[j,1].AND.nRow<=GMouseSpot[j,3].AND.;
				nCol>=GMouseSpot[j,2].AND.nCol<=GMouseSpot[j,4].AND.;
				(GMouseSpot[j,8]=0.OR.GMouseSpot[j,8]=nButton))

* If we have a match then execute the code block

	IF .NOT.working

* do the request

*		FT_MHIDECRS()
		EVAL(GMouseSpot[j,5],nButton,nRow,nCol,nTime,j)
*		FT_MSHOWCRS()

* Wait for release if requested
		IF GMouseSpot[j,7]
			DO WHILE FT_MBUTREL(0)!=0
			ENDDO
		ENDIF

* Pause for the minimum amount of time
		IF GMouseSpot[j,6]>0
			sleep(GMouseSpot[j,6],nTime)
		ENDIF

	ENDIF
* decrement counter
	j--

ENDDO

RETURN working

* End of GeneralSpot

