; Tiny file viewer - by Tylisha C. Andersen

.model tiny
.186
.code
org 100h

start:      mov   sp, 10240         ; set new stack position

            mov   ah, 4Ah           ; shrink memory to 10K
            mov   bx, 10240/16
            int   21h

            mov   ah, 48h           ; get total memory free
            mov   bx, -1
            int   21h
            mov   ah, 48h           ; allocate all free memory
            int   21h

            push  ax                ; save first line segment
            mov   cx, 5             ; cx = 5

            mov   bp, ax            ; bp = maximum segment
addloop:    add   bp, cx            ; must be multiple of 5
            sub   bx, cx
            jnc   addloop

            xor   si, si            ; si = 0

clearloop:  mov   ds, ax            ; set all lines to a null string
            mov   [si], si
            add   ax, cx
            cmp   ax, bp            ; loop while less than max
            jb    clearloop

;-----------------------------------------------------------

            push  cs                ; ds = cs
            pop   ds

            mov   di, 81h           ; find first non-space
            mov   cl, [di-1]        ; cx = command line length
            inc   cx
            mov   al, 20h
            repe  scasb
            lea   dx, [di-1]        ; dx = pointer to filename

            repne scasb             ; find next space, or end of line
            mov   [di-1], ch        ; add the null terminator

;-----------------------------------------------------------

            mov   ax, 3D00h         ; open the file
            int   21h
            jc    exit              ; exit if error

            xchg  bx, ax            ; bx = handle
            pop   es                ; es = segment of first line
            push  es

            mov   si, 8192          ; init buffer variables
            mov   dx, si

lineloop:   xor   di, di            ; es:di = line
            mov   cl, 79            ; 79 max. chars

charloop:   cmp   si, dx            ; if not to end, then load char
            jb    charload

            cmp   si, 8192          ; buffer not full = EOF
            jb    chardone          ; carry flag set if we jump

            push  cx                ; push cx on stack
            mov   ah, 3Fh           ; try to read in next buffer
            mov   cx, si
            mov   dx, offset buffer
            int   21h
            pop   cx                ; restore cx
            jc    chardone          ; carry = EOF

            xchg  dx, ax            ; set end position
            xor   si, si            ; set buffer position

charload:   mov   al, buffer[si]    ; load byte
            inc   si                ; increment buffer position

            cmp   al, 13            ; cr = done with line
            je    chardone
            cmp   al, 10            ; ignore line feeds
            je    charloop
            jcxz  charloop          ; maxed out, don't store
            stosb                   ; store char
            dec   cx                ; decrement maximum
            jmp   charloop          ; loop back

chardone:   mov   al, 0             ; make string null-terminated
            stosb                   ;  (doesn't affect flags)
            jc    linedone          ; jump if EOF

            mov   ax, es            ; next line
            add   ax, 5
            mov   es, ax
            cmp   ax, bp            ; too many lines?
            jb    lineloop          ; loop if not

;-----------------------------------------------------------

linedone:   mov   di, es            ; di = segment of last line
            mov   ah, 3Eh           ; close the file
            int   21h

            mov   ax, 3             ; clear the screen
            int   10h

            pop   si                ; si = min screen position
            sub   di, 24*5          ; di = max screen position
            jmp   k_home1           ; set position to zero

;---------------------------------------------------------------------
; key processing starts here
;---------------------------------------------------------------------

keyloop:    xor   ah, ah            ; wait for a key
            int   16h
            mov   cl, ah            ; cx = key scan code
            xor   ch, ch
            loop  k_home            ; quit if ESC

;---------------------------------------------------------------------

            mov   ax, 3             ; clear the screen
            int   10h
exit:       int   20h               ; exit to DOS

;-----------------------------------------------------------

k_home:     sub   cx, 46h           ; key HOME?
            jnz   k_up

k_home1:    mov   bp, si            ; move to top

;-----------------------------------------------------------

k_up:       loop  k_pgup            ; key UP?

            sub   bp, 5             ; move up 1 line
k_up1:      cmp   bp, si            ; hit the top?
            jb    k_home1

;-----------------------------------------------------------

k_pgup:     loop  k_end             ; key PGUP?

            sub   bp, 25*5          ; move up 25 lines
            jmp   k_up1             ; hit the top?

;-----------------------------------------------------------

k_end:      sub   cx, 6             ; key END?
            jnz   k_down

k_end1:     mov   bp, di            ; move to end
            jmp   k_up1             ; at the top?

;-----------------------------------------------------------

k_down:     loop  k_pgdn            ; key DOWN?

            add   bp, 5             ; move down 1 line
k_down1:    cmp   bp, di            ; hit the bottom?
            ja    k_end1

;-----------------------------------------------------------

k_pgdn:     loop  redraw            ; key PGDN?

            add   bp, 25*5          ; move down 25 lines
            jmp   k_down1           ; hit the bottom?

;-----------------------------------------------------------

redraw:     pusha                   ; save all registers
            push  ds

            push  0B800h            ; es = video memory
            pop   es

            mov   ah, 1Fh           ; bright white on blue
            xor   di, di            ; start at line 0

drawline:   mov   ds, bp            ; ds:si = string
            xor   si, si
            mov   cx, 81            ; 80 chars

drawchar:   dec   cx                ; decrement count
            lodsb                   ; get a character
drawnone:   stosw                   ; draw it on the screen
            or    al, al            ; loop while nonzero
            jnz   drawchar
            loop  drawnone          ; loop until end of line

            add   bp, 5             ; next line
            cmp   di, 4000          ; done all 25 lines?
            jb    drawline          ; loop if not

            pop   ds                ; restore registers
            popa
            jmp   keyloop           ; jump to key loop

;---------------------------------------------------------------------

buffer      db 8192 dup(?)          ; disk buffer

end start
