; TinyAtomz V1.03 -- (C) 1997 QuickCrash
; Not very structured, but it's small and it works well.

.MODEL SMALL
.CODE
.386
 ORG 100h

START:
       mov   ah,9
       mov   dx,offset Atomz
       int   21h
       xor   ax,ax                           ; Check mouse driver is installed
       int   33h
       or    ax,ax
       jnz   MouseyFound                     ; Otherwise, quit

       mov   ah,9
       mov   dx,offset Nomous
       int   21h

       retn                                  ; No space for fancy error messages
MouseyFound:
       mov   ah,9
       mov   dx,offset Players
       int   21h

WrongSize:
       xor   ah,ah
       int   16h
       cmp   al,'2'
       jb    WrongSize
       cmp   al,'4'
       ja    WrongSize

       sub   al,48
       mov   [MaxPlay],al

       push  es
       mov   ax,3508h                        ; Get int 8 vector
       int   21h
       mov   word ptr [cs:OldInt8],bx
       mov   word ptr [cs:OldInt8+2],es
       pop   es

       mov   si,offset Sprite                ; This is my little
       mov   di,offset Bod                   ; run-length decoder
       pusha
       xor   ah,ah
RL000:
       lodsb
       cmp   al,0FFh
       jz    RL002
       push  ax
       and   al,128
       or    al,al
       pop   ax
       jnz   RL001
       stosb
       jmp   short RL000
RL001:
       and   al,127
       mov   cx,ax
       lodsb
       rep   stosb
       jmp   short RL000        
RL002:
       popa
       mov   bx,offset Transx            ; Translation -> Original colours
       xchg  si,di
       mov   di,offset Nod
       mov   al,11


       mov   cx,4
RL003:
       pusha
       mov   cx,2880
RL004:
       lodsb
       xlat
       stosb
       loop  RL004
       mov   [TempDI],di
       popa
       mov   di,[TempDI]
       push  ax
       xlat
       mov   byte ptr [Transx],al
       pop   ax
       inc   al
       loop  RL003

       mov   ax,0013h                    ; Switch to mode 13h
       int   10h

       mov   dx,offset ColourRotate      ; Set new int8 handler
       mov   ax,2508h
       int   21h

       mov   si,offset Cod               ; Start of un-runlength-compressed
                                         ; logo

       mov   di,2495                     ; Start offset of logo on screen
       mov   ax,0A000h
       mov   es,ax
       xor   dx,dx

ProcessOuter:
       mov   bl,128
       lodsb
       cmp   di,58210        
       ja    GetOut
ProcessInner:
       push  ax
       and   al,bl
       or    al,al
       jnz   NotBlank
       xor   al,al
InnerBit:
       stosb
       inc   dx
       cmp   dx,52
       jnz   NextBit
       xor   dx,dx
       add   di,268
NextBit:
       pop   ax
       shr   bl,1
       or    bl,bl
       jz    ProcessOuter
       jmp   short ProcessInner
NotBlank:
       mov   al,0F1h
       jmp   short InnerBit
GetOut:
       xor   ax,ax                       ; Display a blank playing grid
       xor   bx,bx
NextClear:
       call  PasteBlock
       inc   bh
       cmp   bh,10
       jnz   NextClear
       xor   bh,bh
       inc   bl
       cmp   bl,8
       jnz   NextClear

       mov   ax,0001h                    ; Show mouse cursor 
       int   33h

       xor   al,al                       ; Colour 0 starts
       call  ColourBar
       jmp   short IntoIdle 

IdleLoop:
       xor   ah,ah
       int   16h
IntoIdle:
       mov   ax,0003h
       int   33h
       or    bx,bx
       jnz   MouseAction
       mov   ah,1
       int   16h
       jz    IntoIdle
       cmp   al,27
       jnz   IdleLoop

GameFinish:
       mov   ax,0003
       int   10h

       mov   dx,word ptr [OldInt8+2]
       mov   ds,dx
       mov   dx,word ptr [cs:OldInt8]
       mov   ax,2508h
       int   21h

       mov   ax,4c00h
       int   21h

ColourRotate:                                   ; HERE
       pusha
       mov   dx,03C8h
       mov   al,0F1h
       out   dx,al
       mov   al,byte ptr [CurCol]
       mov   bl,byte ptr [DirCol]
       cmp   al,62
       jnz   NotHiLimit
       mov   bl,1
       jmp   short NotLimit
NotHiLimit:
       or    al,al
       jnz   NotLimit
       xor   bl,bl
NotLimit:
       mov   [DirCol],bl
       or    bl,bl
       jz    UpIt
       dec   al
       jmp   short FinColRot
UpIt:
       add   al,2
FinColRot:
       mov   [CurCol],al
       inc   dx
       out   dx,al
       out   dx,al
       out   dx,al
       popa
       jmp   dword ptr cs:[OldInt8]

; AL = Colour (0-3)
ColourBar:
       pusha
       push  ax
       mov   ax,2
       int   33h
       pop   ax
       mov   cx,0A000h
       mov   es,cx
       mov   bx,offset ProbCl
       xlat
       mov   ah,al
       mov   cx,ax
       shl   eax,16
       mov   ax,cx
       mov   di,241
       mov   cx,192
LCBar:
       stosd
       add   di,316
       loop  LCBar
       mov   ax,1
       int   33h
       popa
       ret
SkipToIdle:
       pop   ax
       jmp   IntoIdle

MouseAction:
       mov   ax,cx
       mov   cl,48
       div   cl
       shr   cl,1
       cmp   al,9
       ja    IntoIdle
       mov   bh,al
       mov   ax,dx
       div   cl
       cmp   al,7
       ja    IntoIdle
       mov   bl,al
       xor   ah,ah
       mov   al,bl
       mov   cl,10
       mul   cl
       xor   ch,ch
       mov   cl,bh
       add   ax,cx
       xchg  ax,bx
       push  ax
       add   bx,offset Pod
       mov   al,[bx+80]
       mov   cl,byte ptr [CurPlay]
       cmp   al,5
       jz    EmptyGridSquare
       cmp   cl,al
       jnz   SkipToIdle
EmptyGridSquare:
       mov   al,[bx]
       cmp   al,4
       jz    TooBig
       inc   byte ptr [bx]
       mov   byte ptr [bx+80],cl
       inc   al
TooBig:
       mov   bl,al
       pop   ax
       xchg  ax,bx
       mov   ah,[CurPlay]
       call  PasteBlock
       xchg  ax,bx

       push  bx
Backwards:
       mov   ax,0003h
       int   33h
       or    bx,bx
       jz    OutOfThis
       jmp   short Backwards


OutOfThis:
       mov   al,[CurPlay]
       mov   [ExplCol],al
       inc   al
       cmp   al,[MaxPlay]
       jnz   NotAtEnd
       mov   [CheckEm],1
       xor   al,al
NotAtEnd:
       mov   [CurPlay],al
       call  ColourBar
       pop   bx                         ; Get the square location back

       ;jmp   RedrawStart

; Explosion Time
ExplosiveOuter:                 
       mov   [ExpStat],0                ; Set no. explosions zero
       mov   cx,80
       mov   bx,offset Pod
ExplosiveLoop:
       pusha
       mov   dl,[ExplCol]

       mov   ah,[bx+160]
       mov   al,[bx]
       cmp   al,ah
       jb    NextSquare

       inc   [ExpStat]

       xchg  ax,bx
       sub   ax,offset Pod
       push  ax
       add   ax,10
       mov   cl,10
       div   cl
       or    ah,ah
       jz    LeftHandSize
       pop   ax

       push  ax
       add   ax,11
       div   cl
       or    ah,ah
       jz    RightHandSize
       pop   ax
       cmp   ax,10
       jb    TopRow
       cmp   ax,69
       ja    BottomRow

       ; Hmmm, must be a centre square
       xchg  ax,bx
       add   bx,offset Pod

       inc   byte ptr [bx-1]
       inc   byte ptr [bx+1]
       inc   byte ptr [bx+10]
       inc   byte ptr [bx-10]
       mov   byte ptr [bx+80-1],dl
       mov   byte ptr [bx+80+1],dl
       mov   byte ptr [bx+80+10],dl
       mov   byte ptr [bx+80-10],dl
       sub   byte ptr [bx],ah
       jmp   short NextSquare

NextSquare:
       popa
       inc   bx
       loop  ExplosiveLoop

RedrawStart:
       pusha
       mov   cx,80
       mov   si,offset Pod
       xor   bx,bx

RedrawGrid:
       mov   al,byte ptr ds:[si]
       mov   ah,byte ptr ds:[si+80]       
       call  PasteBlock
       inc   bh
       cmp   bh,10
       jnz   NotDrawHi
       xor   bh,bh
       inc   bl
NotDrawHi:
       inc   si
       loop  RedrawGrid

       cmp   [CheckEm],1
       jnz   NotCheckEm

       xor   ch,ch
       mov   cl,[MaxPlay]
       xor   di,di

OtherPlayers:
       mov   dl,cl
       dec   dl
       mov   bx,offset Ood
       push  cx
       mov   cx,80
FindIt:
       cmp   [bx],dl
       jz    OkayFound
       inc   bx
       loop  FindIt
       pop   cx
       jmp   short OkayNext

ExitGame:
       mov   ah,[ExplCol]
       mov   al,4
       xor   bx,bx
       mov   cx,80

LpClr:
       call  PasteBlock

       inc   bh
       cmp   bh,10
       jnz   NotEq
       xor   bh,bh
       inc   bl
NotEq:
       loop  LpClr


       xor   ah,ah
       int   16h
       jmp   GameFinish
OkayFound:
       inc   di
       pop   cx
OkayNext:
       loop  OtherPlayers
       cmp   di,1
       jz    ExitGame
       

NotCheckEm:
       cmp   [ExpStat],0
       jnz   ExplosiveOuter

       mov   cx,80
       mov   si,offset Pod
WipeLoop:
       mov   al,byte ptr ds:[si]
       or    al,al
       jnz   IgnoreWipe
       mov   byte ptr ds:[si+80],5
IgnoreWipe:
       inc   si
       loop  WipeLoop
       popa
       jmp   IntoIdle

TopRow:
       xchg  ax,bx
       add   bx,offset Pod

       inc   byte ptr [bx-1]
       inc   byte ptr [bx+1]
       inc   byte ptr [bx+10]
       mov   byte ptr [bx+80-1],dl
       mov   byte ptr [bx+80+1],dl
       mov   byte ptr [bx+80+10],dl
       sub   byte ptr [bx],ah
       jmp   NextSquare

BottomRow:
       xchg  ax,bx
       add   bx,offset Pod

       inc   byte ptr [bx-1]
       inc   byte ptr [bx+1]
       inc   byte ptr [bx-10]
       mov   byte ptr [bx+80-1],dl
       mov   byte ptr [bx+80+1],dl
       mov   byte ptr [bx+80-10],dl
       sub   byte ptr [bx],ah
       jmp   NextSquare

LeftHandSize:
       pop   ax
       xchg  ax,bx
       xor   al,al
       cmp   bx,70
       jnz   NotBTM
       mov   al,1
NotBTM:
       add   bx,offset Pod
       cmp   ah,2
       jnz   LABR
       or    al,al
       jz    LBR
       inc   byte ptr [bx-10]
       mov   byte ptr [bx+80-10],dl
       jmp   short LeTR        
LBR:
       inc   byte ptr [bx+10]
       mov   byte ptr [bx+80+10],dl
LeTR:
       inc   byte ptr [bx+1]
       mov   byte ptr [bx+80+1],dl
       sub   byte ptr [bx],ah
       jmp   NextSquare
LABR:
       inc   byte ptr [bx-10]
       mov   byte ptr [bx+80-10],dl
       jmp   short LBR

RightHandSize:
       pop   ax
       xchg  ax,bx
       xor   al,al
       cmp   bx,70
       jnz   NotRBTM
       mov   al,1
NotRBTM:
       add   bx,offset Pod
       cmp   ah,2
       jnz   RABR
       or    al,al
       jz    RBR
       inc   byte ptr [bx-10]
       mov   byte ptr [bx+80-10],dl
       jmp   short ReTR        
RBR:
       inc   byte ptr [bx+10]
       mov   byte ptr [bx+80+10],dl
ReTR:
       inc   byte ptr [bx-1]
       mov   byte ptr [bx+80-1],dl
       sub   byte ptr [bx],ah
       jmp   NextSquare
RABR:
       inc   byte ptr [bx-10]
       mov   byte ptr [bx+80-10],dl
       jmp   short RBR
        
; PasteBlock -- Places an icon on the screen
; AH = BLOCKCOL (0-3)
; AL = BLOCKNUM (0-4)
; BH = X
; BL = Y
PasteBlock:
       push  es
       pusha
       cmp   ah,5
       jnz   Not5
       xor   ah,ah
Not5:
       push  ax
       mov   ax,2
       int   33h
       pop   ax
       mov   di,0A000h
       mov   es,di
       xor   di,di
       mov   si,offset Nod
       push  ax
       shr   ax,8
       mov   cx,2880
       mul   cx
       add   si,ax
       pop   ax
       xor   ah,ah
       mov   cx,576
       mul   cx
       add   si,ax
       xor   ah,ah
       mov   al,bl
       mov   cx,7680
       mul   cx
       add   di,ax
       xor   ah,ah
       mov   al,bh
       mov   cx,24
       mul   cx
       add   di,ax
       mov   cx,24
OL:
       push  cx
       mov   cx,6
       rep   movsd
       add   di,296
       pop   cx
       loop  OL
       mov   ax,1
       int   33h
       popa
       pop   es
       ret
        

Atomz   db  ' TinyAtomz V1.03 -- (C) 1997 QuickCrash ',13,10,13,10,'$'
Nomous  db  ' Error : A mouse and correctly installed driver is needed'
        db  ' to play this game',13,10,'$'
Players db  ' How many players (2-4) : $'

OldInt8 dd  0
CurPlay db  0
MaxPlay db  4                           ; MAXPLAY
ExplCol db  0
ExpStat dw  0
CheckEm db  0

TempDI  dw  0
CurCol  db  0
DirCol  db  0
Transx  db  143,18,21,24,25,26,27,7,28,29,30      
Colour  db  9,23,6
ProbCl  db  143,9,23,6
Sprite  db  096h,006h,005h,002h,006h,094h,007h,006h,003h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h
        db  007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h
        db  006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h
        db  002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h
        db  001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h
        db  009h,001h,002h,006h,007h,094h,009h,001h,002h,082h,006h,094h,009h,001h,002h,005h,002h,095h,001h,099h,002h,096h,006h
        db  005h,002h,006h,094h,007h,006h,003h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h
        db  009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h
        db  088h,009h,008h,082h,007h,008h,088h,009h,001h,002h,006h,007h,087h,009h,008h,005h,082h,000h,006h,008h,087h,009h,001h
        db  002h,006h,007h,086h,009h,008h,005h,084h,000h,006h,008h,086h,009h,001h,002h,006h,007h,086h,009h,007h,085h,000h,004h
        db  007h,086h,009h,001h,002h,006h,007h,086h,009h,007h,004h,084h,000h,004h,008h,086h,009h,001h,002h,006h,007h,087h,009h
        db  007h,083h,000h,003h,007h,087h,009h,001h,002h,006h,007h,088h,009h,006h,004h,005h,007h,088h,009h,001h,002h,006h,007h
        db  094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h
        db  007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,082h,006h,094h,009h,001h,002h,005h,002h,095h,001h,099h,002h
        db  096h,006h,005h,002h,006h,094h,007h,006h,003h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h
        db  007h,084h,009h,008h,082h,007h,008h,08Ch,009h,001h,002h,006h,007h,083h,009h,008h,005h,082h,000h,006h,008h,08Bh,009h
        db  001h,002h,006h,007h,082h,009h,008h,005h,084h,000h,006h,008h,08Ah,009h,001h,002h,006h,007h,082h,009h,007h,085h,000h
        db  004h,007h,08Ah,009h,001h,002h,006h,007h,082h,009h,007h,004h,084h,000h,004h,008h,08Ah,009h,001h,002h,006h,007h,083h
        db  009h,007h,083h,000h,003h,007h,08Bh,009h,001h,002h,006h,007h,084h,009h,006h,004h,005h,007h,08Ch,009h,001h,002h,006h
        db  007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,08Ch,009h,006h,004h,005h,007h,084h,009h,001h,002h
        db  006h,007h,08Bh,009h,007h,083h,000h,003h,007h,083h,009h,001h,002h,006h,007h,08Ah,009h,007h,004h,084h,000h,004h,008h
        db  082h,009h,001h,002h,006h,007h,08Ah,009h,007h,085h,000h,004h,007h,082h,009h,001h,002h,006h,007h,08Ah,009h,008h,005h
        db  084h,000h,006h,008h,082h,009h,001h,002h,006h,007h,08Bh,009h,008h,005h,082h,000h,006h,008h,083h,009h,001h,002h,006h
        db  007h,08Ch,009h,008h,082h,007h,008h,084h,009h,001h,002h,006h,007h,094h,009h,001h,002h,082h,006h,094h,009h,001h,002h
        db  005h,002h,095h,001h,099h,002h,096h,006h,005h,002h,006h,094h,007h,006h,003h,002h,006h,007h,094h,009h,001h,002h,006h
        db  007h,088h,009h,008h,082h,007h,008h,088h,009h,001h,002h,006h,007h,087h,009h,008h,005h,082h,000h,006h,008h,087h,009h
        db  001h,002h,006h,007h,086h,009h,008h,005h,084h,000h,006h,008h,086h,009h,001h,002h,006h,007h,086h,009h,007h,085h,000h
        db  004h,007h,086h,009h,001h,002h,006h,007h,086h,009h,007h,004h,084h,000h,004h,008h,086h,009h,001h,002h,006h,007h,087h
        db  009h,007h,083h,000h,003h,007h,087h,009h,001h,002h,006h,007h,088h,009h,006h,004h,005h,007h,088h,009h,001h,002h,006h
        db  007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h
        db  006h,007h,083h,009h,008h,082h,007h,008h,086h,009h,008h,082h,007h,008h,083h,009h,001h,002h,006h,007h,082h,009h,008h
        db  005h,082h,000h,006h,008h,084h,009h,008h,005h,082h,000h,006h,008h,082h,009h,001h,002h,006h,007h,009h,008h,005h,084h
        db  000h,006h,008h,082h,009h,008h,005h,084h,000h,006h,008h,009h,001h,002h,006h,007h,009h,007h,085h,000h,004h,007h,082h
        db  009h,007h,085h,000h,004h,007h,009h,001h,002h,006h,007h,009h,008h,004h,084h,000h,004h,008h,082h,009h,007h,004h,084h
        db  000h,004h,008h,009h,001h,002h,006h,007h,082h,009h,007h,083h,000h,003h,007h,084h,009h,007h,083h,000h,003h,007h,082h
        db  009h,001h,002h,006h,007h,083h,009h,006h,004h,005h,007h,086h,009h,006h,004h,005h,007h,083h,009h,001h,002h,082h,006h
        db  094h,009h,001h,002h,005h,002h,095h,001h,099h,002h,096h,006h,005h,002h,006h,094h,007h,006h,003h,002h,006h,007h,094h
        db  009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,083h,009h,006h,004h,005h,007h,086h,009h,006h,004h,005h,007h
        db  083h,009h,001h,002h,006h,007h,082h,009h,007h,083h,000h,003h,007h,084h,009h,007h,083h,000h,003h,007h,082h,009h,001h
        db  002h,006h,007h,009h,008h,004h,084h,000h,004h,008h,082h,009h,007h,004h,084h,000h,004h,008h,009h,001h,002h,006h,007h
        db  009h,007h,085h,000h,004h,007h,082h,009h,007h,085h,000h,004h,007h,009h,001h,002h,006h,007h,009h,008h,004h,084h,000h
        db  006h,008h,082h,009h,008h,005h,084h,000h,006h,008h,009h,001h,002h,006h,007h,082h,009h,008h,005h,082h,000h,006h,008h
        db  084h,009h,008h,005h,082h,000h,006h,008h,082h,009h,001h,002h,006h,007h,083h,009h,008h,082h,007h,008h,086h,009h,008h
        db  082h,007h,008h,083h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h,001h,002h,006h,007h,094h,009h
        db  001h,002h,006h,007h,083h,009h,008h,082h,007h,008h,086h,009h,008h,082h,007h,008h,083h,009h,001h,002h,006h,007h,082h
        db  009h,008h,005h,082h,000h,006h,008h,084h,009h,008h,005h,082h,000h,006h,008h,082h,009h,001h,002h,006h,007h,009h,008h
        db  004h,084h,000h,006h,008h,082h,009h,008h,005h,084h,000h,006h,008h,009h,001h,002h,006h,007h,009h,007h,085h,000h,004h
        db  007h,082h,009h,007h,085h,000h,004h,007h,009h,001h,002h,006h,007h,009h,008h,004h,084h,000h,004h,008h,082h,009h,007h
        db  004h,084h,000h,004h,008h,009h,001h,002h,006h,007h,082h,009h,007h,083h,000h,003h,007h,084h,009h,007h,083h,000h,003h
        db  007h,082h,009h,001h,002h,006h,007h,083h,009h,006h,004h,005h,007h,086h,009h,006h,004h,005h,007h,083h,009h,001h,002h
        db  082h,006h,094h,009h,001h,002h,005h,002h,095h,001h,099h,002h
Logo    db  082h,000h,003h,081h,080h,085h,000h,07Ch,085h,000h,00Fh,081h,0E0h,084h,000h,001h,081h,0FFh,085h,000h,03Fh,081h,0F8h
        db  084h,000h,003h,081h,0FFh,081h,080h,084h,000h,07Fh,081h,0FCh,084h,000h,007h,081h,0FFh,081h,0C0h,084h,000h,07Fh,081h
        db  0FCh,084h,000h,00Fh,081h,0FFh,081h,0E0h,084h,000h,081h,0FFh,081h,0FEh,084h,000h,01Fh,081h,0FFh,081h,0F0h,083h,000h
        db  001h,081h,0FEh,081h,0FFh,084h,000h,01Fh,081h,0C7h,081h,0F0h,083h,000h,003h,082h,0FFh,081h,080h,083h,000h,03Fh,081h
        db  0FFh,081h,0F8h,083h,000h,007h,082h,0FFh,081h,0C0h,083h,000h,07Fh,081h,0FFh,081h,0FCh,083h,000h,007h,082h,0FFh,081h
        db  0C0h,083h,000h,082h,0FFh,081h,0FEh,083h,000h,00Fh,082h,0FFh,081h,0E0h,082h,000h,001h,081h,0FFh,081h,081h,081h,0FFh
        db  083h,000h,01Fh,081h,0F0h,01Fh,081h,0F0h,082h,000h,001h,081h,0FEh,000h,081h,0FFh,083h,000h,00Fh,081h,0E0h,00Fh,081h
        db  0E0h,083h,000h,07Ch,000h,07Ch,0CBh,000h,03Fh,081h,0FFh,081h,0F0h,083h,000h,007h,082h,0FFh,081h,080h,083h,000h,082h
        db  0FFh,081h,0FCh,083h,000h,00Fh,082h,0FFh,081h,0C0h,083h,000h,082h,0FFh,081h,0FCh,083h,000h,00Fh,082h,0FFh,081h,0C0h
        db  083h,000h,07Fh,081h,0FFh,081h,0F8h,083h,000h,001h,082h,0FFh,084h,000h,001h,081h,0FFh,085h,000h,01Fh,081h,0E0h,084h
        db  000h,001h,081h,0FEh,085h,000h,01Fh,081h,0E0h,084h,000h,001h,081h,0FEh,085h,000h,01Fh,081h,0E0h,084h,000h,001h,081h
        db  0FEh,085h,000h,01Fh,081h,0E0h,084h,000h,001h,081h,0FEh,085h,000h,01Fh,081h,0E0h,084h,000h,001h,081h,0FEh,085h,000h
        db  01Fh,081h,0E0h,084h,000h,001h,081h,0FEh,085h,000h,01Fh,081h,0E0h,084h,000h,001h,081h,0FEh,085h,000h,01Fh,081h,0E0h
        db  085h,000h,081h,0FCh,085h,000h,007h,081h,080h,0CCh,000h,00Fh,081h,0F0h,084h,000h,003h,081h,0FFh,081h,0C0h,084h,000h
        db  07Fh,081h,0FEh,084h,000h,00Fh,081h,0FFh,081h,0F0h,083h,000h,001h,082h,0FFh,081h,080h,083h,000h,03Fh,081h,0FFh,081h
        db  0FCh,083h,000h,007h,082h,0FFh,081h,0E0h,083h,000h,081h,0FFh,081h,0C1h,081h,0FFh,083h,000h,00Fh,081h,0F8h,00Fh,081h
        db  0F0h,083h,000h,081h,0FFh,000h,081h,0FFh,081h,080h,082h,000h,01Fh,081h,0E0h,007h,081h,0F8h,082h,000h,001h,081h,0FEh
        db  000h,07Fh,081h,080h,082h,000h,01Fh,081h,0E0h,007h,081h,0F8h,082h,000h,001h,081h,0FEh,000h,07Fh,081h,080h,082h,000h
        db  01Fh,081h,0E0h,007h,081h,0F8h,082h,000h,001h,081h,0FEh,000h,07Fh,081h,080h,082h,000h,01Fh,081h,0E0h,007h,081h,0F8h
        db  083h,000h,081h,0FFh,000h,081h,0FFh,083h,000h,00Fh,081h,0F0h,00Fh,081h,0F0h,083h,000h,081h,0FFh,081h,081h,081h,0FFh
        db  083h,000h,007h,082h,0FFh,081h,0E0h,083h,000h,03Fh,081h,0FFh,081h,0FCh,083h,000h,001h,082h,0FFh,081h,080h,083h,000h
        db  00Fh,081h,0FFh,081h,0F0h,084h,000h,07Fh,081h,0FEh,084h,000h,003h,081h,0FFh,081h,0C0h,084h,000h,00Fh,081h,0F0h,0C5h
        db  000h,07Eh,001h,081h,0F8h,083h,000h,00Fh,081h,0F0h,03Fh,081h,0C0h,082h,000h,001h,081h,0FFh,081h,087h,081h,0FEh,083h
        db  000h,03Fh,081h,0F8h,07Fh,081h,0F0h,082h,000h,003h,081h,0FFh,081h,08Fh,081h,0FFh,083h,000h,03Fh,081h,0FCh,081h,0FFh
        db  081h,0F0h,082h,000h,003h,081h,0FFh,081h,0CFh,081h,0FFh,083h,000h,03Fh,081h,0FCh,081h,0FFh,081h,0F0h,082h,000h,003h
        db  083h,0FFh,083h,000h,03Fh,082h,0FFh,081h,0F0h,082h,000h,003h,083h,0FFh,083h,000h,03Fh,082h,0FFh,081h,0F0h,082h,000h
        db  003h,083h,0FFh,083h,000h,03Fh,082h,0FFh,081h,0F0h,082h,000h,003h,083h,0FFh,083h,000h,03Fh,082h,0FFh,081h,0F0h,082h
        db  000h,003h,083h,0FFh,083h,000h,03Fh,081h,0BFh,081h,0F7h,081h,0F0h,082h,000h,003h,081h,0FBh,081h,0FFh,07Fh,083h,000h
        db  03Fh,081h,0BFh,081h,0F7h,081h,0F0h,082h,000h,003h,081h,0FBh,081h,0FFh,07Fh,083h,000h,03Fh,081h,0BFh,081h,0F7h,081h
        db  0F0h,082h,000h,003h,081h,0FBh,081h,0FFh,07Fh,083h,000h,03Fh,081h,09Fh,081h,0E7h,081h,0F0h,082h,000h,001h,081h,0F9h
        db  081h,0FEh,07Eh,083h,000h,082h,00Fh,081h,0C3h,081h,0C0h,084h,000h,038h,0C5h,000h,001h,081h,0FFh,081h,0FEh,084h,000h
        db  03Fh,081h,0FFh,081h,0F0h,083h,000h,007h,082h,0FFh,081h,080h,083h,000h,07Fh,081h,0FFh,081h,0FCh,083h,000h,007h,082h
        db  0FFh,081h,0C0h,083h,000h,03Fh,081h,0FFh,081h,0FCh,084h,000h,082h,0FFh,081h,080h,084h,000h,03Fh,081h,0F0h,084h,000h
        db  003h,081h,0FEh,085h,000h,07Fh,081h,0E0h,084h,000h,00Fh,081h,0FCh,084h,000h,001h,081h,0FFh,081h,080h,084h,000h,01Fh
        db  081h,0F0h,084h,000h,003h,081h,0FEh,085h,000h,07Fh,081h,0E0h,084h,000h,00Fh,081h,0FCh,084h,000h,001h,081h,0FFh,081h
        db  080h,084h,000h,01Fh,081h,0F0h,084h,000h,003h,081h,0FFh,085h,000h,07Fh,081h,0F0h,084h,000h,00Fh,082h,0FFh,081h,080h
        db  082h,000h,001h,082h,0FFh,081h,0FCh,083h,000h,01Fh,082h,0FFh,081h,0E0h,082h,000h,001h,082h,0FFh,081h,0FEh,083h,000h
        db  00Fh,082h,0FFh,081h,0E0h,083h,000h,07Fh,081h,0FFh,081h,0FCh,083h,000h,001h,082h,0FFh,081h,080h,000h
PGrid   db  0D0h,000h,0D0h,005h          ; Grid value space + Grid colour map
        db  002h,088h,003h,002h          ; Explosion values for squares
        db  003h,088h,004h,003h
        db  003h,088h,004h,003h
        db  003h,088h,004h,003h
        db  003h,088h,004h,003h
        db  003h,088h,004h,003h
        db  003h,088h,004h,003h
        db  002h,088h,003h,002h
        db  0FFh

Bod:                                     ; The uncompressed grid gfx
Cod     EQU $+2880                       ; The start of the logo data
Pod     EQU $+2880+1137                  ; The grid space
Ood     EQU $+2880+1137+80               ; The colour space (player ownership)
Vod     EQU $+2880+1137+160              ; The explosion values
Nod     EQU $+2880+1137+240              ; The colour coded grid gfx
END START

