; gravity.asm - for PT&T optimization contest - 138 bytes
; written by Tylisha C. Andersen
;
; this is actually an enhancement over the original, as the
; stars move much smoother, I hope it is similar enough...
;
; there is really no reason to seed the RNG, as the program
; itself seeds it for the next run -- it doesn't end on the
; same value as it started.

O           equ   offset
B           equ   byte ptr
W           equ   word ptr

xylen       equ   O(xpos)-O(ypos)
splen       equ   O(yspeed)-O(ypos)

.model      tiny
.386
.code
org         100h

;-----------------------------------------------------------
; main program
;-----------------------------------------------------------

start:      mov   ax, 13h           ; switch to mode 13h
            int   10h

            mov   di, O(ypos)       ; di = y-position array = 0A000h
            push  di                ; save for later

            mov   ch, 1             ; cx > 24
randloop:   xor   al, [di]          ; generate next random number
            db    0D4h, 047h        ; divide by 71 (undoc.)
            sub   al, 35            ; subtract 35
            cbw                     ; convert to word
            stosw                   ; store in slot
            loop  randloop

            pop   es                ; es = video memory
            
;-----------------------------------------------------------

mainloop:   mov   cl, 6             ; 6 blocks (cx = 0 here)
            mov   si, es            ; si = 0A000h = y-position array
            mov   ax, 0E06h         ; first color is 06h

drawloop:   imul  di, [si], 320     ; calculate offset
            add   di, [si+xylen]    ; now it never goes off-screen!
            add   di, 32160
            mov   bx, 318           ; bx = row distance

            stosb                   ; draw first line
            add   di, bx            ; move to next line
            stosw                   ; draw second line
            stosb
            add   di, bx            ; move to next line
            stosb                   ; draw third line
            sub   ax, 0101h         ; move to next color

            cmpsw                   ; add 2 to si (bumps di)
            loop  drawloop          ; loop
                                    ; si now points to xpos

            mov   ah, 86h           ; delay for about 1/30 second
            mov   dx, ax            ; cx, al = 0 here
            int   15h

            dec   cx                ; clear the screen (cx = 0)
            rep   stosb

;-----------------------------------------------------------

            xchg  ax, si            ; start with x-arrays

calc:       pusha                   ; save registers
            xchg  bx, ax            ; bx = position array
            lea   si, [bx+splen]    ; si = speed array

            mov   cl, 6             ; 6 blocks (cx = 1 on entry)
            pusha                   ; save for later

moveloop:   lodsw                   ; ax = speed / 8 
            sar   ax, 3
            add   [si-splen-2], ax  ; adjust the position
            loop  moveloop
            
            popa                    ; si = speed array, cx = 6
calcloop:   lodsw                   ; get current speed
            cwd                     ; dx = center, this can produce
                                    ; either 0 or -1, but we don't care

            mov   di, 12            ; 6 blocks + center
comploop:   cmp   [si-splen-2], dx  ; compare the position
            jl    c_incr            ; subtract 1 if less
            je    c_stay            ; add 1 if greater
            dec   ax
c_stay:     dec   ax
c_incr:     inc   ax
            dec   di                ; next block
            dec   di
            mov   dx, [bx+di]       ; dx = position
            jnl   comploop          ; loop

            test  al, 0C0h          ; make sure the speed is
            jpe   speedok           ; between -64 and 64
            mov   al, 03Fh
            xor   al, ah

speedok:    mov   [si-2], ax        ; set new speed
            loop  calcloop          ; loop
            popa                    ; restore registers

            sub   al, xylen         ; do it again with y-arrays
            jz    calc              ; on y-arrays, al = 0

;-----------------------------------------------------------

            mov   ah, 1             ; check for a key
            int   16h
            jz    mainloop          ; loop while no key

Done:       mov   ax, 3             ; switch to text mode
            int   10h
            int   16h               ; eat the key (ah = 0)
            ret                     ; return

;-----------------------------------------------------------
; data area
;-----------------------------------------------------------

org         0A000h                  ; saves a few bytes
ypos        dw    6 dup(?)          ; y position
xpos        dw    6 dup(?)          ; x position
yspeed      dw    6 dup(?)          ; y speed
xspeed      dw    6 dup(?)          ; x speed
    
end start
