(*********************************************)
(*                                           *)
(*          MINIMAL.PAS     March 98         *)
(*                                           *)
(*********************************************)


program minimal;
uses crt, PCL4P;

var
   RetCode : Integer;
   Byte    : Char;
   Port    : Integer;
   BufPtr  : Pointer;
   BufSeg  : Word;

begin   (* main program *)
   (* setup 1K receive buffer *)
   GetMem(BufPtr,1024+16);
   BufSeg := Seg(BufPtr^) + ((Ofs(BufPtr^)+15) SHR 4);
   RetCode := SioRxBuf(COM1, BufSeg, Size1024);
   if SioInfo('I') > 0 then
     begin
       (* setup 128 transmit buffer *)
       GetMem(BufPtr,128+16);
       BufSeg := Seg(BufPtr^) + ((Ofs(BufPtr^)+15) SHR 4);
       RetCode := SioTxBuf(Port, BufSeg, Size128);
     end;
   (* reset port *)
   RetCode := SioReset(COM1,Baud9600);
   (* was port reset ? *)
   if RetCode <> 0 then
     begin
        write('Cannot reset COM1: ');
        RetCode := SioError(RetCode);
        Halt;
     end;
   (* set DTR, RTS & enable FIFO if present *)    
   RetCode := SioDTR(COM1,SET_LINE); 
   RetCode := SioRTS(COM1,SET_LINE);
   RetCode := SioFIFO(COM1,LEVEL_3RD);
   (* begin terminal loop *)
   writeln('Enter terminal loop ( Type ^Z to exit )');
   while TRUE do
      begin
         (* anything incoming over serial port ? *)
         RetCode := SioGetc(COM1,0);
         if RetCode > -1 then Write( chr(RetCode) );
         (* has user pressed keyboard ? *)
         if KeyPressed then
            begin
               (* read keyboard *)
               Byte := ReadKey;
               (* quit if user types ^Z *)
               if Byte = chr($1a) then
                  begin
                     writeln('User typed ^Z');
                     RetCode := SioDone(COM1);
                     Halt;
                  end;
               (* send out over serial line *)
               RetCode := SioPutc(COM1, Byte );
            end
      end
end.
