32.
t!!G
uÀu2S [u2L!I n g M a t h

(Some essential chapters of engineering mathematics),
english version,

Prof. Dr. rer. nat. habil. Helmut Bausch
Ruedersdorfer Str. 40
D-10243 Berlin
Phone/Fax: 049 / 030 / 294 71 74

DOCUMENTATION

CONTENTS:

The program contains all essential numerical and other methods which 
are important for the mathematical education of students of technical or 
economical courses. The program is very easy to manage, and is 
self-explanatory.

APPLICATIONS:

The program
- assists engineers, natural scientists, mathematicians, and economists 
  to carry out mathematical calculations,
- supports private studies of students,
- may be used for demonstrations in lectures and seminars.

ADVANTAGES OF THE PROGRAM:

When comparing IngMath with other mathematical programs it offers the 
following advantages:

- It is extremely simple to use!!
  It is not necessary to read any documentation, so you can fully concentrate 
  on the content! So just mathematical sense has to be put in.
- The program can be applied in a complex manner.
  For instance one can get the numerical solution of a boundary value - 
  or initial value - problem for differential equations and then make a 
  spline interpolation (for this solution).
- The capacity is partly higher than of comparable programs, resp. it 
  completes them, e.g.
  - partial fraction decomposition and exact integration of any rational 
    functions,
  - decomposition of any polynomials,
  - solution of boundary-value and initial-value problems for 
    differential equations and systems containing parameters,
  - non-linear regression and minimization of functions with many variables 
    with free choice of the regression function.
 
The program has been tested extensively, and is being used by many students, 
engineers etc. They emphasize the easy handly and the speed of the program.

ingmueb.doc is a WINWORD 6.0 file with some examples (written in german).

SHORT DESCRIPTION of the program parts:

Linear algebra:
- Systems of linear equations
  (the coefficients may be complex)
- Matrices/vectors:
    Rank
    Linear transformations
    Characteristic polynomials
    Eigenvalues
    Eigenvectors
    Test for symmetry and positive (negative) definiteness
    Inverse matrices
    Determinant
    Vector operations
- Principal-axis transformation (quadrics)
- Optional parameters

Linear programming:
  Arbitrary linear constraints and non-negativity conditions,
  Optional parameters

Transport optimization / shortest-route problem:
  The equilibrium condition "sum of ressources = sum of requirements" 
    must not be achieved,
  Optional parameters

Complex numbers:
  - Complex functions
  - Graphical representation
  - Graphical solution of (in)equalities
  - Numerical solution of equalities
  - Optional parameters

Rational functions:
  -  Decomposition of arbitrary rational functions into partial fractions
  -  Exact indefinite integrals
  -  Definite integrals
  -  For arbitrary polynomials:
     Calculation of all real and complex roots and
     decomposition into real linear and quadratic factors
  -  Graphical representation
  -  Optional parameters
  -  Graphical representation

Functions:
  -  Piecewise defined functions (with optional parameters) and parametric 
     representation are possible, auxilliary function may be defined
  -  Any compositions of 19 basic functions can be used
  -  Roots
  -  Extrema
  -  Inflection points
  -  Exact derivatives
  -  Integration (including improper integrals)
  -  Series (Taylor, Fourier)
  -  Calculation of arc lengt and other applications
  -  Systems of inequalities with one or two variables, 
     representation of (max. 5) implicit functions
  -  Function values and limits
  -  Production of datafiles
  -  Graphical representation
  When calculating limits the answer ?? may come. 
  In this case the wanted value does not exist, or could not be calculated.

Differential equations (DEQ):
  -  Systems or single equations (with optional parameters) up to 5th order
  -  Initial - and boundary - value problems
  -  Runge-Kutta method of 4th order with optimization of steps
  -  Singularity test
  -  Taylor polynomial
  -  Exact solutions for linear DEQs and systems with constant coefficients 
     (according to Euler).
     Solutions of initial-value problems can be compared graphically with the
     relevant numerical solutions. The numerical solution is given according 
     to Runge-Kutta with standard-step-optimization. 
     If you change to the numeric menu you can compare with other demands for 
     exactness. 
     Please notice: If you put the left side of the DEQ equal to the highest 
     derivation the solution provides the exact (multiple) integration of the 
     right side.    
  -  Graphical representation.
     In this part there is a warning if a singular solution can exist 
     (Cauchy conditions for uniqueness are not satisfied). 
     If the program understands the solution to be singular, also the 
     non-singular solution will be  given. Only the latter will be stored. 
     If you are especially interested in the singular solution you obtain the
     results by solving the same problem outside of the graphic.

Spline functions:
  -  Natural cubic splines
  -  Interpolation (Spline and Lagrange)
  -  Fitting (with weighting coefficients)
  -  Data manipulations
  -  Graphical representation

Many variables:
  -  Partial derivatives, derivative in a direction,
     tangent plane and distance to the plane
  -  Double integrals
     (The integration limits for x have to be constant, otherwise
     replace x and y in the function)
  -  Threedimensional graphical representation
  -  Space curves 
     (trihedral, curvature, torsion, arc length, graphical representation)
  -  Minimization of nonlinear functions of max. 8 independent variables 
  -  Nonlinear equations or systems of equations
  -  Linear/quasilinear/nonlinear regression with free choice of the function
     and max. 8 regression coefficients,
     regression by deviance or by sum of absolute differences
     (in the first case of course arbitrary linear or quasilinear approaches)
  -  Data manipulations.
  -  Remarks on the threedimensional graphical representation:
     . At any time you can break off by pressing ESC.
     . If choosing rotation (by menu) each time the picture will rotate by 15
       in the wanted direction (around the y- or z- axis).
     . To get at once more than one rotation move you press the corresponding
       rotation keys several times.
     . The key '5' at any time cancels all rotations (and the original
       picture appeares).

  The nonlinear calculations are produced with a derivationfree direct 
  search method (called PATTERN SEARCH), so you can apply discontinuous 
  functions and piecewise defined functions.
  During the calculation you can change between pattern search and a
  modified gradient method. However the last method is less effective,
  therefore the calculation starts with Pattern search.
  With this part of the program you can also solve extreme value problems 
  with constraints.
  Example:      f(x,y) --> Max
                constraint:     g(x,y)=0
    Functions to be minimized:
        1)     Y= -f(x,y) + 100*(g(x,y))^2
        2)     Y= -f(x,y) + 200*(g(x,y))^2
  If the results correspond you have found a maximum (in  minimum problems 
  the '-' is missing) and the constraint is achieved. 
  If not you increase the weighting factor again (e.g. to 300), etc.
  If a conditional extremun exists you will definitely find it this way.
  If you have several constraints please add corresponding summands in 1) 
  and 2).

Remarks on the graphical representation:
  - If you are using the CD-ROM-version of IngMath (for WINDOWS 95) then 
    the best results you get using true color (32 bit).
  - Every translation of the chosen resp. given picture causes a translation 
    of the co-ordinate system of 25% of the x resp. y interval in the wanted 
    direction.
  - Every magnification (reduction) causes a magnification (reduction) of 
    50% (with reference to center of the system of coordinates)
  - With the left mouse-button the mouse will be activated (for reading the 
    coordinates).
    The right mouse-button continues. The ZOOM function also works when the 
    mouse is active (although the zoom-menu is fade out).
  - Before you finish a graphical representation you see the picture 
    without any menu. So you are able to print out the "pure" picture.
    Then go on by pressing any key!

Input of functions and values:
  - The usual editing keys can be used: cursor keys, backspace, delete, home, 
    end
  - Multiplication symbols are inserted automatically, brackets partly 
    automatic.
  - Decimal numbers can be used either with point or comma.
    Zero before comma must not be put.
  - Numbers can also be put in in E-formate, 
    e.g. 1,3E-5 instead of 1,3*10^-5 (interval: 1E-36 . . 1E36)
  - Function expressions can have up to 254 symbols and can be almost 
    arbitrarily complex (at least 30 pairs of brackets are possible).
  - It does not make any difference if they are put in with small letters or 
    capital letters (or mixed).
  - The following 19 basic functions are available:
        SIN     SINH    ARCSIN  LN      ABS
        COS     COSH    ARCCOS  EXP     SGN
        TAN     TANH    ARCTAN  SQRT    BO
        COT     COTH    ARCCOT  ^ (power)
    Numbers can have 11 digits at most.
    BO is a Boolean function, with 0 (false) resp. 1 (true). 
    Its argument is a proposition. The proposition must exactly contain one 
    of the symbols  <, >, =  or exactly one of the combinations <=, >=, <>. 
    The function BO allows to use piecewise defined functions and to 
    show several functions in one graphic (the function works like a switch, 
    see example 3)
    Examples for allowed functions:
        x^-3+5*x*sin((x-3)^2)/(1+sqrt(arcsin(x)))
        x^sin(x)*bo(pi<x)+tan(x)*bo(x>=1)+bo(x>p*sin(x))
        sin(x)*bo(p=1)+cos(x)*bo(p=2)

TECHNICAL NOTES:
  - The menus can be used by mouse 
    or by cursor keys, home, end and PgUp / PgDn keys.
  - The program contains all necessary procedures to print out or to save the 
    numerical or other results. You can also print out the graphical 
    representations, before having loaded the DOS program GRAPHICS (you must 
    explain the corresponding parameters, if you don't use a matrix printer,
    see DOS manual).
    Using (for instance) the CLIPBOARD of WINDOWS or the program CAMERA
    (in this case series of pictures are possible) you can save colour
    pictures and then print out by WINWORD, CORELDRAW etc.
  - Of course, because the memory is limited, the program has limited
    capacities. It is easy to change that for special cases (please contact 
    the author).
  - In many cases one can use the ESC key to stop the actual program step.
  - You have to start the program by ingmath.bat if some signs are 
    represented not correctly.
    Using WINDOWS 95/98 you have to start ingmathe.pif resp. ing.exe (if you
    have the full CD-ROM-version of IngMath).

The program has been written in PASCAL 7.0 and includes its own formula 
interpreter (UNIT BAUSCH3), which can be applicated in other programs also, 
and is described below.

Documentation (UNIT BAUSCH3)

BAUSCH3 is a highly efficient formula interpreter. You do not have to put 
defined functions into the source text. 
Such functions can be put in as strings in dialogue and evaluated.

Description of capacity and application:
  - Each function can have up to 11 independent variables,
    which must be indicated by    p,q,r,s,t,u,v,w,x,y,z.
    They are defined in the UNIT interface (as REAL). Therefore
    it is not advisable to define these variables in the program.
  - Function values will be calculated with the FUNCTION F defined in the 
    UNIT. 
  - Arguments (as usual) are put in round brackets.
  - After putting in a function it is necessary to check the SYNTAX of the 
    expression.
    For this purpose the UNIT provides a BOOLEAN error function SYNERR.
    If the syntax of the expression is wrong then SYNERR returns the
    value TRUE (otherwise FALSE).
    Call of the function:
      SYNERR(string of all allowed variables, function string, workstring)
  The string of the variables is formed by all used variables. The workstring
  is made in order to enable a very quick calculation of the function values.
  If e.g. A is the function string F(A_) provides the function value which 
  corresponds to actual values of the independent variables.
  Example:   SYNERR('px',A,A_) examines the SYNTAX of the function string A,
             but the variables x and p are allowed only! It provides the
             workstring A_.
  The program may fail without examination of the syntax because
  the interpreter doesn't examine the SYNTAX (this would take too much time)!
  A string variable FEHLER contains a description of the error.
  After each call of a function a BOOLEAN variable ERR can be asked for.
  If there are errors (function not defined) the value TRUE is returned, 
  otherwise the value FALSE.

The UNIT contains a formula editor also. EDIT(A) reads a string A
(max. length: 254 characters) and returns the edited string.
Allowed are the same characters as in the formula interpreter
(excluding the space key).

EXAMPLE OF A PROGRAM:

    USES BAUSCH3;
    VAR A,A_: STRING;
    BEGIN
      A:='';
      WRITE('X= '); READLN(X);
      REPEAT
        WRITE('A= '); EDIT(A);
        IF SYNERR('X',A,A_) THEN WRITELN(FEHLER)
        ELSE WRITELN(F(A_),ERR)
      UNTIL NOT SYNERR('X',A,A_);
      READLN
    END.

There also exists a  UNIT BAUSCH1  for exact derivatives!










 