/******************************************************************************
Fractal Infinity - HARDWARE SPECIFIC FUNCTION HEADER - fr_hware.h.
This file Copyright (C) 1999 Graeme Fenwick- see documentation for details.
******************************************************************************/

#define  NO_KEY   0
#define  ONE      1
#define  NONVALID 2
#define  UP       3
#define  DOWN     4
#define  LEFT     5
#define  RIGHT    6
#define  PLUS     7
#define  MINUS    8
#define  ENTER    9
#define  SAVE     10
#define  SPACE    11
#define  QUIT     12
#define  FLUSH    13

extern int   sxdim, sydim, sdeep;

int                 hardware_setup(int gfx_x, int gfx_y, int gfx_depth);
int                 toggle_draw_mode(void);
unsigned long int   plot_point(int sx, int sy, int maxval, int maxit, int it);
void                info_display(long double mag, long double range,
                                 long double xc,  long double yc);
int                 draw_xhair(int x, int y);
int                 save_display(char *fname); /* can't guarantee const char */
int                 detect_key(int flush);
unsigned            sleep_wrap(unsigned);
int                 message_dialog(char *mes1, char *mes2);
long                verify_imagespace(void);

