//
//
//

#include <fastgl.h>
#include <widgets.h>

#include "rad_def.h"
#include "rad_type.h"
#include "rad_sym.h"

static FILE *fp;
static int nTab;
static int editPresent, accelPresent;
static char symtab[MAX_SYM][SYMSIZE+1], gps2[256];
static int symindex;
static int error;

static char *color_str[]=
{
	"CBLACK","CDARK","CGRAYED","CGRAY1","CGRAY2","CGRAY3","CBLUE","CBLUELIGHT",
	"CGREEN","CGREENLIGHT","CRED","CREDLIGHT","CBROWN","CYELLOW","CWHITED","CWHITE"
};

static char *font_str[]=
{
	"FONT0406",  "FONT0808", "FONT0816", "FONT1222", "FONT1625"
};

static char * Color(int c, char *buf)
{
	if (c<=CWHITE) strcpy(buf, color_str[c]);
	else sprintf(buf,"%d", c);
	return buf;
}

//
// 0 OK, 3-no space, 4 redefine symbol
// FIX symbols with space !!!!
//
int AddSymbol(char *s)
{
	int i;
	if (symindex>=MAX_SYM)
	{
		IError("Too many symbols", 0);
		return error = 3;
	}
	for(i=0; i<symindex; i++) if (strncmp(s,symtab[i],SYMSIZE)==0)
	{
		sprintf(gps, "Symbol %s redefine", s);
		IError(gps, 0);
		return error = 4;
	}
	strncpy(symtab[symindex++], s, SYMSIZE);
	return 0;
}

static char * MangleName(char *s, char *s2=0)
{
	static char name[64];
	char *pom=name, c, *pom2;

	if (s2) pom = s2;
	pom2 = pom+SYMSIZE;
	if (!isalpha(*s) || *s!='_')
		*pom++ = '_';
	for(;pom<pom2;)
	{
		c = *s++;
		if ((*pom=c)==0) break;
		if (!isalnum(c)) c = '_';
		*pom++ = c;
	}
	name[SYMSIZE] = 0;
	return s2?s2:name;
}

void Write(const char *s, int ntab=0)
{
	while(ntab--) fputc('\t', fp);
	fputs(s,fp);
}

void Write2(const char *s)
{
	fputs(s,fp);
}

static void Case(char *s)
{
	Write("case ",nTab++);
	Write(s);
	Write(":\n");
}

static void Break(void)
{
	Write("break;\n", nTab--);
}

static char *GetFnc(RadType t)
{
	char *__str[]={
	"Undefine",
	"WindowText",
	"WindowBox",
	"WindowRect",
	"WindowLine",
	"WindowDrawCircle",
	"AddPushButton",
	"AddCheckButton",
	"AddPointButton",
	"AddEditBox",
	"AddEditBox",
	"AddEditBox",
	"AddSlideBarH",
	"ListBox",
	"AddBaseMenu",
	"WindowFillCircle"
	};

	return __str[t];
}

// generate code for .RC file
static void ConfigStuff(Wind w[], int numwin, Projekt *p, int aa)
{
	int i,j;
	
	if (p->app_cfg==0) return;
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		for(i=0; i<w[j].items; i++)
		{
			if (a[i].flags&ACCF_ADDTORC) switch((int)a[i].type)
			{
			case RAD_LISTBOX:
			case RAD_PUSHBUTTON:
				break;
			case RAD_EDITBOX1:
			case RAD_POINTBUTTON:
			case RAD_CHECKBUTTON:
			case RAD_SLIDEBAR:
				if (a[i].variable[0]>' ')
				{
					if (!aa) sprintf(gps,"cfg->ReadInt(\"%s\",%s);\n", MangleName(a[i].variable), MangleName(a[i].variable));
					else sprintf(gps,"cfg->WriteInt(\"%s\",%s);\n", MangleName(a[i].variable), MangleName(a[i].variable));
					Write(gps,nTab);
				}
				break;
			case RAD_EDITBOX2:
				if (a[i].variable[0]>' ')
				{
					if (!aa) sprintf(gps,"cfg->ReadDouble(\"%s\",%s);\n", MangleName(a[i].variable),MangleName(a[i].variable));
					else sprintf(gps,"cfg->WriteDouble(\"%s\",%s);\n", MangleName(a[i].variable), MangleName(a[i].variable));
					Write(gps,nTab);
				}
				break;
			case RAD_EDITBOX3:
				if (a[i].variable[0]>' ')
				{
					if (!aa) sprintf(gps,"cfg->ReadString(\"%s\",%s,%d);\n", MangleName(a[i].variable),MangleName(a[i].variable),a[i].flags&ACCF_VARSIZE?a[i].ww:a[i].h/8-2);
					else sprintf(gps,"cfg->WriteString(\"%s\",%s);\n", MangleName(a[i].variable),MangleName(a[i].variable));
					Write(gps,nTab);
				}
				break;
			}
		}
	}
}

// generate variable for all window
static void VariableGen(Wind w[], int numwin, Projekt *p)
{
	int i,j,wgn=0;
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		sprintf(gps,"Window *%sPtr;\n", MangleName(w[j].name));
		Write(gps);
		if (p->app_root) Write("Window *rootPtr;\n");
		for(i=0; i<w[j].items; i++)
		{
			switch((int)a[i].type)
			{
			case RAD_LISTBOX:
				sprintf(gps,"static ListBox *widgetPtr%d;\n", wgn++);
				Write(gps);
				break;
			case RAD_EDITBOX1:
				editPresent = 1;
			case RAD_POINTBUTTON:
			case RAD_CHECKBUTTON:
			case RAD_SLIDEBAR:
				if (a[i].variable[0]>' ')
				{
					if (AddSymbol(a[i].variable)) return ;
					sprintf(gps,"static int %s;\n", MangleName(a[i].variable));
					Write(gps);
				}
			case RAD_PUSHBUTTON:
				accelPresent = 1;
				break;
			case RAD_EDITBOX2:
				if (a[i].variable[0]>' ')
				{
					if (AddSymbol(a[i].variable)) return ;
					sprintf(gps,"static double %s;\n", MangleName(a[i].variable));
					Write(gps);
				}
				editPresent = 1;
				break;
			case RAD_EDITBOX3:
				if (a[i].variable[0]>' ')
				{
					if (AddSymbol(a[i].variable)) return ;
					sprintf(gps,"static char %s[%d];\n", MangleName(a[i].variable), a[i].flags&ACCF_VARSIZE?a[i].ww+1:a[i].h/8-1);
					Write(gps);
				}
				editPresent = 1;
				break;
			}
		}
	}
	Write("\n");
}

static void StubGen(Wind w[], int numwin)
{
	char *fnc;
	int i,j;
	
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		nTab = 0;
		for(i=0;i<w[j].items;i++)
		{
			if (a[i].fnc[0]>' ') fnc =	a[i].fnc; else continue;
			switch((int)a[i].type)
			{
				case RAD_LISTBOX:
					if (AddSymbol(fnc)) return ;
					sprintf(gps, "static void %s(int x, int y, int index, int flag, void *data)\n{\n}\n", MangleName(fnc));
					break;
				case RAD_SLIDEBAR:
				case RAD_PUSHBUTTON:
				case RAD_POINTBUTTON:
				case RAD_CHECKBUTTON:
				case RAD_EDITBOX1:
				case RAD_EDITBOX2:
				case RAD_EDITBOX3:
				case RAD_MENU:
					if (AddSymbol(fnc)) return ;
					sprintf(gps, "static void %s(void)\n{\n}\n", MangleName(fnc));
					break;
			}
			Write(gps);
			Write("\n");
		}
	}
}

static int CodeGen(Wind w[], int numwin)
{
	char *var, *fnc, name1[64], name2[64], key[16];
	int i,j,wgn;
	
	for(j=0; j<numwin; j++)
	{
		Accel * a = w[j].table;
		wgn = 0;
		sprintf(gps2, "%sProc", MangleName(w[j].name));
		if (AddSymbol(gps2)) return error;
		sprintf(gps, "static void %sProc(GuiEvent *p)\n{\n", MangleName(w[j].name));
		Write(gps, nTab++);

		if (w->flags & WCLICKABLE)
		{
			Write("int	xWnd = p->GetX();\n", nTab);
			Write("int	yWnd = p->GetY();\n", nTab);
		}
		if (w->flags & WSIZEABLE)
		{
			Write("int	wWnd = p->wnd->GetWW();\n", nTab);
			Write("int	hWnd = p->wnd->GetHW();\n", nTab);
		}
		Write("\n");
		Write("switch(p->Type()) {\n", nTab++);

		Case("INITEVENT");
		Write("set_ppop(_GSET);\n", nTab);

		for(i=0;i<w[j].items;i++)
		{
			if (a[i].variable[0]>' ') var =	MangleName(a[i].variable, name1); else var ="0";
			if (a[i].fnc[0]>' ') fnc =	MangleName(a[i].fnc, name2); else fnc ="0";
			if (a[i].flags&ACCF_PREDEF)
			{
				if (a[i].key<0) strcpy(key, acckey[-a[i].key].name);
			}
			else if (a[i].key>=' ' && a[i].key<=127) sprintf(key,"'%c'", a[i].key);
			else  sprintf(key,"%d", a[i].key);

			switch(a[i].type)
			{
			default:
				assert(0);
				break;
			case RAD_LISTBOX:
				if (!strcmp(fnc, "0"))
				{
					sprintf(gps2, "Missing fnc: %s in ListBox %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				sprintf(gps, "widgetPtr%d = new %s(%d, %d, %d, %d, %d, %d, 0, %s, p->wnd, 0);\n",
					wgn++, GetFnc(a[i].type), a[i].x, a[i].y, a[i].ww, a[i].hh, a[i].w, a[i].h, fnc);
				break;
			case RAD_SLIDEBAR:
				if (!strcmp(var, "0"))
				{
					sprintf(gps2, "Missing variable: %s in Slidebar %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, %s, &%s, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, key, var, fnc);
				break;
			case RAD_POINTBUTTON:
			case RAD_CHECKBUTTON:
				sprintf(gps, "p->wnd->%s(%d, %d, \"%s\", %s, %s%s, %s);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].name, key, *var=='0'?"":"&", var, fnc);
				break;
			case RAD_MENU:
				sprintf(gps, "p->wnd->%s(\"%s\", %s, %s);\n",
					GetFnc(a[i].type), a[i].name, key, fnc);
				break;
			case RAD_STRING:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, \"%s\");\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].name);
				else sprintf(gps, "p->wnd->%s(%d, %d, \"%s\", %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].name, a[i].ink, a[i].paper);
				break;
			case RAD_RECT:
			case RAD_BOX:
			case RAD_LINE:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h);
				else sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].ink);
				break;
			case RAD_EDITBOX1:
			case RAD_EDITBOX2:
				if (!strcmp(var, "0"))
				{
					sprintf(gps2, "Missing variable: %s in EditBox %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				if (!(a[i].flags&ACCF_CHECK)) sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, &%s, %s)",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc);
				else
				{
					if (a[i].type==RAD_EDITBOX1)
					{
						sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, &%s, %s, %d, %d)",
							GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc, a[i].min, a[i].max);
					}
					else
					{
						sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, &%s, %s, %f, %f)",
							GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc, a[i].mind, a[i].maxd);
					}
				}
				if (a[i].flags&ACCF_VARSIZE)
				{
					sprintf(gps2, "(%s)->SetSize(%d)", gps, a[i].ww);
					sprintf(gps,"%s;\n", gps2);
				}
				else sprintf(gps,"%s;\n", gps);
				break;
			case RAD_EDITBOX3:
				if (!strcmp(var, "0"))
				{
					sprintf(gps2, "Missing variable: %s in EditBox %d", w[j].name, i);
					IError(gps2, 0);
					return error = 2; // bad variable member
				}
				sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, %s, %s)",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, var, fnc);
				if (a[i].flags&ACCF_VARSIZE)
				{
					sprintf(gps2, "(%s)->SetSize(%d)", gps, a[i].ww);
					sprintf(gps,"%s;\n", gps2);
				}
				else sprintf(gps,"%s;\n", gps);
				break;
			case RAD_CIRCLE:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w);
				else sprintf(gps, "p->wnd->%s(%d, %d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].ink);
				break;
			case RAD_FILLCIRCLE:
				if (a[i].flags&ACCF_TRANSP) sprintf(gps, "p->wnd->%s(%d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w);
				else sprintf(gps, "p->wnd->%s(%d, %d, %d, %d);\n",
					GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].ink);
				break;
			case RAD_PUSHBUTTON:
				sprintf(gps, "p->wnd->%s(%d, %d, %d, %d, \"%s\", %s, %s);\n",
				GetFnc(a[i].type), a[i].x, a[i].y, a[i].w, a[i].h, a[i].name, key, fnc);
				break;
			}
			Write(gps, nTab);
		}
		Break();

		Case("KEYEVENT");
		Break();

		if (w->flags&WCLICKABLE)
		{
			Case("CLICKLEFTEVENT");
			Break();
			Case("CLICKRIGHTEVENT");
			Break();
		}
		if (w->flags&WSIZEABLE)
		{
			Case("RESIZEEVENT");
			Break();
		}
		if (accelPresent)
		{
			Case("ACCELEVENT");
			Break();
		}
		if (editPresent)
		{
			Case("INPUTEVENT1");
			Break();
		}
		Case("TERMINATEEVENT");
		while(wgn-- > 0)
		{
			sprintf(gps, "delete widgetPtr%d;\n", wgn);
			Write(gps,nTab);
		}
		Break();

		Write("}\n", --nTab);
		Write("}\n\n", --nTab);
	}
	Write("\n");
	return 0;
}

static void ColorGen(char *paleta)
{
	for(int i=16; i<256; i++) if (paleta[i*4]) // if color is used
	{
		sprintf(gps, "cApp->farby->CreateColor(%d, %d, %d, %d);\n", paleta[i*4+1], paleta[i*4+2], paleta[i*4+3], i);
		Write(gps, nTab);
	}	
}

// return 0 if OK else err code
int Compile(Projekt *p)
{
	int retval,i;
	char flagy[256]=", ", name[64], *tmp=name, cs[16], cs2[16];
	symindex = 0;
	error = isCode = 0;
	
	Wind  *w  = p->Okno;
	editPresent = accelPresent = 0;

	strcpy(name, p->prjname);
	while(*tmp>=' ' && *tmp!='.') tmp++;
	*tmp = 0;
	sprintf(gps,"%s.cc",name);
	strcpy(srcname,gps);
	fp=fopen(gps,"w");
	if (fp==NULL) return error = 1; // EOPEN_FILE

	Write("//\n//	source generated by 'FastGL sourcer'\n//\n\n");
	Write("#include <fastgl.h>\n");
	Write("#include <widgets.h>\n\n");
	Write("\n");

	VariableGen(w, p->nwin, p);
	StubGen(w, p->nwin);
	retval = CodeGen(w, p->nwin);
	if (retval) return retval;

		Write("int main(int argc, char **argv)\n{\n");
		nTab++;
		if (p->app_altx) strcat(flagy, "+APP_ENABLEALTX");
		if (p->app_cfg) strcat(flagy, "+APP_CFG");
		if (p->app_magnify) strcat(flagy, "+APP_MAGNIFIER");
		if (p->app_root) strcat(flagy, "+APP_ROOTWINDOW");
		if (p->app_wnd) strcat(flagy, "+APP_WINDOWDATABASE");
		sprintf(gps, "App MyApp(%d, argc, argv, %s%s);\n", p->video_mode, Color(p->back_color,cs), flagy);
		Write(gps, nTab);
		ColorGen(p->paleta);
		if (p->font)
		{
			sprintf(gps, "set_font(%s);\n", font_str[p->font-1]);
			Write(gps, nTab);
		}
		for(i=0; i<p->nwin; i++)
		{
			sprintf(gps, "%sPtr = new Window(&%sPtr, %d, %d, %d, %d, \"%s\", %sProc, %s, %s, 0x%x);\n",
				MangleName(w[i].name), MangleName(w[i].name), w[i].x, w[i].y, w[i].w, w[i].h, w[i].name, MangleName(w[i].name, name), Color(w[i].ink,cs), Color(w[i].paper,cs2), w[i].flags);
			Write(gps, nTab);
		}
		if (p->app_root) Write("rootPtr = cApp->GetRootWindow();\n", nTab);
		ConfigStuff(w, p->nwin, p, 0);
		Write("MyApp.Run();\n", nTab);
		ConfigStuff(w, p->nwin, p, 1);
		for(i=0; i<p->nwin; i++)
		{
			sprintf(gps, "if (%sPtr) delete %sPtr;\n", MangleName(w[i].name), MangleName(w[i].name));
			Write(gps, nTab);
		}
		Write("return 0;\n", nTab);
		nTab--;
		Write("}\n");

	fclose(fp);
	isCode = 1;
	return error;
}

