#include <fastgl.h>

#ifdef __linux__
extern "C" char texture[] asm("_texture");			// bitmap in exe
#else
extern "C" char texture[];			// bitmap in exe
#endif

#ifdef __WATCOMC__
#pragma aux texture "_*"
#endif

int main(int argc, char **argv)
{
	App MyApp(2, argc, argv, 0, APP_ENABLEALTX);

	SetColorFuzzy(2);			// how different colors you get

// NOTE: "in image" file not work in MSDOS Watcom !!!

#if (defined(__WATCOMC__) && defined(__MSDOS__))
	Bitmap a("texture");	//  bitmap file (background texture)
#else
	Bitmap a((void *)texture);	// an in image bitmap (background texture)
#endif
	Bitmap b("texture.bmp");	// create from file

	Bitmap c("new");

	const int h = (Y_width / 100) * 40, w = (X_width / 100) * 40;

	a.BitmapDraw(0,0,X_width,Y_width);				// draw background  (size from header, position 0,0)

	c.BitmapDraw(200, 150, 400, 300);	// draw bitmap rectangle

	// create a window

	Window okno1(0, 20, 20, w, h, "The Window", GuiHwnd(NULL), CBLACK, CWHITED,WFRAMED | WNOPICTO | WTITLED | WUSELAST);

	// fill in with bitmap

	okno1.WindowPutBitmap(0, 0, 0, 0, okno1.GetWW(), okno1.GetHW(), &b);

	// add push button for exit

    okno1.AddPushButton(w - 100, h - 60, 80, 24, "The End", 'E', App::AppDone);

	// set colors

	set_colors(CBLACK, CWHITE);

	// print a message

	okno1.printf(20, 20, " Used colors %d+16=%d \n", 0xf0 - GetFreeColors(), 0xf0 - GetFreeColors() + 16);

	// save okno1 to bitmap file !!!
	Bitmap d(&okno1);
	d.BitmapSave("window");

	// run while button pushed or ALT+X pressed
	MyApp.Run(0);

	return 0;
}
