#ifdef __cplusplus
extern "C" {
#endif

struct _2D
  {
    long int x, y;
  };
struct _3D
  {
    float x, y, z;
  };
struct _IniGl32
  {
    long int XMAX;		//rozmery okna do ktoreho sa kresli

    long int YMAX;
    long int maxvr;		//maximalny pocet vrcholov sceny

    long int maxpo;		//maximalny pocet polygonov

    long int maxtex;		//maximalny pocet textur

    float maxvzd;		//maximalna zobrazovana vzdialenost

    float _8per;		//nekonecno pre perspektivu

    char ZEn;			//inicializacia pre pouzivanie Z-Buffera

  };
//Struktura pre transformaciu objektu
struct TOStat
  {
    float ux, uy, uz;		//uhly otocenia okolo jednotlivych osi

    float ox, oy, oz;		//absolutne suradnice stredu otacania

    float dx, dy, dz;		//relativne suradnice posunutia objektu

    float m;			//zmena mierky vzhladom na stred otacania

  };

extern char *glIni32 (struct _IniGl32 *, long int);
extern void glSetVM32 (char);
extern long int glAddVertex (struct _3D *, long int);
extern int glAddPoly (long int, long int, long int, long int, long int, long int, float, char);
extern int glAddTex (char *, long int);
extern void glTransObj (struct TOStat *, long int);
extern int glCamera (struct TOStat *);
extern int glZCamera (struct TOStat *);

#ifdef __cplusplus
}
#endif
